/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.c.enums.EnumRuntimeData;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.phases.CInterfaceInvocationPlugin;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;

public class CInterfaceEnumTool {
    private final SnippetReflectionProvider snippetReflection;
    private final ResolvedJavaMethod convertJavaToCLongMethod;
    private final ResolvedJavaMethod convertJavaToCIntMethod;
    private final ResolvedJavaMethod convertCToJavaMethod;

    public CInterfaceEnumTool(MetaAccessProvider metaAccess, SnippetReflectionProvider snippetReflection) {
        this.snippetReflection = snippetReflection;
        try {
            this.convertJavaToCLongMethod = metaAccess.lookupJavaMethod((Executable)EnumRuntimeData.class.getDeclaredMethod("convertJavaToCLong", Enum.class));
            this.convertJavaToCIntMethod = metaAccess.lookupJavaMethod((Executable)EnumRuntimeData.class.getDeclaredMethod("convertJavaToCInt", Enum.class));
            this.convertCToJavaMethod = metaAccess.lookupJavaMethod((Executable)EnumRuntimeData.class.getDeclaredMethod("convertCToJava", Long.TYPE));
        }
        catch (NoSuchMethodException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private ResolvedJavaMethod getValueMethodForKind(JavaKind kind) {
        return kind == JavaKind.Long ? this.convertJavaToCLongMethod : this.convertJavaToCIntMethod;
    }

    public ValueNode createEnumValueInvoke(HostedGraphKit kit, EnumInfo enumInfo, JavaKind resultKind, ValueNode arg) {
        ResolvedJavaMethod valueMethod = this.getValueMethodForKind(resultKind);
        int invokeBci = kit.bci();
        MethodCallTargetNode callTarget = this.invokeEnumValue((GraphBuilderTool)kit, CallTargetFactory.from(kit), invokeBci, enumInfo, valueMethod, arg);
        return kit.createInvokeWithExceptionAndUnwind(callTarget, kit.getFrameState(), invokeBci);
    }

    private MethodCallTargetNode invokeEnumValue(GraphBuilderTool b, CallTargetFactory callTargetFactory, int bci, EnumInfo enumInfo, ResolvedJavaMethod valueMethod, ValueNode arg) {
        ResolvedJavaType returnType = (ResolvedJavaType)valueMethod.getSignature().getReturnType(null);
        ValueNode[] args = new ValueNode[]{ConstantNode.forConstant((JavaConstant)this.snippetReflection.forObject((Object)enumInfo.getRuntimeData()), (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph()), arg};
        StampPair returnStamp = StampFactory.forDeclaredType(null, (JavaType)returnType, (boolean)false);
        return (MethodCallTargetNode)b.append((ValueNode)callTargetFactory.createMethodCallTarget(CallTargetNode.InvokeKind.Virtual, valueMethod, args, returnStamp, bci));
    }

    public ValueNode createEnumLookupInvoke(HostedGraphKit kit, ResolvedJavaType enumType, EnumInfo enumInfo, JavaKind parameterKind, ValueNode arg) {
        int invokeBci = kit.bci();
        MethodCallTargetNode callTarget = this.invokeEnumLookup((GraphBuilderTool)kit, CallTargetFactory.from(kit), invokeBci, enumInfo, parameterKind, arg);
        InvokeWithExceptionNode invoke = kit.createInvokeWithExceptionAndUnwind(callTarget, kit.getFrameState(), invokeBci);
        LogicNode instanceOfNode = (LogicNode)kit.append((ValueNode)InstanceOfNode.createAllowNull((TypeReference)TypeReference.createExactTrusted((ResolvedJavaType)enumType), (ValueNode)invoke, null, null));
        ConstantNode enumClass = kit.createConstant((Constant)kit.getConstantReflection().asJavaClass(enumType), JavaKind.Object);
        GuardingNode guard = kit.createCheckThrowingBytecodeException(instanceOfNode, false, BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, new ValueNode[]{invoke, enumClass});
        ObjectStamp resultStamp = StampFactory.object((TypeReference)TypeReference.create(null, (ResolvedJavaType)enumType), (boolean)false);
        return kit.unique((FloatingNode)new PiNode((ValueNode)invoke, (Stamp)resultStamp, guard.asNode()));
    }

    private MethodCallTargetNode invokeEnumLookup(GraphBuilderTool b, CallTargetFactory callTargetFactory, int bci, EnumInfo enumInfo, JavaKind parameterKind, ValueNode arg) {
        ValueNode[] args = new ValueNode[2];
        args[0] = ConstantNode.forConstant((JavaConstant)this.snippetReflection.forObject((Object)enumInfo.getRuntimeData()), (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph());
        assert (!Modifier.isStatic(this.convertCToJavaMethod.getModifiers()) && this.convertCToJavaMethod.getSignature().getParameterCount(false) == 1);
        JavaKind expectedKind = this.convertCToJavaMethod.getSignature().getParameterType(0, null).getJavaKind();
        args[1] = CInterfaceInvocationPlugin.adaptPrimitiveType(b.getGraph(), arg, parameterKind, expectedKind, false);
        ResolvedJavaType convertReturnType = (ResolvedJavaType)this.convertCToJavaMethod.getSignature().getReturnType(null);
        StampPair returnStamp = StampFactory.forDeclaredType(null, (JavaType)convertReturnType, (boolean)false);
        return (MethodCallTargetNode)b.append((ValueNode)callTargetFactory.createMethodCallTarget(CallTargetNode.InvokeKind.Virtual, this.convertCToJavaMethod, args, returnStamp, bci));
    }

    static interface CallTargetFactory {
        public MethodCallTargetNode createMethodCallTarget(CallTargetNode.InvokeKind var1, ResolvedJavaMethod var2, ValueNode[] var3, StampPair var4, int var5);

        public static CallTargetFactory from(BytecodeParser p) {
            return (invokeKind, targetMethod, args, returnStamp, bci) -> p.createMethodCallTarget(invokeKind, targetMethod, args, returnStamp, null);
        }

        public static CallTargetFactory from(HostedGraphKit kit) {
            return kit::createMethodCallTarget;
        }
    }
}

