/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jfr;

import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.jfr.JfrFrameTypeSerializer;
import com.oracle.svm.core.jfr.JfrGCNames;
import com.oracle.svm.core.jfr.JfrManager;
import com.oracle.svm.core.jfr.JfrSerializerSupport;
import com.oracle.svm.core.jfr.JfrThreadStateSerializer;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.traceid.JfrTraceId;
import com.oracle.svm.core.jfr.traceid.JfrTraceIdEpoch;
import com.oracle.svm.core.jfr.traceid.JfrTraceIdMap;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.thread.ThreadListenerFeature;
import com.oracle.svm.core.thread.ThreadListenerSupport;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.jfr.JfrEventSubstitution;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.internal.PlatformMBeanProviderImpl;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jdk.jfr.Configuration;
import jdk.jfr.Event;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.jfc.JFC;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

@AutomaticFeature
public class JfrFeature
implements Feature {
    private static final boolean HOSTED_ENABLED = Boolean.parseBoolean(JfrFeature.getDiagnosticBean().getVMOption("FlightRecorder").getValue());

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        boolean systemSupported = JfrFeature.osSupported();
        if (HOSTED_ENABLED && !systemSupported) {
            throw UserError.abort("FlightRecorder cannot be used to profile the image generator on this platform. The image generator can only be profiled on platforms where FlightRecoder is also supported at run time.", new Object[0]);
        }
        boolean runtimeEnabled = VMInspectionOptions.AllowVMInspection.getValue();
        if (HOSTED_ENABLED && !runtimeEnabled) {
            System.err.println("Warning: When FlightRecoder is used to profile the image generator, it is also automatically enabled in the native image at run time. This can affect the measurements because it can can make the image larger and image build time longer.");
            runtimeEnabled = true;
        }
        return runtimeEnabled && systemSupported;
    }

    private static boolean osSupported() {
        return Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.DARWIN.class);
    }

    private static HotSpotDiagnosticMXBean getDiagnosticBean() {
        try {
            return (HotSpotDiagnosticMXBean)ReflectionUtil.lookupMethod(PlatformMBeanProviderImpl.class, (String)"getDiagnosticMXBean", (Class[])new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Collections.singletonList(ThreadListenerFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"jdk.jfr", (boolean)false);
        ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"java.base", (boolean)false);
        ModuleSupport.exportAndOpenPackageToClass((String)"jdk.jfr", (String)"jdk.jfr.events", (boolean)false, JfrFeature.class);
        ModuleSupport.exportAndOpenPackageToClass((String)"jdk.internal.vm.ci", (String)"jdk.vm.ci.hotspot", (boolean)false, JfrEventSubstitution.class);
        List<Configuration> knownConfigurations = JFC.getConfigurations();
        JVM.getJVM().createNativeJFR();
        ImageSingletons.add(JfrManager.class, (Object)new JfrManager(HOSTED_ENABLED));
        ImageSingletons.add(SubstrateJVM.class, (Object)new SubstrateJVM(knownConfigurations));
        ImageSingletons.add(JfrSerializerSupport.class, (Object)new JfrSerializerSupport());
        ImageSingletons.add(JfrTraceIdMap.class, (Object)new JfrTraceIdMap());
        ImageSingletons.add(JfrTraceIdEpoch.class, (Object)new JfrTraceIdEpoch());
        ImageSingletons.add(JfrGCNames.class, (Object)new JfrGCNames());
        JfrSerializerSupport.get().register(new JfrFrameTypeSerializer());
        JfrSerializerSupport.get().register(new JfrThreadStateSerializer());
        ThreadListenerSupport.get().register(SubstrateJVM.getThreadLocal());
        if (HOSTED_ENABLED) {
            RuntimeClassInitializationSupport rci = (RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class);
            rci.initializeAtBuildTime("jdk.management.jfr", "Allow FlightRecorder to be used at image build time");
            rci.initializeAtBuildTime("com.sun.jmx.mbeanserver", "Allow FlightRecorder to be used at image build time");
            rci.initializeAtBuildTime("com.sun.jmx.defaults", "Allow FlightRecorder to be used at image build time");
            rci.initializeAtBuildTime("java.beans", "Allow FlightRecorder to be used at image build time");
        }
    }

    public void duringSetup(Feature.DuringSetupAccess c) {
        FeatureImpl.DuringSetupAccessImpl config = (FeatureImpl.DuringSetupAccessImpl)c;
        MetaAccessProvider metaAccess = config.getMetaAccess().getWrapped();
        for (Class<Event> eventSubClass : config.findSubclasses(Event.class)) {
            RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{eventSubClass.getName()});
        }
        config.registerSubstitutionProcessor(new JfrEventSubstitution(metaAccess));
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        RuntimeSupport runtime = RuntimeSupport.getRuntimeSupport();
        JfrManager manager = JfrManager.get();
        runtime.addStartupHook(manager.startupHook());
        runtime.addShutdownHook(manager.shutdownHook());
        Class eventClass = access.findClassByName("jdk.internal.event.Event");
        if (eventClass != null) {
            access.registerSubtypeReachabilityHandler(JfrFeature::eventSubtypeReachable, eventClass);
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        int mapSize = ((DynamicHubSupport)ImageSingletons.lookup(DynamicHubSupport.class)).getMaxTypeId() + 1;
        ((JfrTraceIdMap)ImageSingletons.lookup(JfrTraceIdMap.class)).initialize(mapSize);
        Collection<? extends SharedType> types = ((FeatureImpl.CompilationAccessImpl)a).getTypes();
        for (SharedType sharedType : types) {
            DynamicHub hub = sharedType.getHub();
            Class<?> clazz = hub.getHostedJavaClass();
            JfrTraceId.assign(clazz, hub.getTypeID() + 1);
        }
    }

    private static void eventSubtypeReachable(Feature.DuringAnalysisAccess a, Class<?> c) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        if (c.getCanonicalName().equals("jdk.jfr.Event") || c.getCanonicalName().equals("jdk.internal.event.Event") || c.getCanonicalName().equals("jdk.jfr.events.AbstractJDKEvent") || c.getCanonicalName().equals("jdk.jfr.events.AbstractBufferStatisticsEvent")) {
            return;
        }
        try {
            Field f = c.getDeclaredField("eventHandler");
            RuntimeReflection.register((Field[])new Field[]{f});
            access.rescanRoot(f);
            a.requireAnalysisIteration();
        }
        catch (Exception e) {
            throw VMError.shouldNotReachHere("Unable to register eventHandler for: " + c.getCanonicalName(), e);
        }
    }
}

