/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.agent;

import com.oracle.svm.hosted.agent.ClinitGenerationVisitor;
import com.oracle.svm.hosted.agent.NativeImageBytecodeInstrumentationAgentExtension;
import com.oracle.svm.hosted.agent.TracingAdvisor;
import com.oracle.svm.util.AgentSupport;
import java.lang.instrument.Instrumentation;
import java.util.ServiceLoader;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassWriter;

public class NativeImageBytecodeInstrumentationAgent {
    private static TracingAdvisor advisor;

    public static void premain(String agentArgs, Instrumentation inst) {
        if (agentArgs != null && !agentArgs.isEmpty()) {
            advisor = new TracingAdvisor(agentArgs);
            inst.addTransformer(AgentSupport.createClassInstrumentationTransformer(NativeImageBytecodeInstrumentationAgent::applyInitializationTrackingTransformation));
        }
        ServiceLoader<NativeImageBytecodeInstrumentationAgentExtension> extensionLoader = ServiceLoader.load(NativeImageBytecodeInstrumentationAgentExtension.class);
        for (NativeImageBytecodeInstrumentationAgentExtension extension : extensionLoader) {
            extension.addClassFileTransformers(inst);
        }
    }

    private static byte[] applyInitializationTrackingTransformation(String moduleName, ClassLoader loader, String className, byte[] classfileBuffer) {
        if (advisor.shouldTraceClassInitialization(className.replace('/', '.'))) {
            ClassReader reader = new ClassReader(classfileBuffer);
            ClassWriter writer = new ClassWriter(reader, 2);
            ClinitGenerationVisitor visitor = new ClinitGenerationVisitor(writer);
            reader.accept(visitor, 0);
            return writer.toByteArray();
        }
        return classfileBuffer;
    }
}

