/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import java.util.Arrays;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.replacements.ArrayIndexOf;
import org.graalvm.compiler.replacements.ArrayIndexOfNode;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;

@Platforms(value={Platform.AMD64.class, Platform.AARCH64.class})
class ArrayIndexOfForeignCalls {
    static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = (SnippetRuntime.SubstrateForeignCallDescriptor[])Arrays.stream(ArrayIndexOf.STUBS_AARCH64).map(call -> SnippetRuntime.findForeignCall(ArrayIndexOfForeignCalls.class, call.getName(), true, new LocationIdentity[0])).toArray(SnippetRuntime.SubstrateForeignCallDescriptor[]::new);

    ArrayIndexOfForeignCalls() {
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveBS1(byte[] array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S1, (JavaKind)ArrayIndexOf.S1, (boolean)true, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveBS2(byte[] array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S1, (JavaKind)ArrayIndexOf.S2, (boolean)true, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveCS2(char[] array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S2, (JavaKind)ArrayIndexOf.S2, (boolean)true, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfB1S1(byte[] array, long offset, int arrayLength, int fromIndex, int v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S1, (JavaKind)ArrayIndexOf.S1, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfB1S2(byte[] array, long offset, int arrayLength, int fromIndex, int v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S1, (JavaKind)ArrayIndexOf.S2, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfC1S2(char[] array, long offset, int arrayLength, int fromIndex, int v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.S2, (JavaKind)ArrayIndexOf.S2, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveS1(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S1, (boolean)true, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveS2(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S2, (boolean)true, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOfTwoConsecutiveS4(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S4, (boolean)true, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1, (int)v2);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf1S1(Object array, long offset, int arrayLength, int fromIndex, int v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S1, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf1S2(Object array, long offset, int arrayLength, int fromIndex, int v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S2, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static int indexOf1S4(Object array, long offset, int arrayLength, int fromIndex, int v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf((JavaKind)ArrayIndexOf.NONE, (JavaKind)ArrayIndexOf.S4, (boolean)false, (boolean)false, (Object)array, (long)offset, (int)arrayLength, (int)fromIndex, (int)v1);
    }
}

