/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.posix.PosixSystemPropertiesSupport;
import com.oracle.svm.core.posix.headers.Stdlib;
import com.oracle.svm.core.posix.headers.Utsname;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;

public class LinuxSystemPropertiesSupport
extends PosixSystemPropertiesSupport {
    private static final String DEFAULT_LIBPATH = "/usr/lib64:/lib64:/lib:/usr/lib";

    @Override
    protected String tmpdirValue() {
        return "/tmp";
    }

    @Override
    protected String javaLibraryPathValue() {
        CCharPointer ldLibraryPath;
        try (CTypeConversion.CCharPointerHolder name = CTypeConversion.toCString((CharSequence)"LD_LIBRARY_PATH");){
            ldLibraryPath = Stdlib.getenv(name.get());
        }
        if (ldLibraryPath.isNull()) {
            return DEFAULT_LIBPATH;
        }
        return CTypeConversion.toJavaString((CCharPointer)ldLibraryPath) + ":/usr/lib64:/lib64:/lib:/usr/lib";
    }

    @Override
    protected String osNameValue() {
        Utsname.utsname name = (Utsname.utsname)StackValue.get(Utsname.utsname.class);
        if (Utsname.uname(name) >= 0) {
            return CTypeConversion.toJavaString((CCharPointer)name.sysname());
        }
        return "Unknown";
    }

    @Override
    protected String osVersionValue() {
        Utsname.utsname name = (Utsname.utsname)StackValue.get(Utsname.utsname.class);
        if (Utsname.uname(name) >= 0) {
            return CTypeConversion.toJavaString((CCharPointer)name.release());
        }
        return "Unknown";
    }
}

