/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.option.RuntimeOptionValues;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;

public class RuntimeOptionKey<T>
extends OptionKey<T> {
    private final int flags;

    public RuntimeOptionKey(T defaultValue, RuntimeOptionKeyFlag ... flags) {
        super(defaultValue);
        this.flags = RuntimeOptionKey.computeFlags(flags);
    }

    public T getValue() {
        return (T)this.getValue((OptionValues)RuntimeOptionValues.singleton());
    }

    public void update(T value) {
        RuntimeOptionValues.singleton().update(this, value);
    }

    public boolean hasBeenSet() {
        return this.hasBeenSet((OptionValues)RuntimeOptionValues.singleton());
    }

    public boolean shouldCopyToCompilationIsolate() {
        return (this.flags & RuntimeOptionKeyFlag.RelevantForCompilationIsolates.ordinal()) != 0;
    }

    @Fold
    public T getHostedValue() {
        return (T)this.getValue((OptionValues)RuntimeOptionValues.singleton());
    }

    private static int computeFlags(RuntimeOptionKeyFlag[] flags) {
        int result = 0;
        for (RuntimeOptionKeyFlag flag : flags) {
            assert (flag.ordinal() <= 31);
            result |= 1 << flag.ordinal();
        }
        return result;
    }

    public static enum RuntimeOptionKeyFlag {
        RelevantForCompilationIsolates;

    }
}

