/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.traceid;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.thread.VMOperation;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class JfrTraceIdEpoch {
    private static final long EPOCH_0_BIT = 1L;
    private static final long EPOCH_1_BIT = 2L;
    private boolean epoch;

    @Fold
    public static JfrTraceIdEpoch getInstance() {
        return (JfrTraceIdEpoch)ImageSingletons.lookup(JfrTraceIdEpoch.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrTraceIdEpoch() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void changeEpoch() {
        assert (VMOperation.isInProgressAtSafepoint());
        this.epoch = !this.epoch;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    long thisEpochBit() {
        return this.epoch ? 2L : 1L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    long previousEpochBit() {
        return this.epoch ? 1L : 2L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean currentEpoch() {
        return this.epoch;
    }

    @Uninterruptible(reason="Called by uninterruptible code.", mayBeInlined=true)
    public boolean previousEpoch() {
        return !this.epoch;
    }
}

