/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.SubstrateJVM;

public final class JfrNativeEventWriterDataAccess {
    @Uninterruptible(reason="Accesses a JFR buffer", callerMustBe=true)
    public static void initialize(JfrNativeEventWriterData data, JfrBuffer buffer) {
        assert (buffer.isNonNull());
        data.setJfrBuffer(buffer);
        data.setStartPos(buffer.getPos());
        data.setCurrentPos(buffer.getPos());
        data.setEndPos(JfrBufferAccess.getDataEnd(buffer));
    }

    @Uninterruptible(reason="Accesses a JFR buffer", callerMustBe=true)
    public static void initializeThreadLocalNativeBuffer(JfrNativeEventWriterData data) {
        JfrThreadLocal jfrThreadLocal = (JfrThreadLocal)SubstrateJVM.getThreadLocal();
        JfrBuffer nativeBuffer = jfrThreadLocal.getNativeBuffer();
        JfrNativeEventWriterDataAccess.initialize(data, nativeBuffer);
    }
}

