/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.util.ImageHeapMap;
import java.lang.annotation.Annotation;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import sun.reflect.annotation.AnnotationType;

public class AnnotationTypeSupport {
    private final EconomicMap<Class<? extends Annotation>, AnnotationType> annotationTypeMap = ImageHeapMap.create();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void createInstance(Class<? extends Annotation> annotationClass) {
        this.annotationTypeMap.putIfAbsent(annotationClass, (Object)AnnotationType.getInstance(annotationClass));
    }

    public AnnotationType getInstance(Class<? extends Annotation> annotationClass) {
        return (AnnotationType)this.annotationTypeMap.get(annotationClass);
    }
}

