/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.CPUFeatureAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.util.Counter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jdk.vm.ci.code.Architecture;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.VMRuntime;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@InternalVMMethod
public class JavaMainWrapper {
    public static final CGlobalData<CEntryPointCreateIsolateParameters> MAIN_ISOLATE_PARAMETERS = CGlobalDataFactory.createBytes(() -> SizeOf.get(CEntryPointCreateIsolateParameters.class));
    private static UnsignedWord argvLength;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AlwaysInline(value="Single callee from the main entry point.")
    public static int runCore() {
        int exitCode;
        Architecture imageArchitecture = ((SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class))).arch;
        CPUFeatureAccess cpuFeatureAccess = (CPUFeatureAccess)ImageSingletons.lookup(CPUFeatureAccess.class);
        cpuFeatureAccess.verifyHostSupportsArchitecture(imageArchitecture);
        try {
            if (SubstrateOptions.ParseRuntimeOptions.getValue().booleanValue()) {
                VMRuntime.initialize();
            }
            JavaMainSupport mainSupport = (JavaMainSupport)ImageSingletons.lookup(JavaMainSupport.class);
            mainSupport.javaMainHandle.invokeExact(mainSupport.mainArgs);
            exitCode = 0;
        }
        catch (Throwable ex) {
            JavaThreads.dispatchUncaughtException(Thread.currentThread(), ex);
            exitCode = 1;
        }
        finally {
            PlatformThreads.singleton().joinAllNonDaemons();
            RuntimeSupport.getRuntimeSupport().shutdown();
            Counter.logValues(Log.log());
        }
        return exitCode;
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class)
    @CEntryPointOptions(prologue=EnterCreateIsolateWithCArgumentsPrologue.class)
    public static int run(int argc, CCharPointerPointer argv) {
        return JavaMainWrapper.runCore();
    }

    private static boolean isArgumentBlockSupported() {
        if (!Platform.includedIn(Platform.LINUX.class) && !Platform.includedIn(Platform.DARWIN.class)) {
            return false;
        }
        CEntryPointCreateIsolateParameters args = MAIN_ISOLATE_PARAMETERS.get();
        return !args.getArgv().isNull() && args.getArgc() > 0;
    }

    public static int getCRuntimeArgumentBlockLength() {
        if (!JavaMainWrapper.isArgumentBlockSupported()) {
            return -1;
        }
        CEntryPointCreateIsolateParameters args = MAIN_ISOLATE_PARAMETERS.get();
        CCharPointer firstArgPos = args.getArgv().read(0);
        if (argvLength.equal((UnsignedWord)WordFactory.zero())) {
            CCharPointer lastArgPos = args.getArgv().read(args.getArgc() - 1);
            UnsignedWord lastArgLength = SubstrateUtil.strlen(lastArgPos);
            argvLength = WordFactory.unsigned((long)lastArgPos.rawValue()).add(lastArgLength).subtract(WordFactory.unsigned((long)firstArgPos.rawValue()));
        }
        return Math.toIntExact(argvLength.rawValue());
    }

    public static boolean setCRuntimeArgument0(String arg0) {
        if (!JavaMainWrapper.isArgumentBlockSupported()) {
            throw new UnsupportedOperationException("Argument vector support not available");
        }
        boolean arg0truncation = false;
        try (CTypeConversion.CCharPointerHolder arg0Pin = CTypeConversion.toCString((CharSequence)arg0);){
            UnsignedWord origLength;
            CCharPointer arg0Pointer = arg0Pin.get();
            UnsignedWord arg0Length = SubstrateUtil.strlen(arg0Pointer);
            UnsignedWord newArgLength = origLength = WordFactory.unsigned((int)JavaMainWrapper.getCRuntimeArgumentBlockLength());
            if (arg0Length.add(1).belowThan(origLength)) {
                newArgLength = arg0Length.add(1);
            }
            arg0truncation = arg0Length.aboveThan(origLength);
            CCharPointer firstArgPos = MAIN_ISOLATE_PARAMETERS.get().getArgv().read(0);
            UnmanagedMemoryUtil.copy((Pointer)arg0Pointer, (Pointer)firstArgPos, newArgLength);
            UnmanagedMemoryUtil.fill(((Pointer)firstArgPos).add(newArgLength), origLength.subtract(newArgLength), (byte)0);
        }
        return arg0truncation;
    }

    public static String getCRuntimeArgument0() {
        if (!JavaMainWrapper.isArgumentBlockSupported()) {
            throw new UnsupportedOperationException("Argument vector support not available");
        }
        return CTypeConversion.toJavaString((CCharPointer)MAIN_ISOLATE_PARAMETERS.get().getArgv().read(0));
    }

    static {
        Word.ensureInitialized();
        argvLength = (UnsignedWord)WordFactory.zero();
    }

    private static class EnterCreateIsolateWithCArgumentsPrologue
    implements CEntryPointOptions.Prologue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to create the main Isolate.");

        private EnterCreateIsolateWithCArgumentsPrologue() {
        }

        @Uninterruptible(reason="prologue")
        public static void enter(int paramArgc, CCharPointerPointer paramArgv) {
            CEntryPointCreateIsolateParameters args = MAIN_ISOLATE_PARAMETERS.get();
            args.setVersion(3);
            args.setArgc(paramArgc);
            args.setArgv(paramArgv);
            int code = CEntryPointActions.enterCreateIsolate(args);
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }

    public static class JavaMainSupport {
        final MethodHandle javaMainHandle;
        final String javaMainClassName;
        public String[] mainArgs;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public JavaMainSupport(Method javaMainMethod) throws IllegalAccessException {
            this.javaMainHandle = MethodHandles.lookup().unreflect(javaMainMethod);
            this.javaMainClassName = javaMainMethod.getDeclaringClass().getName();
        }

        public String getJavaCommand() {
            if (this.mainArgs != null) {
                StringBuilder commandLine = new StringBuilder(this.javaMainClassName);
                for (String arg : this.mainArgs) {
                    commandLine.append(' ');
                    commandLine.append(arg);
                }
                return commandLine.toString();
            }
            return null;
        }

        public List<String> getInputArguments() {
            CEntryPointCreateIsolateParameters args = MAIN_ISOLATE_PARAMETERS.get();
            if (args.getArgv().isNonNull() && args.getArgc() > 0) {
                String[] unmodifiedArgs = SubstrateUtil.getArgs(args.getArgc(), args.getArgv());
                ArrayList<String> inputArgs = new ArrayList<String>(Arrays.asList(unmodifiedArgs));
                if (this.mainArgs != null) {
                    inputArgs.removeAll(Arrays.asList(this.mainArgs));
                }
                return Collections.unmodifiableList(inputArgs);
            }
            return Collections.emptyList();
        }
    }
}

