/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.function;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.nodes.CEntryPointEnterNode;
import com.oracle.svm.core.graal.nodes.CEntryPointLeaveNode;
import com.oracle.svm.core.graal.nodes.CEntryPointUtilityNode;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.graal.nodes.ReadReservedRegister;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.StateSplitProxyNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.type.CCharPointer;

@AutomaticFeature
public class CEntryPointSupport
implements GraalFeature {
    @Override
    public void registerInvocationPlugins(Providers providers, SnippetReflectionProvider snippetReflection, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        CEntryPointSupport.registerEntryPointActionsPlugins(plugins.getInvocationPlugins());
        CEntryPointSupport.registerCurrentIsolatePlugins(plugins.getInvocationPlugins());
    }

    private static void registerEntryPointActionsPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, CEntryPointActions.class);
        r.register1("enterCreateIsolate", CEntryPointCreateIsolateParameters.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode parameters) {
                b.addPush(JavaKind.Int, (ValueNode)CEntryPointEnterNode.createIsolate(parameters));
                return true;
            }
        });
        r.register2("enterAttachThread", Isolate.class, Boolean.TYPE, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode isolate, ValueNode ensureJavaThreadNode) {
                if (!ensureJavaThreadNode.isConstant()) {
                    b.bailout("Parameter ensureJavaThread of enterAttachThread must be a compile time constant");
                }
                b.addPush(JavaKind.Int, (ValueNode)CEntryPointEnterNode.attachThread(isolate, ensureJavaThreadNode.asJavaConstant().asInt() != 0, false));
                return true;
            }
        });
        r.register1("enter", IsolateThread.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode thread) {
                b.addPush(JavaKind.Int, (ValueNode)CEntryPointEnterNode.enter(thread));
                return true;
            }
        });
        r.register1("enterIsolate", Isolate.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode isolate) {
                b.addPush(JavaKind.Int, (ValueNode)CEntryPointEnterNode.enterIsolate(isolate));
                return true;
            }
        });
        r.register1("enterAttachThreadFromCrashHandler", Isolate.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode isolate) {
                b.addPush(JavaKind.Int, (ValueNode)CEntryPointEnterNode.attachThread(isolate, false, true));
                return true;
            }
        });
        r.register0("leave", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                StateSplitProxyNode proxy = new StateSplitProxyNode(null);
                b.add((ValueNode)proxy);
                b.setStateAfter((StateSplit)proxy);
                b.addPush(JavaKind.Int, (ValueNode)new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.Leave));
                return true;
            }
        });
        r.register0("leaveDetachThread", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                StateSplitProxyNode proxy = new StateSplitProxyNode(null);
                b.add((ValueNode)proxy);
                b.setStateAfter((StateSplit)proxy);
                b.addPush(JavaKind.Int, (ValueNode)new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.DetachThread));
                return true;
            }
        });
        r.register0("leaveTearDownIsolate", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                StateSplitProxyNode proxy = new StateSplitProxyNode(null);
                b.add((ValueNode)proxy);
                b.setStateAfter((StateSplit)proxy);
                b.addPush(JavaKind.Int, (ValueNode)new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.TearDownIsolate));
                return true;
            }
        });
        r.register2("failFatally", Integer.TYPE, CCharPointer.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                b.add((ValueNode)new CEntryPointUtilityNode(CEntryPointUtilityNode.UtilityAction.FailFatally, arg1, arg2));
                LoweredDeadEndNode deadEndNode = (LoweredDeadEndNode)b.add((ValueNode)new LoweredDeadEndNode());
                AbstractBeginNode prevBegin = AbstractBeginNode.prevBegin((FixedNode)deadEndNode);
                if (prevBegin != null && prevBegin.predecessor() instanceof IfNode) {
                    ((IfNode)prevBegin.predecessor()).setProbability(prevBegin, BranchProbabilityNode.EXTREMELY_SLOW_PATH_PROFILE);
                }
                return true;
            }
        });
        r.register1("isCurrentThreadAttachedTo", Isolate.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode isolate) {
                b.addPush(JavaKind.Boolean, (ValueNode)new CEntryPointUtilityNode(CEntryPointUtilityNode.UtilityAction.IsAttached, isolate));
                return true;
            }
        });
    }

    private static void registerCurrentIsolatePlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, CurrentIsolate.class);
        r.register0("getCurrentThread", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                    b.addPush(JavaKind.Object, ReadReservedRegister.createReadIsolateThreadNode(b.getGraph()));
                } else if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                    ValueNode heapBase = b.add(ReadReservedRegister.createReadHeapBaseNode(b.getGraph()));
                    ConstantNode addend = (ConstantNode)b.add((ValueNode)ConstantNode.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)1575L));
                    b.addPush(JavaKind.Object, (ValueNode)new AddNode(heapBase, (ValueNode)addend));
                } else {
                    b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)CEntryPointSetup.SINGLE_THREAD_SENTINEL.rawValue()));
                }
                return true;
            }
        });
        r.register0("getIsolate", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                    b.addPush(JavaKind.Object, ReadReservedRegister.createReadHeapBaseNode(b.getGraph()));
                } else {
                    b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)CEntryPointSetup.SINGLE_ISOLATE_SENTINEL.rawValue()));
                }
                return true;
            }
        });
    }
}

