/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect;

import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.InvocationTargetException;

@InternalVMMethod
public final class ReflectionAccessorHolder {
    static Object invokePrototype(boolean invokeSpecial, Object obj, Object[] args) {
        throw VMError.shouldNotReachHere("Only used as a prototype for generated methods");
    }

    static Object newInstancePrototype(Object[] args) {
        throw VMError.shouldNotReachHere("Only used as a prototype for generated methods");
    }

    private static void methodHandleInvokeError(boolean invokeSpecial, Object obj, Object[] args) throws InvocationTargetException {
        throw new InvocationTargetException(new UnsupportedOperationException("MethodHandle.invoke() and MethodHandle.invokeExact() cannot be invoked through reflection"));
    }

    private static Object newInstanceError(Object[] args) throws InstantiationException {
        throw new InstantiationException("Only non-abstract instance classes can be instantiated using reflection");
    }

    @NeverInline(value="Exception slow path")
    private static InvocationTargetException throwInvocationTargetException(Throwable target) throws InvocationTargetException {
        throw new InvocationTargetException(target);
    }

    @NeverInline(value="Exception slow path")
    private static void throwIllegalArgumentExceptionForMethod(Object member, Object obj, Object[] args) {
        ReflectionAccessorHolder.throwIllegalArgumentException(member, false, obj, args);
    }

    @NeverInline(value="Exception slow path")
    private static void throwIllegalArgumentExceptionForConstructor(Object member, Object[] args) {
        ReflectionAccessorHolder.throwIllegalArgumentException(member, true, null, args);
    }

    private static void throwIllegalArgumentException(Object member, boolean constructor, Object obj, Object[] args) {
        String sep = System.lineSeparator();
        StringBuilder msg = new StringBuilder();
        msg.append("Illegal arguments for invoking ").append(member);
        if (!constructor) {
            msg.append(sep).append("  obj: ").append(obj == null ? "null" : obj.getClass().getTypeName());
        }
        if (args == null) {
            msg.append(sep).append("  args: null");
        } else {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                msg.append(sep).append("  args[").append(i).append("]: ").append(arg == null ? "null" : arg.getClass().getTypeName());
            }
        }
        throw new IllegalArgumentException(msg.toString());
    }
}

