/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization.compression;

import com.oracle.svm.core.jdk.localization.bundles.CompressedBundle;
import com.oracle.svm.core.jdk.localization.compression.utils.BundleSerializationUtils;
import com.oracle.svm.core.jdk.localization.compression.utils.CompressionUtils;
import com.oracle.svm.core.util.VMError;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class GzipBundleCompression {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean canCompress(ResourceBundle bundle) {
        return BundleSerializationUtils.extractContent(bundle).values().stream().allMatch(value -> value instanceof String || value instanceof Object[] && Arrays.stream((Object[])value).allMatch(elem -> elem instanceof String));
    }

    /*
     * Exception decompiling
     */
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static CompressedBundle compress(ResourceBundle bundle) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Object> decompressBundle(byte[] data) {
        try (GZIPInputStream input = new GZIPInputStream(new ByteArrayInputStream(data));){
            int[] indices = GzipBundleCompression.readIndices(input);
            String decompressed = GzipBundleCompression.readText(input);
            Map<String, Object> map = BundleSerializationUtils.deserializeContent(indices, decompressed);
            return map;
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere("Decompressing a resource bundle failed.", e);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void writeIndices(int[] indices, GZIPOutputStream out) throws IOException {
        byte[] indicesInBytes = CompressionUtils.intsToBytes(indices);
        CompressionUtils.writeInt(out, indicesInBytes.length);
        out.write(indicesInBytes);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void writeText(String text, GZIPOutputStream out) throws IOException {
        byte[] textBytes = text.getBytes(StandardCharsets.UTF_8);
        CompressionUtils.writeInt(out, textBytes.length);
        out.write(textBytes);
    }

    private static int[] readIndices(GZIPInputStream input) throws IOException {
        int indicesInBytesLen = CompressionUtils.readInt(input);
        byte[] indicesInBytes = new byte[indicesInBytesLen];
        int realIntsRead = CompressionUtils.readNBytes(input, indicesInBytes);
        assert (realIntsRead == indicesInBytesLen) : "Not enough indices bytes read";
        return CompressionUtils.bytesToInts(indicesInBytes);
    }

    private static String readText(GZIPInputStream input) throws IOException {
        int remainingBytesSize = CompressionUtils.readInt(input);
        byte[] stringBytes = new byte[remainingBytesSize];
        int allBytesRead = CompressionUtils.readNBytes(input, stringBytes);
        assert (allBytesRead == remainingBytesSize) : "Not enough indices bytes read";
        return new String(stringBytes, StandardCharsets.UTF_8);
    }
}

