/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrEarlier;
import com.oracle.svm.core.jdk.LoomJDK;
import com.oracle.svm.core.jdk.NotLoomJDK;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;

@TargetClass(value=Object.class)
final class Target_java_lang_Object {
    Target_java_lang_Object() {
    }

    @Substitute
    @TargetElement(name="registerNatives", onlyWith={JDK11OrEarlier.class})
    private static void registerNativesSubst() {
    }

    @Substitute
    @TargetElement(name="getClass")
    private Object getClassSubst() {
        return KnownIntrinsics.readHub(this);
    }

    @Substitute
    @TargetElement(name="hashCode")
    private int hashCodeSubst() {
        throw VMError.shouldNotReachHere("Intrinsified in SubstrateGraphBuilderPlugins");
    }

    @Substitute
    @TargetElement(name="wait", onlyWith={NotLoomJDK.class})
    private void waitSubst(long timeoutMillis) throws InterruptedException {
        MonitorSupport.singleton().wait(this, timeoutMillis);
    }

    @Substitute
    @TargetElement(name="wait0", onlyWith={LoomJDK.class})
    private void waitSubstLoom(long timeoutMillis) throws InterruptedException {
        MonitorSupport.singleton().wait(this, timeoutMillis);
    }

    @Substitute
    @TargetElement(name="notify")
    private void notifySubst() {
        MonitorSupport.singleton().notify(this, false);
    }

    @Substitute
    @TargetElement(name="notifyAll")
    private void notifyAllSubst() {
        MonitorSupport.singleton().notify(this, true);
    }
}

