/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.heap.HeapSizeVerifier;
import com.oracle.svm.core.jdk.Target_java_lang_Shutdown;
import com.oracle.svm.core.util.VMError;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.VMRuntimeSupport;

public final class RuntimeSupport
implements VMRuntimeSupport {
    private final AtomicReference<InitializationState> initializationState = new AtomicReference<InitializationState>(InitializationState.Uninitialized);
    private final AtomicReference<Runnable[]> startupHooks = new AtomicReference();
    private final AtomicReference<Runnable[]> shutdownHooks = new AtomicReference();
    private final AtomicReference<Runnable[]> initializationHooks = new AtomicReference();
    private final AtomicReference<Runnable[]> tearDownHooks = new AtomicReference();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private RuntimeSupport() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void initializeRuntimeSupport() {
        assert (!ImageSingletons.contains(RuntimeSupport.class)) : "Initializing RuntimeSupport again.";
        ImageSingletons.add(RuntimeSupport.class, (Object)new RuntimeSupport());
    }

    @Fold
    public static RuntimeSupport getRuntimeSupport() {
        return (RuntimeSupport)ImageSingletons.lookup(RuntimeSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addStartupHook(Runnable hook) {
        RuntimeSupport.addHook(this.startupHooks, hook);
    }

    public boolean isUninitialized() {
        return this.initializationState.get() == InitializationState.Uninitialized;
    }

    public void initialize() {
        boolean shouldInitialize = this.initializationState.compareAndSet(InitializationState.Uninitialized, InitializationState.InProgress);
        if (shouldInitialize) {
            HeapSizeVerifier.verifyHeapOptions();
            RuntimeSupport.executeHooks(this.startupHooks);
            VMError.guarantee(this.initializationState.compareAndSet(InitializationState.InProgress, InitializationState.Done), "Only one thread can call the initialization");
        } else if (this.initializationState.get() != InitializationState.Done) {
            throw VMError.shouldNotReachHere("Only one thread can call the initialization");
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addShutdownHook(Runnable hook) {
        RuntimeSupport.addHook(this.shutdownHooks, hook);
    }

    static void executeShutdownHooks() {
        RuntimeSupport.executeHooks(RuntimeSupport.getRuntimeSupport().shutdownHooks);
    }

    public void addInitializationHook(Runnable initHook) {
        RuntimeSupport.addHook(this.initializationHooks, initHook);
    }

    public static void executeInitializationHooks() {
        RuntimeSupport.executeHooks(RuntimeSupport.getRuntimeSupport().initializationHooks);
    }

    public void addTearDownHook(Runnable tearDownHook) {
        RuntimeSupport.addHook(this.tearDownHooks, tearDownHook);
    }

    public static void executeTearDownHooks() {
        RuntimeSupport.executeHooks(RuntimeSupport.getRuntimeSupport().tearDownHooks);
    }

    private static void addHook(AtomicReference<Runnable[]> hooksReference, Runnable newHook) {
        Runnable[] newHooks;
        Runnable[] existingHooks;
        Objects.requireNonNull(newHook);
        do {
            if ((existingHooks = hooksReference.get()) != null) {
                newHooks = Arrays.copyOf(existingHooks, existingHooks.length + 1);
                newHooks[newHooks.length - 1] = newHook;
                continue;
            }
            newHooks = new Runnable[]{newHook};
        } while (!hooksReference.compareAndSet(existingHooks, newHooks));
    }

    private static void executeHooks(AtomicReference<Runnable[]> hooksReference) {
        Runnable[] hooks = hooksReference.getAndSet(null);
        if (hooks != null) {
            for (Runnable hook : hooks) {
                hook.run();
            }
        }
    }

    public void shutdown() {
        Target_java_lang_Shutdown.shutdown();
    }

    private static enum InitializationState {
        Uninitialized,
        InProgress,
        Done;

    }
}

