/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode
public class AMD64SafepointCheckOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64SafepointCheckOp> TYPE = LIRInstructionClass.create(AMD64SafepointCheckOp.class);

    public AMD64SafepointCheckOp() {
        super(TYPE);
    }

    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        assert (SubstrateOptions.MultiThreaded.getValue().booleanValue());
        int safepointRequestedOffset = Safepoint.getThreadLocalSafepointRequestedOffset();
        AMD64Address safepointRequested = new AMD64Address(ReservedRegisters.singleton().getThreadRegister(), safepointRequestedOffset);
        if (ThreadingSupportImpl.isRecurringCallbackSupported()) {
            masm.subl(safepointRequested, 1);
        } else {
            masm.cmpl(safepointRequested, 0);
        }
    }

    public AMD64Assembler.ConditionFlag getConditionFlag() {
        return AMD64Assembler.ConditionFlag.LessEqual;
    }
}

