// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: SubstrateOptions.java
package com.oracle.svm.core;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;

public class SubstrateOptions_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "AOTInline": {
            return OptionDescriptor.create(
                /*name*/ "AOTInline",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Perform method inlining in the AOT compiled native image",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AOTInline",
                /*option*/ SubstrateOptions.AOTInline,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AOTTrivialInline": {
            return OptionDescriptor.create(
                /*name*/ "AOTTrivialInline",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Perform trivial method inlining in the AOT compiled native image",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AOTTrivialInline",
                /*option*/ SubstrateOptions.AOTTrivialInline,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "APIFunctionPrefix": {
            return OptionDescriptor.create(
                /*name*/ "APIFunctionPrefix",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Prefix that is added to the names of API functions.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "APIFunctionPrefix",
                /*option*/ SubstrateOptions.APIFunctionPrefix,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ActiveProcessorCount": {
            return OptionDescriptor.create(
                /*name*/ "ActiveProcessorCount",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Overwrites the available number of processors provided by the OS. Any value <= 0 means using the processor count from the OS.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ActiveProcessorCount",
                /*option*/ SubstrateOptions.ActiveProcessorCount,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllocateInstancePrefetchLines": {
            return OptionDescriptor.create(
                /*name*/ "AllocateInstancePrefetchLines",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Number of cache lines to load after the object address using prefetch instructions.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocateInstancePrefetchLines",
                /*option*/ SubstrateOptions.AllocateInstancePrefetchLines,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllocatePrefetchDistance": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchDistance",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Sets the size (in bytes) of the prefetch distance for object allocation. Memory about to be written with the value of new objects is prefetched up to this distance starting from the address of the last allocated object. Each Java thread has its own allocation point.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocatePrefetchDistance",
                /*option*/ SubstrateOptions.AllocatePrefetchDistance,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllocatePrefetchInstr": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchInstr",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Sets the prefetch instruction to prefetch ahead of the allocation pointer. Possible values are from 0 to 3. The actual instructions behind the values depend on the platform.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocatePrefetchInstr",
                /*option*/ SubstrateOptions.AllocatePrefetchInstr,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllocatePrefetchLines": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchLines",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Number of cache lines to load after the array allocation using prefetch instructions.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocatePrefetchLines",
                /*option*/ SubstrateOptions.AllocatePrefetchLines,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllocatePrefetchStepSize": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchStepSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Sets the step size (in bytes) for sequential prefetch instructions.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocatePrefetchStepSize",
                /*option*/ SubstrateOptions.AllocatePrefetchStepSize,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllocatePrefetchStyle": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchStyle",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Generated code style for prefetch instructions: for 0 or less no prefetch instructions are generated and for 1 or more prefetch instructions are introduced after each allocation.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocatePrefetchStyle",
                /*option*/ SubstrateOptions.AllocatePrefetchStyle,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BuildOutputBreakdowns": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputBreakdowns",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Show code and heap breakdowns as part of the build output",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "BuildOutputBreakdowns",
                /*option*/ SubstrateOptions.BuildOutputBreakdowns,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BuildOutputColorful": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputColorful",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Colorize build output",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "BuildOutputColorful",
                /*option*/ SubstrateOptions.BuildOutputColorful,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BuildOutputGCWarnings": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputGCWarnings",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print GC warnings as part of build output",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "BuildOutputGCWarnings",
                /*option*/ SubstrateOptions.BuildOutputGCWarnings,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BuildOutputLinks": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputLinks",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Show links in build output",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "BuildOutputLinks",
                /*option*/ SubstrateOptions.BuildOutputLinks,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BuildOutputPrefix": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputPrefix",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Prefix build output with '<pid>:<image name>'",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "BuildOutputPrefix",
                /*option*/ SubstrateOptions.BuildOutputPrefix,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BuildOutputProgress": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputProgress",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Report progress in build output",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "BuildOutputProgress",
                /*option*/ SubstrateOptions.BuildOutputProgress,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BuildOutputUseNewStyle": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputUseNewStyle",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use new build output style",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "BuildOutputUseNewStyle",
                /*option*/ SubstrateOptions.BuildOutputUseNewStyle,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CCompilerOption": {
            return OptionDescriptor.create(
                /*name*/ "CCompilerOption",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Provide custom C compiler option used for query code compilation.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CCompilerOption",
                /*option*/ SubstrateOptions.CCompilerOption,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CCompilerPath": {
            return OptionDescriptor.create(
                /*name*/ "CCompilerPath",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Provide custom path to C compiler used for query code compilation and linking.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CCompilerPath",
                /*option*/ SubstrateOptions.CCompilerPath,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CLibraryPath": {
            return OptionDescriptor.create(
                /*name*/ "CLibraryPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Search path for C libraries passed to the linker (list of comma-separated directories)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CLibraryPath",
                /*option*/ SubstrateOptions.CLibraryPath,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CheckToolchain": {
            return OptionDescriptor.create(
                /*name*/ "CheckToolchain",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Check if native-toolchain is known to work with native-image",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CheckToolchain",
                /*option*/ SubstrateOptions.CheckToolchain,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Class": {
            return OptionDescriptor.create(
                /*name*/ "Class",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Class containing the default entry point method. Optional if --shared is used.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Class",
                /*option*/ SubstrateOptions.Class,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CodeAlignment": {
            return OptionDescriptor.create(
                /*name*/ "CodeAlignment",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Alignment of AOT and JIT compiled code in bytes.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CodeAlignment",
                /*option*/ SubstrateOptions.CodeAlignment,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CompilationIsolateAddressSpaceSize": {
            return OptionDescriptor.create(
                /*name*/ "CompilationIsolateAddressSpaceSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "Size of the reserved address space of each compilation isolate (0: default for new isolates).",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CompilationIsolateAddressSpaceSize",
                /*option*/ SubstrateOptions.CompilationIsolateAddressSpaceSize,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CompileInIsolates": {
            return OptionDescriptor.create(
                /*name*/ "CompileInIsolates",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Activate runtime compilation in separate isolates (enable support during image build with option SupportCompileInIsolates).",
                /*declaringClass*/ SubstrateOptions.ConcealedOptions.class,
                /*fieldName*/ "CompileInIsolates",
                /*option*/ SubstrateOptions.ConcealedOptions.CompileInIsolates,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CompilerBackend": {
            return OptionDescriptor.create(
                /*name*/ "CompilerBackend",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Backend used by the compiler",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CompilerBackend",
                /*option*/ SubstrateOptions.CompilerBackend,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ConfigureReflectionMetadata": {
            return OptionDescriptor.create(
                /*name*/ "ConfigureReflectionMetadata",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable runtime instantiation of reflection objects for non-invoked methods.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ConfigureReflectionMetadata",
                /*option*/ SubstrateOptions.ConfigureReflectionMetadata,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DeadlockWatchdogExitOnTimeout": {
            return OptionDescriptor.create(
                /*name*/ "DeadlockWatchdogExitOnTimeout",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Exit the image builder VM after printing call stacks",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DeadlockWatchdogExitOnTimeout",
                /*option*/ SubstrateOptions.DeadlockWatchdogExitOnTimeout,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DeadlockWatchdogInterval": {
            return OptionDescriptor.create(
                /*name*/ "DeadlockWatchdogInterval",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "The interval in minutes between watchdog checks (0 disables the watchdog)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DeadlockWatchdogInterval",
                /*option*/ SubstrateOptions.DeadlockWatchdogInterval,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DebugInfoSourceCacheRoot": {
            return OptionDescriptor.create(
                /*name*/ "DebugInfoSourceCacheRoot",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Directory under which to create source file cache for Application or GraalVM classes",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DebugInfoSourceCacheRoot",
                /*option*/ SubstrateOptions.DebugInfoSourceCacheRoot,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DebugInfoSourceSearchPath": {
            return OptionDescriptor.create(
                /*name*/ "DebugInfoSourceSearchPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Search path for source files for Application or GraalVM classes (list of comma-separated directories or jar files)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DebugInfoSourceSearchPath",
                /*option*/ SubstrateOptions.DebugInfoSourceSearchPath,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DeleteLocalSymbols": {
            return OptionDescriptor.create(
                /*name*/ "DeleteLocalSymbols",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use linker option to remove all local symbols from image.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DeleteLocalSymbols",
                /*option*/ SubstrateOptions.DeleteLocalSymbols,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DetectUserDirectoriesInImageHeap": {
            return OptionDescriptor.create(
                /*name*/ "DetectUserDirectoriesInImageHeap",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "When set to true, the image generator verifies that the image heap does not contain a home directory as a substring",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DetectUserDirectoriesInImageHeap",
                /*option*/ SubstrateOptions.DetectUserDirectoriesInImageHeap,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DiagnosticDetails": {
            return OptionDescriptor.create(
                /*name*/ "DiagnosticDetails",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ String.class,
                /*help*/ "Specifies how many details are printed for certain diagnostic thunks, e.g.: 'DumpThreads:1,DumpRegisters:2'. A value of 1 will result in the maximum amount of information, higher values will print less information. By default, the most detailed output is enabled for all diagnostic thunks. Wildcards (*) are supported in the name of the diagnostic thunk.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DiagnosticDetails",
                /*option*/ SubstrateOptions.DiagnosticDetails,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DisableTypeIdResultVerification": {
            return OptionDescriptor.create(
                /*name*/ "DisableTypeIdResultVerification",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "For internal purposes only. Disables type id result verification even when running with assertions enabled.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DisableTypeIdResultVerification",
                /*option*/ SubstrateOptions.DisableTypeIdResultVerification,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DisableURLProtocols": {
            return OptionDescriptor.create(
                /*name*/ "DisableURLProtocols",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "List of comma separated URL protocols that must never be included.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DisableURLProtocols",
                /*option*/ SubstrateOptions.DisableURLProtocols,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DumpTargetInfo": {
            return OptionDescriptor.create(
                /*name*/ "DumpTargetInfo",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Show native-toolchain information and image-build settings",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DumpTargetInfo",
                /*option*/ SubstrateOptions.DumpTargetInfo,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EnableAllSecurityServices": {
            return OptionDescriptor.create(
                /*name*/ "EnableAllSecurityServices",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Add all security service classes to the generated image.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "EnableAllSecurityServices",
                /*option*/ SubstrateOptions.EnableAllSecurityServices,
                /*deprecated*/ true,
                /*deprecationMessage*/ "");
        }
        case "EnableSignalAPI": {
            return OptionDescriptor.create(
                /*name*/ "EnableSignalAPI",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enables the signal API (sun.misc.Signal or jdk.internal.misc.Signal). Defaults to false for shared library and true for executables",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "EnableSignalAPI",
                /*option*/ SubstrateOptions.EnableSignalAPI,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EnableSignalHandling": {
            return OptionDescriptor.create(
                /*name*/ "EnableSignalHandling",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enables signal handling",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "EnableSignalHandling",
                /*option*/ SubstrateOptions.EnableSignalHandling,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EnableURLProtocols": {
            return OptionDescriptor.create(
                /*name*/ "EnableURLProtocols",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "List of comma separated URL protocols to enable.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "EnableURLProtocols",
                /*option*/ SubstrateOptions.EnableURLProtocols,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EnableWildcardExpansion": {
            return OptionDescriptor.create(
                /*name*/ "EnableWildcardExpansion",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable wildcard expansion in command line arguments on Windows.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "EnableWildcardExpansion",
                /*option*/ SubstrateOptions.EnableWildcardExpansion,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EntryPointNamePrefix": {
            return OptionDescriptor.create(
                /*name*/ "EntryPointNamePrefix",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Prefix that is added to the names of entry point methods.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "EntryPointNamePrefix",
                /*option*/ SubstrateOptions.EntryPointNamePrefix,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FallbackThreshold": {
            return OptionDescriptor.create(
                /*name*/ "FallbackThreshold",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Define when fallback-image generation should be used.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "FallbackThreshold",
                /*option*/ SubstrateOptions.FallbackThreshold,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FlightRecorder": {
            return OptionDescriptor.create(
                /*name*/ "FlightRecorder",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable Java Flight Recorder.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "FlightRecorder",
                /*option*/ SubstrateOptions.FlightRecorder,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FlightRecorderLogging": {
            return OptionDescriptor.create(
                /*name*/ "FlightRecorderLogging",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Usage: -XX:FlightRecorderLogging=[tag1[+tag2...][*][=level][,...]]",
                /*extraHelp*/ new String[] {
                         "",
                         "When this option is not set, logging is enabled at a level of WARNING.",
                         "When this option is set to the empty string, logging is enabled at a level of INFO.",
                         "When this option is set to \"disable\", logging is disabled entirely.",
                         "",
                         "Otherwise, this option expects a comma separated list of tag combinations, each with an optional wildcard (*) and level.",
                         "A tag combination without a level is given a default level of INFO.",
                         "Messages with tags that match a given tag combination are set to log at that tag combination's level.",
                         "If a tag combination does not have a wildcard, then only messages with exactly the same tags are matched.",
                         "Otherwise, messages whose tags are a subset of the tag combination are matched.",
                         "Specifying \"all\" instead of a tag combination matches all tag combinations.",
                         "If more than one tag combination matches a message's tags, the rightmost one will apply.",
                         "Messages with tags that do not have any matching tag combinations are set to log at a default level of WARNING.",
                         "This option is case insensitive.",
                         "",
                         "Available log levels:",
                         "[trace, debug, info, warning, error, off]",
                         "",
                         "Available log tags:",
                         "[jfr, system, event, setting, bytecode, parser, metadata, dcmd]",
                              },
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "FlightRecorderLogging",
                /*option*/ SubstrateOptions.FlightRecorderLogging,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FoldSecurityManagerGetter": {
            return OptionDescriptor.create(
                /*name*/ "FoldSecurityManagerGetter",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Fold SecurityManager getter.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "FoldSecurityManagerGetter",
                /*option*/ SubstrateOptions.FoldSecurityManagerGetter,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ForceNoROSectionRelocations": {
            return OptionDescriptor.create(
                /*name*/ "ForceNoROSectionRelocations",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use only a writable native image heap (requires ld.gold linker)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ForceNoROSectionRelocations",
                /*option*/ SubstrateOptions.ForceNoROSectionRelocations,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "GenerateDebugInfo": {
            return OptionDescriptor.create(
                /*name*/ "GenerateDebugInfo",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Insert debug info into the generated native image or library",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "GenerateDebugInfo",
                /*option*/ SubstrateOptions.GenerateDebugInfo,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ImageSymbolsPrefix": {
            return OptionDescriptor.create(
                /*name*/ "ImageSymbolsPrefix",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Common prefix used by method symbols in image.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ImageSymbolsPrefix",
                /*option*/ SubstrateOptions.ImageSymbolsPrefix,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IncludeMethodData": {
            return OptionDescriptor.create(
                /*name*/ "IncludeMethodData",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Include a list of methods included in the image for runtime inspection.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "IncludeMethodData",
                /*option*/ SubstrateOptions.IncludeMethodData,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IncludeNodeSourcePositions": {
            return OptionDescriptor.create(
                /*name*/ "IncludeNodeSourcePositions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track NodeSourcePositions during runtime-compilation",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "IncludeNodeSourcePositions",
                /*option*/ SubstrateOptions.IncludeNodeSourcePositions,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InstallExitHandlers": {
            return OptionDescriptor.create(
                /*name*/ "InstallExitHandlers",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Provide java.lang.Terminator exit handlers",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "InstallExitHandlers",
                /*option*/ SubstrateOptions.InstallExitHandlers,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InternalSymbolsAreGlobal": {
            return OptionDescriptor.create(
                /*name*/ "InternalSymbolsAreGlobal",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Compatibility option to make symbols used for the image heap global. Using global symbols is problematic for shared libraries because the loader implicitly changes the value when the symbol is already defined in the executable loading the library. Setting this option to true preserves the broken behavior of old Native Image versions.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "InternalSymbolsAreGlobal",
                /*option*/ SubstrateOptions.InternalSymbolsAreGlobal,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InternalThreadStackSize": {
            return OptionDescriptor.create(
                /*name*/ "InternalThreadStackSize",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Long.class,
                /*help*/ "The size of each internal thread stack, in bytes.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "InternalThreadStackSize",
                /*option*/ SubstrateOptions.InternalThreadStackSize,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "JNI": {
            return OptionDescriptor.create(
                /*name*/ "JNI",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable Java Native Interface (JNI) support.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "JNI",
                /*option*/ SubstrateOptions.JNI,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "JNIExportSymbols": {
            return OptionDescriptor.create(
                /*name*/ "JNIExportSymbols",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Export Invocation API symbols.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "JNIExportSymbols",
                /*option*/ SubstrateOptions.JNIExportSymbols,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "JNIVerboseLookupErrors": {
            return OptionDescriptor.create(
                /*name*/ "JNIVerboseLookupErrors",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Report information about known JNI elements when lookup fails",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "JNIVerboseLookupErrors",
                /*option*/ SubstrateOptions.JNIVerboseLookupErrors,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LinkerRPath": {
            return OptionDescriptor.create(
                /*name*/ "LinkerRPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Path passed to the linker as the -rpath (list of comma-separated directories)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "LinkerRPath",
                /*option*/ SubstrateOptions.LinkerRPath,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxDirectMemorySize": {
            return OptionDescriptor.create(
                /*name*/ "MaxDirectMemorySize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "Maximum total size of NIO direct-buffer allocations",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxDirectMemorySize",
                /*option*/ SubstrateOptions.MaxDirectMemorySize,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxInvokesInTrivialMethod": {
            return OptionDescriptor.create(
                /*name*/ "MaxInvokesInTrivialMethod",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of invokes in a method so that it is considered trivial (for testing only).",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxInvokesInTrivialMethod",
                /*option*/ SubstrateOptions.MaxInvokesInTrivialMethod,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxJavaStackTraceDepth": {
            return OptionDescriptor.create(
                /*name*/ "MaxJavaStackTraceDepth",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum number of lines in the stack trace for Java exceptions (0 means all)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxJavaStackTraceDepth",
                /*option*/ SubstrateOptions.MaxJavaStackTraceDepth,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxNodesInTrivialLeafMethod": {
            return OptionDescriptor.create(
                /*name*/ "MaxNodesInTrivialLeafMethod",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of nodes in a method so that it is considered trivial, if it does not have any invokes.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxNodesInTrivialLeafMethod",
                /*option*/ SubstrateOptions.MaxNodesInTrivialLeafMethod,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxNodesInTrivialMethod": {
            return OptionDescriptor.create(
                /*name*/ "MaxNodesInTrivialMethod",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of nodes in a method so that it is considered trivial.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxNodesInTrivialMethod",
                /*option*/ SubstrateOptions.MaxNodesInTrivialMethod,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxUnrolledObjectZeroingStores": {
            return OptionDescriptor.create(
                /*name*/ "MaxUnrolledObjectZeroingStores",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Define the maximum number of stores for which the loop that zeroes out objects is unrolled.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxUnrolledObjectZeroingStores",
                /*option*/ SubstrateOptions.MaxUnrolledObjectZeroingStores,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Method": {
            return OptionDescriptor.create(
                /*name*/ "Method",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Name of the main entry point method. Optional if --shared is used.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Method",
                /*option*/ SubstrateOptions.Method,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Module": {
            return OptionDescriptor.create(
                /*name*/ "Module",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Module containing the class that contains the main entry point. Optional if --shared is used.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Module",
                /*option*/ SubstrateOptions.Module,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MultiThreaded": {
            return OptionDescriptor.create(
                /*name*/ "MultiThreaded",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable support for threads and and thread-local variables (disable for single-threaded implementation)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MultiThreaded",
                /*option*/ SubstrateOptions.MultiThreaded,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Name": {
            return OptionDescriptor.create(
                /*name*/ "Name",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Name of the output file to be generated",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Name",
                /*option*/ SubstrateOptions.Name,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "NeverInline": {
            return OptionDescriptor.create(
                /*name*/ "NeverInline",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Pattern for disabling inlining of methods during image generation.",
                /*extraHelp*/ new String[] {
                         "The syntax for a pattern is:",
                         "",
                         "  SourcePatterns = SourcePattern [\",\" SourcePatterns] .",
                         "  SourcePattern = [ Class \".\" ] method [ \"(\" [ Parameter { \";\" Parameter } ] \")\" ] .",
                         "  Parameter = Class | \"int\" | \"long\" | \"float\" | \"double\" | \"short\" | \"char\" | \"boolean\" .",
                         "  Class = { package \".\" } class .",
                         "",
                         "Glob pattern matching (*, ?) is allowed in all parts of the source pattern.",
                         "",
                         "Examples of method filters:",
                         "---------",
                         "  visit(Argument;BlockScope)",
                         "",
                         "  Matches all methods named \"visit\", with the first parameter of",
                         "  type \"Argument\", and the second parameter of type \"BlockScope\".",
                         "  The packages of the parameter types are irrelevant.",
                         "---------",
                         "  arraycopy(Object;;;;)",
                         "",
                         "  Matches all methods named \"arraycopy\", with the first parameter",
                         "  of type \"Object\", and four more parameters of any type. The",
                         "  packages of the parameter types are irrelevant.",
                         "---------",
                         "  org.graalvm.compiler.core.graph.PostOrderNodeIterator.*",
                         "",
                         "  Matches all methods in the class \"org.graalvm.compiler.core.graph.PostOrderNodeIterator\".",
                         "---------",
                         "  *",
                         "",
                         "  Matches all methods in all classes",
                         "---------",
                         "  org.graalvm.compiler.core.graph.*.visit",
                         "",
                         "  Matches all methods named \"visit\" in classes in the package",
                         "  \"org.graalvm.compiler.core.graph\".",
                         "---------",
                         "  arraycopy,toString",
                         "",
                         "  Matches all methods named \"arraycopy\" or \"toString\", meaning that ',' acts as an or operator.",
                              },
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "NeverInline",
                /*option*/ SubstrateOptions.NeverInline,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OmitInlinedMethodDebugLineInfo": {
            return OptionDescriptor.create(
                /*name*/ "OmitInlinedMethodDebugLineInfo",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Omit generation of DebugLineInfo originating from inlined methods",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "OmitInlinedMethodDebugLineInfo",
                /*option*/ SubstrateOptions.OmitInlinedMethodDebugLineInfo,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Optimize": {
            return OptionDescriptor.create(
                /*name*/ "Optimize",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Integer.class,
                /*help*/ "Control native-image code optimizations: 0 - no optimizations, 1 - basic optimizations, 2 - aggressive optimizations.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Optimize",
                /*option*/ SubstrateOptions.Optimize,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PageSize": {
            return OptionDescriptor.create(
                /*name*/ "PageSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Define PageSize of a machine that runs the image. The default = 0 (== same as host machine page size)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "PageSize",
                /*option*/ SubstrateOptions.PageSize,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ParseOnce": {
            return OptionDescriptor.create(
                /*name*/ "ParseOnce",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "When true, compiler graphs are parsed only once before static analysis. When false, compiler graphs are parsed for static analysis and again for AOT compilation.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ParseOnce",
                /*option*/ SubstrateOptions.ParseOnce,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ParseRuntimeOptions": {
            return OptionDescriptor.create(
                /*name*/ "ParseRuntimeOptions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Parse and consume standard options and system properties from the command line arguments when the VM is created.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ParseRuntimeOptions",
                /*option*/ SubstrateOptions.ParseRuntimeOptions,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Path": {
            return OptionDescriptor.create(
                /*name*/ "Path",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Directory of the image file to be generated",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Path",
                /*option*/ SubstrateOptions.Path,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PreserveFramePointer": {
            return OptionDescriptor.create(
                /*name*/ "PreserveFramePointer",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Saves stack base pointer on the stack on method entry.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "PreserveFramePointer",
                /*option*/ SubstrateOptions.PreserveFramePointer,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "RemoveUnusedSymbols": {
            return OptionDescriptor.create(
                /*name*/ "RemoveUnusedSymbols",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use linker option to prevent unreferenced symbols in image.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "RemoveUnusedSymbols",
                /*option*/ SubstrateOptions.RemoveUnusedSymbols,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReportAnalysisForbiddenType": {
            return OptionDescriptor.create(
                /*name*/ "ReportAnalysisForbiddenType",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Report error if <typename>[:<UsageKind>{,<UsageKind>}] is discovered during analysis (valid values for UsageKind: InHeap, Allocated, Reachable).",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ReportAnalysisForbiddenType",
                /*option*/ SubstrateOptions.ReportAnalysisForbiddenType,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SharedLibrary": {
            return OptionDescriptor.create(
                /*name*/ "SharedLibrary",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Build shared library",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "SharedLibrary",
                /*option*/ SubstrateOptions.SharedLibrary,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SpawnIsolates": {
            return OptionDescriptor.create(
                /*name*/ "SpawnIsolates",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Support multiple isolates.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "SpawnIsolates",
                /*option*/ SubstrateOptions.SpawnIsolates,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StackSize": {
            return OptionDescriptor.create(
                /*name*/ "StackSize",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Long.class,
                /*help*/ "The size of each thread stack at run-time, in bytes.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "StackSize",
                /*option*/ SubstrateOptions.StackSize,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StackTrace": {
            return OptionDescriptor.create(
                /*name*/ "StackTrace",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Provide method names for stack traces.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "StackTrace",
                /*option*/ SubstrateOptions.StackTrace,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StartFlightRecording": {
            return OptionDescriptor.create(
                /*name*/ "StartFlightRecording",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Start flight recording with options.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "StartFlightRecording",
                /*option*/ SubstrateOptions.StartFlightRecording,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StaticExecutable": {
            return OptionDescriptor.create(
                /*name*/ "StaticExecutable",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Build statically linked executable (requires static libc and zlib)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "StaticExecutable",
                /*option*/ SubstrateOptions.StaticExecutable,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StaticExecutableWithDynamicLibC": {
            return OptionDescriptor.create(
                /*name*/ "StaticExecutableWithDynamicLibC",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Builds a statically linked executable with libc dynamically linked",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "StaticExecutableWithDynamicLibC",
                /*option*/ SubstrateOptions.StaticExecutableWithDynamicLibC,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StrictQueryCodeCompilation": {
            return OptionDescriptor.create(
                /*name*/ "StrictQueryCodeCompilation",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use strict checks when performing query code compilation.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "StrictQueryCodeCompilation",
                /*option*/ SubstrateOptions.StrictQueryCodeCompilation,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SupportCompileInIsolates": {
            return OptionDescriptor.create(
                /*name*/ "SupportCompileInIsolates",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Support runtime compilation in separate isolates (enable at runtime with option CompileInIsolates).",
                /*declaringClass*/ SubstrateOptions.ConcealedOptions.class,
                /*fieldName*/ "SupportCompileInIsolates",
                /*option*/ SubstrateOptions.ConcealedOptions.SupportCompileInIsolates,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TargetPlatform": {
            return OptionDescriptor.create(
                /*name*/ "TargetPlatform",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Selects native-image compilation target (in <OS>-<architecture> format). Defaults to host's OS-architecture pair.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TargetPlatform",
                /*option*/ SubstrateOptions.TargetPlatform,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TearDownFailureNanos": {
            return OptionDescriptor.create(
                /*name*/ "TearDownFailureNanos",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "The number of nanoseconds before tearing down an isolate gives a failure message.  0 implies no message.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TearDownFailureNanos",
                /*option*/ SubstrateOptions.TearDownFailureNanos,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TearDownWarningNanos": {
            return OptionDescriptor.create(
                /*name*/ "TearDownWarningNanos",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "The number of nanoseconds before and between which tearing down an isolate gives a warning message.  0 implies no warning.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TearDownWarningNanos",
                /*option*/ SubstrateOptions.TearDownWarningNanos,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceClassInitialization": {
            return OptionDescriptor.create(
                /*name*/ "TraceClassInitialization",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Comma-separated list of fully-qualified class names that class initialization is traced for.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TraceClassInitialization",
                /*option*/ SubstrateOptions.TraceClassInitialization,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceNativeToolUsage": {
            return OptionDescriptor.create(
                /*name*/ "TraceNativeToolUsage",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Trace all native tool invocations as part of image building",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TraceNativeToolUsage",
                /*option*/ SubstrateOptions.TraceNativeToolUsage,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceObjectInstantiation": {
            return OptionDescriptor.create(
                /*name*/ "TraceObjectInstantiation",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Comma-separated list of fully-qualified class names that object instantiation is traced for.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TraceObjectInstantiation",
                /*option*/ SubstrateOptions.TraceObjectInstantiation,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceVMOperations": {
            return OptionDescriptor.create(
                /*name*/ "TraceVMOperations",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Trace VMOperation execution.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TraceVMOperations",
                /*option*/ SubstrateOptions.TraceVMOperations,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseCalleeSavedRegisters": {
            return OptionDescriptor.create(
                /*name*/ "UseCalleeSavedRegisters",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use callee saved registers to reduce spilling for low-frequency calls to stubs (if callee saved registers are supported by the architecture)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseCalleeSavedRegisters",
                /*option*/ SubstrateOptions.UseCalleeSavedRegisters,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseCompressedFrameEncodings": {
            return OptionDescriptor.create(
                /*name*/ "UseCompressedFrameEncodings",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use compressed frame encoding for frames without local values.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseCompressedFrameEncodings",
                /*option*/ SubstrateOptions.UseCompressedFrameEncodings,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseDedicatedVMOperationThread": {
            return OptionDescriptor.create(
                /*name*/ "UseDedicatedVMOperationThread",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if VM operations should be executed in a dedicated thread.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseDedicatedVMOperationThread",
                /*option*/ SubstrateOptions.UseDedicatedVMOperationThread,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseEpsilonGC": {
            return OptionDescriptor.create(
                /*name*/ "UseEpsilonGC",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use a no-op GC",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseEpsilonGC",
                /*option*/ SubstrateOptions.UseEpsilonGC,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseLoom": {
            return OptionDescriptor.create(
                /*name*/ "UseLoom",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Build with Loom JDK",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseLoom",
                /*option*/ SubstrateOptions.UseLoom,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseNullRegion": {
            return OptionDescriptor.create(
                /*name*/ "UseNullRegion",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if a null region is present between the heap base and the image heap.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseNullRegion",
                /*option*/ SubstrateOptions.UseNullRegion,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseReferenceHandlerThread": {
            return OptionDescriptor.create(
                /*name*/ "UseReferenceHandlerThread",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Populate reference queues in a separate thread rather than after a garbage collection.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseReferenceHandlerThread",
                /*option*/ SubstrateOptions.UseReferenceHandlerThread,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseRememberedSet": {
            return OptionDescriptor.create(
                /*name*/ "UseRememberedSet",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if a remembered sets is used, which is necessary for collecting the young and old generation independently.",
                /*declaringClass*/ SubstrateOptions.ConcealedOptions.class,
                /*fieldName*/ "UseRememberedSet",
                /*option*/ SubstrateOptions.ConcealedOptions.UseRememberedSet,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseSerialGC": {
            return OptionDescriptor.create(
                /*name*/ "UseSerialGC",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use a serial GC",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseSerialGC",
                /*option*/ SubstrateOptions.UseSerialGC,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyNamingConventions": {
            return OptionDescriptor.create(
                /*name*/ "VerifyNamingConventions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify naming conventions during image construction.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "VerifyNamingConventions",
                /*option*/ SubstrateOptions.VerifyNamingConventions,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyTypes": {
            return OptionDescriptor.create(
                /*name*/ "VerifyTypes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify type states computed by the static analysis at run time. This is useful when diagnosing problems in the static analysis, but reduces peak performance significantly.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "VerifyTypes",
                /*option*/ SubstrateOptions.VerifyTypes,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 106;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AOTInline");
                    case 1: return get("AOTTrivialInline");
                    case 2: return get("APIFunctionPrefix");
                    case 3: return get("ActiveProcessorCount");
                    case 4: return get("AllocateInstancePrefetchLines");
                    case 5: return get("AllocatePrefetchDistance");
                    case 6: return get("AllocatePrefetchInstr");
                    case 7: return get("AllocatePrefetchLines");
                    case 8: return get("AllocatePrefetchStepSize");
                    case 9: return get("AllocatePrefetchStyle");
                    case 10: return get("BuildOutputBreakdowns");
                    case 11: return get("BuildOutputColorful");
                    case 12: return get("BuildOutputGCWarnings");
                    case 13: return get("BuildOutputLinks");
                    case 14: return get("BuildOutputPrefix");
                    case 15: return get("BuildOutputProgress");
                    case 16: return get("BuildOutputUseNewStyle");
                    case 17: return get("CCompilerOption");
                    case 18: return get("CCompilerPath");
                    case 19: return get("CLibraryPath");
                    case 20: return get("CheckToolchain");
                    case 21: return get("Class");
                    case 22: return get("CodeAlignment");
                    case 23: return get("CompilationIsolateAddressSpaceSize");
                    case 24: return get("CompileInIsolates");
                    case 25: return get("CompilerBackend");
                    case 26: return get("ConfigureReflectionMetadata");
                    case 27: return get("DeadlockWatchdogExitOnTimeout");
                    case 28: return get("DeadlockWatchdogInterval");
                    case 29: return get("DebugInfoSourceCacheRoot");
                    case 30: return get("DebugInfoSourceSearchPath");
                    case 31: return get("DeleteLocalSymbols");
                    case 32: return get("DetectUserDirectoriesInImageHeap");
                    case 33: return get("DiagnosticDetails");
                    case 34: return get("DisableTypeIdResultVerification");
                    case 35: return get("DisableURLProtocols");
                    case 36: return get("DumpTargetInfo");
                    case 37: return get("EnableAllSecurityServices");
                    case 38: return get("EnableSignalAPI");
                    case 39: return get("EnableSignalHandling");
                    case 40: return get("EnableURLProtocols");
                    case 41: return get("EnableWildcardExpansion");
                    case 42: return get("EntryPointNamePrefix");
                    case 43: return get("FallbackThreshold");
                    case 44: return get("FlightRecorder");
                    case 45: return get("FlightRecorderLogging");
                    case 46: return get("FoldSecurityManagerGetter");
                    case 47: return get("ForceNoROSectionRelocations");
                    case 48: return get("GenerateDebugInfo");
                    case 49: return get("ImageSymbolsPrefix");
                    case 50: return get("IncludeMethodData");
                    case 51: return get("IncludeNodeSourcePositions");
                    case 52: return get("InstallExitHandlers");
                    case 53: return get("InternalSymbolsAreGlobal");
                    case 54: return get("InternalThreadStackSize");
                    case 55: return get("JNI");
                    case 56: return get("JNIExportSymbols");
                    case 57: return get("JNIVerboseLookupErrors");
                    case 58: return get("LinkerRPath");
                    case 59: return get("MaxDirectMemorySize");
                    case 60: return get("MaxInvokesInTrivialMethod");
                    case 61: return get("MaxJavaStackTraceDepth");
                    case 62: return get("MaxNodesInTrivialLeafMethod");
                    case 63: return get("MaxNodesInTrivialMethod");
                    case 64: return get("MaxUnrolledObjectZeroingStores");
                    case 65: return get("Method");
                    case 66: return get("Module");
                    case 67: return get("MultiThreaded");
                    case 68: return get("Name");
                    case 69: return get("NeverInline");
                    case 70: return get("OmitInlinedMethodDebugLineInfo");
                    case 71: return get("Optimize");
                    case 72: return get("PageSize");
                    case 73: return get("ParseOnce");
                    case 74: return get("ParseRuntimeOptions");
                    case 75: return get("Path");
                    case 76: return get("PreserveFramePointer");
                    case 77: return get("RemoveUnusedSymbols");
                    case 78: return get("ReportAnalysisForbiddenType");
                    case 79: return get("SharedLibrary");
                    case 80: return get("SpawnIsolates");
                    case 81: return get("StackSize");
                    case 82: return get("StackTrace");
                    case 83: return get("StartFlightRecording");
                    case 84: return get("StaticExecutable");
                    case 85: return get("StaticExecutableWithDynamicLibC");
                    case 86: return get("StrictQueryCodeCompilation");
                    case 87: return get("SupportCompileInIsolates");
                    case 88: return get("TargetPlatform");
                    case 89: return get("TearDownFailureNanos");
                    case 90: return get("TearDownWarningNanos");
                    case 91: return get("TraceClassInitialization");
                    case 92: return get("TraceNativeToolUsage");
                    case 93: return get("TraceObjectInstantiation");
                    case 94: return get("TraceVMOperations");
                    case 95: return get("UseCalleeSavedRegisters");
                    case 96: return get("UseCompressedFrameEncodings");
                    case 97: return get("UseDedicatedVMOperationThread");
                    case 98: return get("UseEpsilonGC");
                    case 99: return get("UseLoom");
                    case 100: return get("UseNullRegion");
                    case 101: return get("UseReferenceHandlerThread");
                    case 102: return get("UseRememberedSet");
                    case 103: return get("UseSerialGC");
                    case 104: return get("VerifyNamingConventions");
                    case 105: return get("VerifyTypes");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
