/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.info;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.info.AccessorInfo;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.InfoTreeVisitor;
import com.oracle.svm.hosted.c.info.PropertyInfo;
import com.oracle.svm.hosted.c.info.SizableInfo;
import org.graalvm.word.LocationIdentity;

public class StructFieldInfo
extends SizableInfo {
    private final PropertyInfo<Integer> offset = this.adoptChild(new PropertyInfo("offset"));
    private LocationIdentity locationIdentity;

    public StructFieldInfo(String name, SizableInfo.ElementKind kind) {
        super(name, kind);
    }

    public PropertyInfo<Integer> getOffsetInfo() {
        return this.offset;
    }

    public AccessorInfo getAccessorInfo() {
        for (ElementInfo child : this.getChildren()) {
            if (!(child instanceof AccessorInfo)) continue;
            return (AccessorInfo)child;
        }
        throw VMError.shouldNotReachHere("must have at least one accessor method that defined the field");
    }

    @Override
    public void accept(InfoTreeVisitor visitor) {
        visitor.visitStructFieldInfo(this);
    }

    @Override
    public Object getAnnotatedElement() {
        for (ElementInfo child : this.getChildren()) {
            if (!(child instanceof AccessorInfo)) continue;
            return child.getAnnotatedElement();
        }
        throw VMError.shouldNotReachHere("must have at least one accessor method that defined the field");
    }

    public LocationIdentity getLocationIdentity() {
        return this.locationIdentity;
    }

    public void setLocationIdentity(LocationIdentity locationIdentity) {
        assert (this.locationIdentity == null);
        this.locationIdentity = locationIdentity;
    }
}

