/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;
import sun.security.jca.Providers;
import sun.security.provider.NativePRNG;
import sun.security.x509.Extension;
import sun.security.x509.OIDMap;

@AutomaticFeature
public class SecurityServicesFeature
extends JNIRegistrationUtil
implements Feature {
    private static final String SUN_PROVIDER = "SUN";
    private static final String SECURE_RANDOM_SERVICE = "SecureRandom";
    private static final String MESSAGE_DIGEST_SERVICE = "MessageDigest";
    private static final String SIGNATURE_SERVICE = "Signature";
    private static final String CIPHER_SERVICE = "Cipher";
    private static final String KEY_AGREEMENT_SERVICE = "KeyAgreement";
    private static final String[] emptyStringArray = new String[0];
    private static final String SEP = " , ";

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return Options.EnableSecurityServicesFeature.getValue();
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(NativePRNG.class, "for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(NativePRNG.Blocking.class, "for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(NativePRNG.NonBlocking.class, "for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(SecurityServicesFeature.clazz((Feature.FeatureAccess)access, "sun.security.provider.SeedGenerator"), "for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(SecurityServicesFeature.clazz((Feature.FeatureAccess)access, "sun.security.provider.SecureRandom$SeederHolder"), "for substitutions");
        if (JavaVersionUtil.JAVA_SPEC >= 11) {
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(SecurityServicesFeature.clazz((Feature.FeatureAccess)access, "sun.security.provider.AbstractDrbg$SeederHolder"), "for substitutions");
        }
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(SecurityServicesFeature.clazz((Feature.FeatureAccess)access, "sun.security.provider.FileInputStreamPool"), "for substitutions");
        }
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(SecurityServicesFeature.clazz((Feature.FeatureAccess)access, "java.util.UUID$Holder"), "for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(SecurityServicesFeature.clazz((Feature.FeatureAccess)access, "sun.security.jca.JCAUtil$CachedSecureRandomHolder"), "for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(SecurityServicesFeature.clazz((Feature.FeatureAccess)access, "com.sun.crypto.provider.SunJCE$SecureRandomHolder"), "for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(SecurityServicesFeature.clazz((Feature.FeatureAccess)access, "sun.security.krb5.Confounder"), "for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(SSLContext.class, "for substitutions");
        if (SubstrateOptions.EnableAllSecurityServices.getValue().booleanValue()) {
            SecurityServicesFeature.prepareSunEC();
        }
    }

    private static void prepareSunEC() {
        JNIRuntimeAccess.register(byte[].class);
    }

    private static List<Provider> getProviders(boolean enableAllSecurityServices) {
        if (enableAllSecurityServices) {
            return Providers.getProviderList().providers();
        }
        Provider sunProvider = Providers.getSunProvider();
        assert (SecurityServicesFeature.isSunProvider(sunProvider));
        return Collections.singletonList(sunProvider);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        access.registerReachabilityHandler(SecurityServicesFeature::registerServicesForReflection, new Object[]{SecurityServicesFeature.method((Feature.FeatureAccess)access, "java.security.Provider$Service", "newInstance", Object.class)});
        access.registerReachabilityHandler(SecurityServicesFeature::linkSunEC, new Object[]{SecurityServicesFeature.method((Feature.FeatureAccess)access, "sun.security.ec.ECDSASignature", "signDigest", byte[].class, byte[].class, byte[].class, byte[].class, Integer.TYPE), SecurityServicesFeature.method((Feature.FeatureAccess)access, "sun.security.ec.ECDSASignature", "verifySignedDigest", byte[].class, byte[].class, byte[].class, byte[].class)});
        if (SecurityServicesFeature.isPosix()) {
            access.registerReachabilityHandler(SecurityServicesFeature::linkJaas, new Object[]{SecurityServicesFeature.method((Feature.FeatureAccess)access, "com.sun.security.auth.module.UnixSystem", "getUnixInfo", new Class[0])});
        }
    }

    private static void registerServicesForReflection(Feature.BeforeAnalysisAccess access) {
        boolean enableAllSecurityServices = SubstrateOptions.EnableAllSecurityServices.getValue();
        Function<String, Class<?>> consParamClassAccessor = SecurityServicesFeature.getConsParamClassAccessor(access);
        SecurityServicesFeature.trace("Registering security services...");
        for (Provider provider : SecurityServicesFeature.getProviders(enableAllSecurityServices)) {
            SecurityServicesFeature.register(provider);
            for (Provider.Service service : provider.getServices()) {
                if (!enableAllSecurityServices && !SecurityServicesFeature.isMessageDigest(service) && !SecurityServicesFeature.isSecureRandom(service)) continue;
                SecurityServicesFeature.register(access, service, consParamClassAccessor);
            }
        }
        if (enableAllSecurityServices) {
            Class javaKeyStoreJks = access.findClassByName("sun.security.provider.JavaKeyStore$JKS");
            SecurityServicesFeature.registerForReflection(javaKeyStoreJks);
            SecurityServicesFeature.trace("Class registered for reflection: " + javaKeyStoreJks);
            Map map = (Map)ReflectionUtil.readStaticField(OIDMap.class, (String)"nameMap");
            for (String name : map.keySet()) {
                try {
                    Class<?> extensionClass = OIDMap.getClass(name);
                    assert (Extension.class.isAssignableFrom(extensionClass));
                    SecurityServicesFeature.registerForReflection(extensionClass);
                    SecurityServicesFeature.trace("Class registered for reflection: " + extensionClass);
                }
                catch (CertificateException e) {
                    throw VMError.shouldNotReachHere(e);
                }
            }
        }
    }

    private static void linkSunEC(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        FeatureImpl.DuringAnalysisAccessImpl a = (FeatureImpl.DuringAnalysisAccessImpl)duringAnalysisAccess;
        NativeLibraries nativeLibraries = a.getNativeLibraries();
        if (nativeLibraries.getStaticLibraryPath("sunec") != null) {
            PlatformNativeLibrarySupport.singleton();
            NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("sunec");
            PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("sun_security_ec");
            nativeLibraries.addLibrary("sunec", true);
            if (SecurityServicesFeature.isPosix()) {
                nativeLibraries.addLibrary("stdc++", false);
            }
        }
    }

    private static void linkJaas(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        JNIRuntimeAccess.register(SecurityServicesFeature.fields((Feature.FeatureAccess)duringAnalysisAccess, "com.sun.security.auth.module.UnixSystem", "username", "uid", "gid", "groups"));
        NativeLibraries nativeLibraries = ((FeatureImpl.DuringAnalysisAccessImpl)duringAnalysisAccess).getNativeLibraries();
        if (nativeLibraries.getStaticLibraryPath("jaas") != null) {
            NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary(JavaVersionUtil.JAVA_SPEC >= 11 ? "jaas" : "jaas_unix");
            PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("com_sun_security_auth_module_UnixSystem");
            nativeLibraries.addLibrary("jaas", true);
        }
    }

    private static Function<String, Class<?>> getConsParamClassAccessor(Feature.BeforeAnalysisAccess access) {
        Map knownEngines = (Map)ReflectionUtil.readStaticField(Provider.class, (String)"knownEngines");
        Field consParamClassNameField = ReflectionUtil.lookupField((Class)access.findClassByName("java.security.Provider$EngineDescription"), (String)"constructorParameterClassName");
        return serviceType -> {
            try {
                Object engineDescription = knownEngines.get(serviceType);
                if (engineDescription == null) {
                    return null;
                }
                String constrParamClassName = (String)consParamClassNameField.get(engineDescription);
                if (constrParamClassName != null) {
                    return access.findClassByName(constrParamClassName);
                }
            }
            catch (IllegalAccessException e) {
                VMError.shouldNotReachHere(e);
            }
            return null;
        };
    }

    private static void register(Provider provider) {
        SecurityServicesFeature.registerForReflection(provider.getClass());
        try {
            Method getVerificationResult = ReflectionUtil.lookupMethod(Class.forName("javax.crypto.JceSecurity"), (String)"getVerificationResult", (Class[])new Class[]{Provider.class});
            getVerificationResult.invoke(null, provider);
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private static void register(Feature.BeforeAnalysisAccess access, Provider.Service service, Function<String, Class<?>> consParamClassAccessor) {
        Class serviceClass = access.findClassByName(service.getClassName());
        if (serviceClass != null) {
            SecurityServicesFeature.registerForReflection(serviceClass);
            Class<?> consParamClass = consParamClassAccessor.apply(service.getType());
            if (consParamClass != null) {
                SecurityServicesFeature.registerForReflection(consParamClass);
                SecurityServicesFeature.trace("Parameter class registered: " + consParamClass);
            }
            if (SecurityServicesFeature.isSignature(service) || SecurityServicesFeature.isCipher(service) || SecurityServicesFeature.isKeyAgreement(service)) {
                for (String keyClassName : SecurityServicesFeature.getSupportedKeyClasses(service)) {
                    Class keyClass = access.findClassByName(keyClassName);
                    if (keyClass == null) continue;
                    SecurityServicesFeature.registerForReflection(keyClass);
                }
            }
            SecurityServicesFeature.trace("Service registered: " + SecurityServicesFeature.asString(service));
        } else {
            SecurityServicesFeature.trace("Service registration failed: " + SecurityServicesFeature.asString(service) + ". Cause: class not found " + service.getClassName());
        }
    }

    private static void registerForReflection(Class<?> clazz) {
        RuntimeReflection.register((Class[])new Class[]{clazz});
        RuntimeReflection.register((Executable[])clazz.getConstructors());
    }

    private static boolean isSunProvider(Provider provider) {
        return provider.getName().equals(SUN_PROVIDER);
    }

    private static boolean isSecureRandom(Provider.Service s) {
        return s.getType().equals(SECURE_RANDOM_SERVICE);
    }

    private static boolean isMessageDigest(Provider.Service s) {
        return s.getType().equals(MESSAGE_DIGEST_SERVICE);
    }

    private static boolean isSignature(Provider.Service s) {
        return s.getType().equals(SIGNATURE_SERVICE);
    }

    private static boolean isCipher(Provider.Service s) {
        return s.getType().equals(CIPHER_SERVICE);
    }

    private static boolean isKeyAgreement(Provider.Service s) {
        return s.getType().equals(KEY_AGREEMENT_SERVICE);
    }

    private static String[] getSupportedKeyClasses(Provider.Service s) {
        assert (SecurityServicesFeature.isSignature(s) || SecurityServicesFeature.isCipher(s) || SecurityServicesFeature.isKeyAgreement(s));
        String supportedKeyClasses = s.getAttribute("SupportedKeyClasses");
        if (supportedKeyClasses != null) {
            return supportedKeyClasses.split("\\|");
        }
        return emptyStringArray;
    }

    private static String asString(Provider.Service s) {
        String str = "Provider = " + s.getProvider().getName() + SEP;
        str = str + "Type = " + s.getType() + SEP;
        str = str + "Algorithm = " + s.getAlgorithm() + SEP;
        str = str + "Class = " + s.getClassName();
        if (SecurityServicesFeature.isSignature(s) || SecurityServicesFeature.isCipher(s) || SecurityServicesFeature.isKeyAgreement(s)) {
            str = str + " , SupportedKeyClasses = " + Arrays.toString(SecurityServicesFeature.getSupportedKeyClasses(s));
        }
        return str;
    }

    private static void trace(String trace) {
        if (Options.TraceSecurityServices.getValue().booleanValue()) {
            System.out.println(trace);
        }
    }

    static class Options {
        @Option(help={"Enable the feature that provides support for security services."})
        public static final HostedOptionKey<Boolean> EnableSecurityServicesFeature = new HostedOptionKey<Boolean>(true);
        @Option(help={"Enable trace logging for the security services feature."})
        static final HostedOptionKey<Boolean> TraceSecurityServices = new HostedOptionKey<Boolean>(false);

        Options() {
        }
    }
}

