/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import com.oracle.graal.pointsto.reports.StatisticsPrinter;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.svm.util.ImageBuildStatistics;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.nativeimage.ImageSingletons;

public class TimerCollection
implements ImageBuildStatistics.TimerCollectionPrinter {
    private final Map<String, Timer> timers = new ConcurrentHashMap<String, Timer>();
    private final String imageName;

    public static TimerCollection singleton() {
        return (TimerCollection)ImageSingletons.lookup(TimerCollection.class);
    }

    public TimerCollection(String imageName) {
        this.imageName = imageName;
    }

    public Timer get(String name) {
        Timer timer = this.timers.get(name);
        GraalError.guarantee((timer != null ? 1 : 0) != 0, (String)"Timer with name %s not found.", (Object)name);
        return timer;
    }

    public Timer get(Registry type) {
        return this.timers.computeIfAbsent(type.name, name -> new Timer(this.imageName, (String)name, type.autoPrint));
    }

    public static Timer.StopTimer createTimerAndStart(String prefix, String name) {
        return TimerCollection.singleton().createTimer(prefix, name).start();
    }

    public static Timer.StopTimer createTimerAndStart(Registry type) {
        return TimerCollection.singleton().get(type).start();
    }

    public Timer createTimer(String name) {
        return this.createTimer(null, name, true);
    }

    public Timer createTimer(String prefix, String name) {
        return this.createTimer(prefix, name, true);
    }

    public Timer createTimer(String name, boolean autoPrint) {
        return this.createTimer(null, name, autoPrint);
    }

    public Timer createTimer(String prefix, String name, boolean autoPrint) {
        GraalError.guarantee((!this.timers.containsKey(name) ? 1 : 0) != 0, (String)"Name %s for a timer is already taken.", (Object)name);
        Timer timer = new Timer(prefix, name, autoPrint);
        this.timers.put(timer.getName(), timer);
        return timer;
    }

    public void printTimerStats(PrintWriter out) {
        Iterator<Timer> it = this.timers.values().iterator();
        while (it.hasNext()) {
            Timer timer = it.next();
            StatisticsPrinter.print(out, timer.getName() + "_time", (int)timer.getTotalTime());
            if (it.hasNext()) {
                StatisticsPrinter.print(out, timer.getName() + "_memory", timer.getTotalMemory());
                continue;
            }
            StatisticsPrinter.printLast(out, timer.getName() + "_memory", timer.getTotalMemory());
        }
    }

    public static enum Registry {
        TOTAL("total", false),
        SETUP("setup", true),
        CLASSLIST("classlist", false),
        CLINIT("(clinit)", true),
        FEATURES("(features)", false),
        VERIFY_HEAP("(verify)", false),
        ANALYSIS("analysis", true),
        UNIVERSE("universe", true),
        COMPILE_TOTAL("compile", true),
        PARSE("(parse)", true),
        INLINE("(inline)", true),
        COMPILE("(compile)", true),
        DEBUG_INFO("dbginfo", true),
        IMAGE("image", true),
        WRITE("write", true);

        public final String name;
        public final boolean autoPrint;

        private Registry(String name, boolean autoPrint) {
            this.name = name;
            this.autoPrint = autoPrint;
        }
    }
}

