/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.api.DefaultUnsafePartition;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.ContextInsensitiveFieldTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AtomicUtils;
import com.oracle.graal.pointsto.util.ConcurrentLightHashSet;
import com.oracle.svm.util.UnsafePartitionKind;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.util.GuardedAnnotationAccess;

public abstract class AnalysisField
implements ResolvedJavaField,
OriginalFieldProvider {
    private static final AtomicReferenceFieldUpdater<AnalysisField, Object> OBSERVERS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AnalysisField.class, Object.class, "observers");
    private final int id;
    public final ResolvedJavaField wrapped;
    private FieldTypeFlow staticFieldFlow;
    private FieldTypeFlow initialInstanceFieldFlow;
    private ContextInsensitiveFieldTypeFlow instanceFieldFlow;
    private AtomicBoolean isAccessed = new AtomicBoolean();
    private AtomicBoolean isRead = new AtomicBoolean();
    private AtomicBoolean isWritten = new AtomicBoolean();
    private AtomicBoolean isFolded = new AtomicBoolean();
    private boolean isJNIAccessed;
    private boolean isUsedInComparison;
    private AtomicBoolean isUnsafeAccessed;
    private AtomicBoolean unsafeFrozenTypeState;
    private volatile Object observers;
    private boolean canBeNull;
    private ConcurrentMap<MethodTypeFlow, Boolean> readBy;
    private ConcurrentMap<MethodTypeFlow, Boolean> writtenBy;
    protected TypeState instanceFieldTypeState;
    protected int position;
    protected final AnalysisType declaringClass;
    protected final AnalysisType fieldType;

    public AnalysisField(AnalysisUniverse universe, ResolvedJavaField wrappedField) {
        assert (!wrappedField.isInternal());
        this.position = -1;
        this.isUnsafeAccessed = new AtomicBoolean();
        this.unsafeFrozenTypeState = new AtomicBoolean();
        this.wrapped = wrappedField;
        this.id = universe.nextFieldId.getAndIncrement();
        boolean trackAccessChain = (Boolean)PointstoOptions.TrackAccessChain.getValue(universe.hostVM().options());
        this.readBy = trackAccessChain ? new ConcurrentHashMap() : null;
        this.writtenBy = trackAccessChain ? new ConcurrentHashMap() : null;
        this.declaringClass = universe.lookup((JavaType)wrappedField.getDeclaringClass());
        this.fieldType = AnalysisField.getDeclaredType(universe, wrappedField);
        this.isUsedInComparison = false;
        if (this.isStatic()) {
            this.canBeNull = false;
            this.staticFieldFlow = new FieldTypeFlow(this, this.getType());
            this.initialInstanceFieldFlow = null;
        } else {
            this.canBeNull = true;
            this.instanceFieldFlow = new ContextInsensitiveFieldTypeFlow(this, this.getType());
            this.initialInstanceFieldFlow = new FieldTypeFlow(this, this.getType());
        }
    }

    private AnalysisUniverse getUniverse() {
        return this.declaringClass.getUniverse();
    }

    private static AnalysisType getDeclaredType(AnalysisUniverse universe, ResolvedJavaField wrappedField) {
        ResolvedJavaType resolvedType;
        try {
            resolvedType = wrappedField.getType().resolve(universe.substitutions.resolve(wrappedField.getDeclaringClass()));
        }
        catch (LinkageError e) {
            return universe.objectType();
        }
        return universe.lookup((JavaType)resolvedType);
    }

    public void copyAccessInfos(AnalysisField other) {
        this.isAccessed = new AtomicBoolean(other.isAccessed.get());
        this.isUnsafeAccessed = other.isUnsafeAccessed;
        this.canBeNull = other.canBeNull;
        this.isWritten = new AtomicBoolean(other.isWritten.get());
        this.isFolded = new AtomicBoolean(other.isFolded.get());
        this.isRead = new AtomicBoolean(other.isRead.get());
        this.notifyUpdateAccessInfo();
    }

    public void intersectAccessInfos(AnalysisField other) {
        this.isAccessed = new AtomicBoolean(this.isAccessed.get() && other.isAccessed.get());
        this.canBeNull = this.canBeNull && other.canBeNull;
        this.isWritten = new AtomicBoolean(this.isWritten.get() && other.isWritten.get());
        this.isFolded = new AtomicBoolean(this.isFolded.get() && other.isFolded.get());
        this.isRead = new AtomicBoolean(this.isRead.get() && other.isRead.get());
        this.notifyUpdateAccessInfo();
    }

    public void clearAccessInfos() {
        this.isAccessed.set(false);
        this.canBeNull = true;
        this.isWritten.set(false);
        this.isFolded.set(false);
        this.isRead.set(false);
        this.notifyUpdateAccessInfo();
    }

    public int getId() {
        return this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public JavaKind getStorageKind() {
        return this.fieldType.getStorageKind();
    }

    public TypeState getTypeState() {
        if (this.getType().getStorageKind() != JavaKind.Object) {
            return null;
        }
        if (this.isStatic()) {
            return this.interceptTypeState(this.staticFieldFlow.getState());
        }
        return this.getInstanceFieldTypeState();
    }

    public TypeState getInstanceFieldTypeState() {
        return this.interceptTypeState(this.instanceFieldFlow.getState());
    }

    public FieldTypeFlow getInitialInstanceFieldFlow() {
        return this.initialInstanceFieldFlow;
    }

    public FieldTypeFlow getStaticFieldFlow() {
        assert (Modifier.isStatic(this.getModifiers()));
        return this.staticFieldFlow;
    }

    public ContextInsensitiveFieldTypeFlow getInstanceFieldFlow() {
        assert (!Modifier.isStatic(this.getModifiers()));
        return this.instanceFieldFlow;
    }

    public void cleanupAfterAnalysis() {
        this.staticFieldFlow = null;
        this.instanceFieldFlow = null;
        this.initialInstanceFieldFlow = null;
        this.readBy = null;
        this.writtenBy = null;
        this.instanceFieldTypeState = null;
    }

    public boolean registerAsAccessed() {
        boolean firstAttempt = AtomicUtils.atomicMark(this.isAccessed);
        this.notifyUpdateAccessInfo();
        if (firstAttempt) {
            this.getUniverse().onFieldAccessed(this);
            this.getUniverse().getHeapScanner().onFieldRead(this);
        }
        return firstAttempt;
    }

    public boolean registerAsRead(MethodTypeFlow method) {
        boolean firstAttempt = AtomicUtils.atomicMark(this.isRead);
        this.notifyUpdateAccessInfo();
        if (this.readBy != null && method != null) {
            this.readBy.put(method, Boolean.TRUE);
        }
        if (firstAttempt) {
            this.getUniverse().onFieldAccessed(this);
            this.getUniverse().getHeapScanner().onFieldRead(this);
        }
        return firstAttempt;
    }

    public boolean registerAsWritten(MethodTypeFlow method) {
        boolean firstAttempt = AtomicUtils.atomicMark(this.isWritten);
        this.notifyUpdateAccessInfo();
        if (this.writtenBy != null && method != null) {
            this.writtenBy.put(method, Boolean.TRUE);
        }
        if (firstAttempt && (Modifier.isVolatile(this.getModifiers()) || this.getStorageKind() == JavaKind.Object)) {
            this.getUniverse().onFieldAccessed(this);
        }
        return firstAttempt;
    }

    public void markFolded() {
        if (AtomicUtils.atomicMark(this.isFolded)) {
            this.getDeclaringClass().registerAsReachable();
        }
    }

    public void registerAsUnsafeAccessed() {
        this.registerAsUnsafeAccessed(DefaultUnsafePartition.get());
    }

    public void registerAsUnsafeAccessed(UnsafePartitionKind partitionKind) {
        if (!this.isUnsafeAccessed.getAndSet(true)) {
            this.registerAsWritten(null);
            if (this.isStatic()) {
                this.getUniverse().registerUnsafeAccessedStaticField(this);
            } else {
                AnalysisType declaringType = this.getDeclaringClass();
                declaringType.registerUnsafeAccessedField(this, partitionKind);
            }
        }
        this.notifyUpdateAccessInfo();
    }

    public boolean isUnsafeAccessed() {
        return this.isUnsafeAccessed.get();
    }

    public void registerAsJNIAccessed() {
        this.isJNIAccessed = true;
    }

    public boolean isJNIAccessed() {
        return this.isJNIAccessed;
    }

    public void setUnsafeFrozenTypeState(boolean value) {
        this.unsafeFrozenTypeState.getAndSet(value);
    }

    public boolean hasUnsafeFrozenTypeState() {
        return this.unsafeFrozenTypeState.get();
    }

    public Set<MethodTypeFlow> getReadBy() {
        return this.readBy.keySet();
    }

    public Set<MethodTypeFlow> getWrittenBy() {
        return this.writtenBy.keySet();
    }

    public boolean isAccessed() {
        return this.isAccessed.get() || this.isRead.get() || this.isWritten.get() && (Modifier.isVolatile(this.getModifiers()) || this.getStorageKind() == JavaKind.Object);
    }

    public boolean isRead() {
        return this.isAccessed.get() || this.isRead.get();
    }

    public boolean isWritten() {
        return this.isAccessed.get() || this.isWritten.get();
    }

    public boolean isFolded() {
        return this.isFolded.get();
    }

    public boolean isReachable() {
        return this.isAccessed.get() || this.isRead.get() || this.isWritten.get() || this.isFolded.get();
    }

    public void setCanBeNull(boolean canBeNull) {
        this.canBeNull = canBeNull;
        this.notifyUpdateAccessInfo();
    }

    public boolean canBeNull() {
        return this.canBeNull;
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public void setPosition(int newPosition) {
        this.position = newPosition;
    }

    public int getPosition() {
        assert (this.position != -1) : this;
        return this.position;
    }

    public AnalysisType getType() {
        return this.fieldType;
    }

    public int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public int getOffset() {
        throw GraalError.shouldNotReachHere();
    }

    public AnalysisType getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean isInternal() {
        return false;
    }

    public boolean isSynthetic() {
        return this.wrapped.isSynthetic();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public Annotation[] getAnnotations() {
        return GuardedAnnotationAccess.getAnnotations((AnnotatedElement)this.wrapped);
    }

    public Annotation[] getDeclaredAnnotations() {
        return GuardedAnnotationAccess.getDeclaredAnnotations((AnnotatedElement)this.wrapped);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)GuardedAnnotationAccess.getAnnotation((AnnotatedElement)this.wrapped, annotationClass);
    }

    public String toString() {
        return "AnalysisField<" + this.format("%h.%n") + " accessed: " + this.isAccessed + " reads: " + this.isRead + " written: " + this.isWritten + " folded: " + this.isFolded + ">";
    }

    public void markAsUsedInComparison() {
        this.isUsedInComparison = true;
    }

    public boolean isUsedInComparison() {
        return this.isUsedInComparison;
    }

    @Override
    public Field getJavaField() {
        return OriginalFieldProvider.getJavaField(this.getUniverse().getOriginalSnippetReflection(), this.wrapped);
    }

    public void addAnalysisFieldObserver(AnalysisFieldObserver observer) {
        ConcurrentLightHashSet.addElement(this, OBSERVERS_UPDATER, observer);
    }

    public void removeAnalysisFieldObserver(AnalysisFieldObserver observer) {
        ConcurrentLightHashSet.removeElement(this, OBSERVERS_UPDATER, observer);
    }

    private void notifyUpdateAccessInfo() {
        for (Object observer : ConcurrentLightHashSet.getElements(this, OBSERVERS_UPDATER)) {
            ((AnalysisFieldObserver)observer).notifyUpdateAccessInfo(this);
        }
    }

    private TypeState interceptTypeState(TypeState typestate) {
        TypeState result = typestate;
        for (Object observer : ConcurrentLightHashSet.getElements(this, OBSERVERS_UPDATER)) {
            result = ((AnalysisFieldObserver)observer).interceptTypeState(this, typestate);
        }
        return result;
    }

    public static interface AnalysisFieldObserver {
        public void notifyUpdateAccessInfo(AnalysisField var1);

        public TypeState interceptTypeState(AnalysisField var1, TypeState var2);
    }
}

