/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import jdk.vm.ci.code.BytecodePosition;
import org.graalvm.compiler.nodes.ValueNode;

public class FormalReturnTypeFlow
extends TypeFlow<BytecodePosition> {
    protected final AnalysisMethod method;

    public FormalReturnTypeFlow(ValueNode source, AnalysisType declaredType, AnalysisMethod method) {
        this((BytecodePosition)source.getNodeSourcePosition(), declaredType, method);
    }

    public FormalReturnTypeFlow(BytecodePosition source, AnalysisType declaredType, AnalysisMethod method) {
        super(source, declaredType);
        this.method = method;
    }

    public FormalReturnTypeFlow(FormalReturnTypeFlow original, MethodFlowsGraph methodFlows) {
        super(original, methodFlows);
        this.method = original.method;
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new FormalReturnTypeFlow(this, methodFlows);
    }

    @Override
    public AnalysisMethod method() {
        return this.method;
    }

    @Override
    public String format(boolean withState, boolean withSource) {
        return "Formal return from " + this.method.format("%H.%n(%p)") + (String)(withSource ? " at " + this.formatSource() : "") + (String)(withState ? " with state <" + this.getState() + ">" : "");
    }
}

