/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;

public class CloneTypeFlow
extends TypeFlow<BytecodePosition> {
    private final BytecodeLocation cloneSite;
    private TypeFlow<?> input;
    protected final AnalysisContext allocationContext;

    public CloneTypeFlow(BytecodePosition cloneLocation, AnalysisType inputType, BytecodeLocation cloneLabel, TypeFlow<?> input) {
        super(cloneLocation, inputType);
        this.cloneSite = cloneLabel;
        this.allocationContext = null;
        this.input = input;
    }

    public CloneTypeFlow(PointsToAnalysis bb, CloneTypeFlow original, MethodFlowsGraph methodFlows, AnalysisContext allocationContext) {
        super(original, methodFlows);
        this.cloneSite = original.cloneSite;
        this.allocationContext = allocationContext;
        this.input = methodFlows.lookupCloneOf(bb, original.input);
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        AnalysisContext enclosingContext = methodFlows.context();
        AnalysisContext allocContext = bb.contextPolicy().allocationContext(enclosingContext, (Integer)PointstoOptions.MaxHeapContextDepth.getValue(bb.getOptions()));
        return new CloneTypeFlow(bb, this, methodFlows, allocContext);
    }

    @Override
    public void onObservedUpdate(PointsToAnalysis bb) {
        assert (this.isClone() && this.context != null);
        TypeState inputState = this.input.getState();
        TypeState resultState = bb.analysisPolicy().cloneState(bb, this.state, inputState, this.cloneSite, this.allocationContext);
        this.addState(bb, resultState);
    }

    @Override
    public void update(PointsToAnalysis bb) {
        assert (this.isClone());
        bb.analysisPolicy().linkClonedObjects(bb, this.input, this, (BytecodePosition)this.source);
        super.update(bb);
    }

    @Override
    public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
        assert (this.isClone());
        if (!this.isSaturated()) {
            this.replaceObservedWith(bb, this.declaredType);
        }
    }

    @Override
    protected void onSaturated() {
        this.input.removeObserver(this);
    }

    @Override
    public void setObserved(TypeFlow<?> newInputFlow) {
        this.input = newInputFlow;
    }

    public BytecodeLocation getCloneSite() {
        return this.cloneSite;
    }

    @Override
    public String toString() {
        return "Clone<" + super.toString() + ">";
    }
}

