/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.api;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisPolicy;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.nativeimage.hosted.Feature;

public abstract class HostVM {
    protected final OptionValues options;
    protected final ClassLoader classLoader;
    protected final List<BiConsumer<AnalysisMethod, StructuredGraph>> methodAfterParsingListeners;
    private final List<BiConsumer<Feature.DuringAnalysisAccess, Class<?>>> classReachabilityListeners;

    protected HostVM(OptionValues options, ClassLoader classLoader) {
        this.options = options;
        this.classLoader = classLoader;
        this.methodAfterParsingListeners = new CopyOnWriteArrayList<BiConsumer<AnalysisMethod, StructuredGraph>>();
        this.classReachabilityListeners = new ArrayList();
    }

    public OptionValues options() {
        return this.options;
    }

    public boolean isRelocatedPointer(Object originalObject) {
        return false;
    }

    public Optional<AnalysisMethod> handleForeignCall(ForeignCallDescriptor foreignCallDescriptor, ForeignCallsProvider foreignCallsProvider) {
        return Optional.empty();
    }

    public void registerClassReachabilityListener(BiConsumer<Feature.DuringAnalysisAccess, Class<?>> listener) {
        this.classReachabilityListeners.add(listener);
    }

    public void notifyClassReachabilityListener(AnalysisUniverse universe, Feature.DuringAnalysisAccess access) {
        for (AnalysisType type : universe.getTypes()) {
            if (!type.isReachable() || type.getReachabilityListenerNotified()) continue;
            type.setReachabilityListenerNotified(true);
            for (BiConsumer<Feature.DuringAnalysisAccess, Class<?>> listener : this.classReachabilityListeners) {
                listener.accept(access, type.getJavaClass());
            }
        }
    }

    public void checkForbidden(AnalysisType type, AnalysisType.UsageKind kind) {
    }

    public void registerType(AnalysisType newValue) {
    }

    public void checkType(ResolvedJavaType type, AnalysisUniverse universe) {
    }

    public abstract void initializeType(AnalysisType var1);

    public abstract boolean isInitialized(AnalysisType var1);

    public GraphBuilderConfiguration updateGraphBuilderConfiguration(GraphBuilderConfiguration config, AnalysisMethod method) {
        return config;
    }

    public abstract GraphBuilderPhase.Instance createGraphBuilderPhase(HostedProviders var1, GraphBuilderConfiguration var2, OptimisticOptimizations var3, IntrinsicContext var4);

    public String getImageName() {
        return null;
    }

    public void addMethodAfterParsingListener(BiConsumer<AnalysisMethod, StructuredGraph> methodAfterParsingHook) {
        this.methodAfterParsingListeners.add(methodAfterParsingHook);
    }

    public void methodAfterParsingHook(BigBang bb, AnalysisMethod method, StructuredGraph graph) {
        for (BiConsumer<AnalysisMethod, StructuredGraph> listener : this.methodAfterParsingListeners) {
            listener.accept(method, graph);
        }
    }

    public void methodBeforeTypeFlowCreationHook(PointsToAnalysis bb, AnalysisMethod method, StructuredGraph graph) {
    }

    public boolean hasNeverInlineDirective(ResolvedJavaMethod method) {
        return true;
    }

    public InlineBeforeAnalysisPolicy<?> inlineBeforeAnalysisPolicy() {
        return InlineBeforeAnalysisPolicy.NO_INLINING;
    }

    public boolean skipInterface(AnalysisUniverse universe, ResolvedJavaType interfaceType, ResolvedJavaType implementingType) {
        return false;
    }

    public boolean platformSupported(AnnotatedElement element) {
        return true;
    }

    public void installInThread(Object vmConfig) {
        Thread.currentThread().setContextClassLoader(this.classLoader);
    }

    public void clearInThread() {
    }

    public Object getConfiguration() {
        return null;
    }
}

