/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.typestate.MultiTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import jdk.vm.ci.common.JVMCIError;

public class TypeStateUtils {
    private static final MethodHandle bitSetArrayAccess;
    private static final MethodHandle trimToSizeAccess;

    static long[] extractBitSetField(BitSet bitSet) {
        try {
            return bitSetArrayAccess.invokeExact(bitSet);
        }
        catch (Throwable t) {
            throw JVMCIError.shouldNotReachHere((Throwable)t);
        }
    }

    static void trimBitSetToSize(BitSet bs) {
        try {
            trimToSizeAccess.invokeExact(bs);
        }
        catch (Throwable t) {
            throw JVMCIError.shouldNotReachHere((Throwable)t);
        }
    }

    protected static AnalysisObject[] concat(AnalysisObject[] oa1, AnalysisObject[] oa2) {
        int resultSize = oa1.length + oa2.length;
        AnalysisObject[] result = new AnalysisObject[resultSize];
        System.arraycopy(oa1, 0, result, 0, oa1.length);
        System.arraycopy(oa2, 0, result, oa1.length, oa2.length);
        return result;
    }

    protected static AnalysisObject[] union(PointsToAnalysis bb, AnalysisObject[] a1, AnalysisObject[] a2) {
        if (a1.length == 1 && bb.analysisPolicy().isSummaryObject(a1[0])) {
            bb.analysisPolicy().noteMerge(bb, a1);
            bb.analysisPolicy().noteMerge(bb, a2);
            return a1;
        }
        if (a2.length == 1 && bb.analysisPolicy().isSummaryObject(a2[0])) {
            bb.analysisPolicy().noteMerge(bb, a1);
            bb.analysisPolicy().noteMerge(bb, a2);
            return a2;
        }
        if (a1.length >= a2.length) {
            return TypeStateUtils.arraysUnion(bb, a1, a2);
        }
        return TypeStateUtils.arraysUnion(bb, a2, a1);
    }

    private static AnalysisObject[] arraysUnion(PointsToAnalysis bb, AnalysisObject[] a1, AnalysisObject[] a2) {
        assert (a1.length >= a2.length) : "Union is commutative, must call it with a1 being the bigger state";
        assert (a1.length > 1 || !bb.analysisPolicy().isSummaryObject(a1[0]));
        assert (a2.length > 1 || !bb.analysisPolicy().isSummaryObject(a2[0]));
        if (a1 == a2) {
            return a1;
        }
        if (a1[a1.length - 1].getId() < a2[0].getId()) {
            return TypeStateUtils.checkUnionSize(bb, a1, a2, TypeStateUtils.concat(a1, a2));
        }
        if (a2[a2.length - 1].getId() < a1[0].getId()) {
            return TypeStateUtils.checkUnionSize(bb, a1, a2, TypeStateUtils.concat(a2, a1));
        }
        int idx1 = 0;
        int idx2 = 0;
        while (idx1 < a1.length) {
            AnalysisObject o1 = a1[idx1];
            AnalysisObject o2 = a2[idx2];
            if (o1.getId() < o2.getId()) {
                ++idx1;
                continue;
            }
            if (o1 != o2) break;
            ++idx1;
            if (++idx2 != a2.length) continue;
            return a1;
        }
        ArrayList<AnalysisObject> objectsList = new ArrayList<AnalysisObject>(a1.length + a2.length);
        objectsList.addAll(Arrays.asList(a1).subList(0, idx1));
        while (idx1 < a1.length && idx2 < a2.length) {
            AnalysisObject o1 = a1[idx1];
            AnalysisObject o2 = a2[idx2];
            if (o1.equals(o2)) {
                objectsList.add(o1);
                ++idx1;
                ++idx2;
                continue;
            }
            assert (o1.getId() != o2.getId());
            if (o1.getId() < o2.getId()) {
                objectsList.add(o1);
                ++idx1;
                continue;
            }
            objectsList.add(o2);
            ++idx2;
        }
        if (idx1 < a1.length) {
            assert (idx2 == a2.length);
            objectsList.addAll(Arrays.asList(a1).subList(idx1, a1.length));
        } else if (idx2 < a2.length) {
            assert (idx1 == a1.length);
            objectsList.addAll(Arrays.asList(a2).subList(idx2, a2.length));
        }
        return TypeStateUtils.checkUnionSize(bb, a1, a2, objectsList.toArray(new AnalysisObject[objectsList.size()]));
    }

    private static AnalysisObject[] checkUnionSize(PointsToAnalysis bb, AnalysisObject[] oa1, AnalysisObject[] oa2, AnalysisObject[] result) {
        assert (result.length >= 2);
        if (((Boolean)PointstoOptions.LimitObjectArrayLength.getValue(bb.getOptions())).booleanValue() && result.length > (Integer)PointstoOptions.MaxObjectSetSize.getValue(bb.getOptions())) {
            AnalysisObject rObj = result[0].type().getContextInsensitiveAnalysisObject();
            bb.analysisPolicy().noteMerge(bb, oa1);
            bb.analysisPolicy().noteMerge(bb, oa2);
            bb.analysisPolicy().noteMerge(bb, rObj);
            return new AnalysisObject[]{rObj};
        }
        return result;
    }

    protected static AnalysisObject[] intersection(PointsToAnalysis bb, AnalysisObject[] a1, AnalysisObject[] a2) {
        if (a1.length == 1 && a1[0].isContextInsensitiveObject()) {
            return a2;
        }
        if (a2.length == 1 && a2[0].isContextInsensitiveObject()) {
            return a1;
        }
        if (a1.length <= a2.length) {
            return TypeStateUtils.arraysIntersection(bb, a1, a2);
        }
        return TypeStateUtils.arraysIntersection(bb, a2, a1);
    }

    private static AnalysisObject[] arraysIntersection(PointsToAnalysis bb, AnalysisObject[] a1, AnalysisObject[] a2) {
        assert (a1.length <= a2.length) : "Intersection is commutative, must call it with a1 being the shorter array";
        if (a1 == a2) {
            return a1;
        }
        int idx1 = 0;
        int idx2 = 0;
        while (idx2 < a2.length) {
            AnalysisObject o1 = a1[idx1];
            AnalysisObject o2 = a2[idx2];
            if (o2.getId() < o1.getId()) {
                ++idx2;
                continue;
            }
            if (!o1.equals(o2)) break;
            ++idx2;
            if (++idx1 != a1.length) continue;
            return a1;
        }
        ArrayList<AnalysisObject> rList = new ArrayList<AnalysisObject>(a1.length);
        rList.addAll(Arrays.asList(a1).subList(0, idx1));
        while (idx1 < a1.length && idx2 < a2.length) {
            AnalysisObject o1 = a1[idx1];
            AnalysisObject o2 = a2[idx2];
            if (o1.equals(o2)) {
                rList.add(o1);
                ++idx1;
                ++idx2;
                continue;
            }
            assert (o1.getId() != o2.getId());
            if (o1.getId() < o2.getId()) {
                ++idx1;
                continue;
            }
            ++idx2;
        }
        assert (rList.size() <= a1.length && rList.size() <= a2.length);
        assert (!((Boolean)PointstoOptions.LimitObjectArrayLength.getValue(bb.getOptions())).booleanValue() || rList.size() <= (Integer)PointstoOptions.MaxObjectSetSize.getValue(bb.getOptions()));
        if (rList.size() == 0) {
            return AnalysisObject.EMPTY_ARRAY;
        }
        Object[] result = rList.toArray(new AnalysisObject[rList.size()]);
        assert (!Arrays.equals(result, a1) && !Arrays.equals(result, a2));
        return result;
    }

    static boolean isContextInsensitiveTypeState(TypeState state) {
        for (AnalysisObject object : state.objects()) {
            if (object.isContextInsensitiveObject()) continue;
            return false;
        }
        return true;
    }

    static boolean holdsSingleTypeState(AnalysisObject[] objects) {
        return TypeStateUtils.holdsSingleTypeState(objects, objects.length);
    }

    static boolean holdsSingleTypeState(AnalysisObject[] objects, int size) {
        int lastType;
        assert (size > 0);
        int firstType = objects[0].getTypeId();
        return firstType == (lastType = objects[size - 1].getTypeId());
    }

    protected static BitSet or(BitSet bs1, BitSet bs2) {
        BitSet bsr = (BitSet)bs1.clone();
        bsr.or(bs2);
        return bsr;
    }

    protected static BitSet and(BitSet bs1, BitSet bs2) {
        BitSet bsr = (BitSet)bs1.clone();
        bsr.and(bs2);
        return bsr;
    }

    static BitSet andNot(BitSet bs1, BitSet bs2) {
        BitSet bsr = (BitSet)bs1.clone();
        bsr.andNot(bs2);
        return bsr;
    }

    protected static BitSet clear(BitSet bs1, int bitIndex) {
        BitSet bsr = (BitSet)bs1.clone();
        bsr.clear(bitIndex);
        return bsr;
    }

    protected static BitSet set(BitSet bs1, int bitIndex) {
        BitSet bsr = (BitSet)bs1.clone();
        bsr.set(bitIndex);
        return bsr;
    }

    public static boolean closeToAllInstantiated(PointsToAnalysis bb, TypeState state) {
        if (state.typesCount() > 200) {
            MultiTypeState allInstState = (MultiTypeState)bb.getAllInstantiatedTypes();
            return (long)state.typesCount() * 100L / (long)allInstState.typesCount() > 75L;
        }
        return false;
    }

    static {
        try {
            bitSetArrayAccess = MethodHandles.lookup().unreflectGetter(ReflectionUtil.lookupField(BitSet.class, (String)"words"));
            trimToSizeAccess = MethodHandles.lookup().unreflect(ReflectionUtil.lookupMethod(BitSet.class, (String)"trimToSize", (Class[])new Class[0]));
        }
        catch (IllegalAccessException t) {
            throw JVMCIError.shouldNotReachHere((Throwable)t);
        }
    }
}

