/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AbstractVirtualInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.InvokeInfo;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class PointsToAnalysisMethod
extends AnalysisMethod {
    private MethodTypeFlow typeFlow;
    private ConcurrentMap<InvokeTypeFlow, Object> invokedBy;
    private ConcurrentMap<InvokeTypeFlow, Object> implementationInvokedBy;
    private final AtomicReference<InvokeTypeFlow> contextInsensitiveInvoke = new AtomicReference();

    public PointsToAnalysisMethod(AnalysisUniverse universe, ResolvedJavaMethod wrapped) {
        super(universe, wrapped);
        this.typeFlow = new MethodTypeFlow(universe.hostVM().options(), this);
    }

    @Override
    public void cleanupAfterAnalysis() {
        super.cleanupAfterAnalysis();
        this.contextInsensitiveInvoke.set(null);
        this.typeFlow = null;
        this.invokedBy = null;
        this.implementationInvokedBy = null;
    }

    @Override
    public void startTrackInvocations() {
        if (this.invokedBy == null) {
            this.invokedBy = new ConcurrentHashMap<InvokeTypeFlow, Object>();
        }
        if (this.implementationInvokedBy == null) {
            this.implementationInvokedBy = new ConcurrentHashMap<InvokeTypeFlow, Object>();
        }
    }

    public MethodTypeFlow getTypeFlow() {
        return this.typeFlow;
    }

    public boolean registerAsInvoked(InvokeTypeFlow invoke) {
        if (this.invokedBy != null && invoke != null) {
            this.invokedBy.put(invoke, Boolean.TRUE);
        }
        return super.registerAsInvoked();
    }

    public boolean registerAsImplementationInvoked(InvokeTypeFlow invoke) {
        if (this.implementationInvokedBy != null && invoke != null) {
            this.implementationInvokedBy.put(invoke, Boolean.TRUE);
        }
        return super.registerAsImplementationInvoked();
    }

    @Override
    public List<BytecodePosition> getInvokeLocations() {
        ArrayList<BytecodePosition> locations = new ArrayList<BytecodePosition>();
        for (InvokeTypeFlow invoke : this.implementationInvokedBy.keySet()) {
            if (InvokeTypeFlow.isContextInsensitiveVirtualInvoke(invoke)) {
                locations.addAll(((AbstractVirtualInvokeTypeFlow)invoke).getInvokeLocations());
                continue;
            }
            locations.add((BytecodePosition)invoke.getSource());
        }
        return locations;
    }

    @Override
    public Collection<InvokeInfo> getInvokes() {
        return Collections.unmodifiableCollection(this.getTypeFlow().getInvokes());
    }

    @Override
    public StackTraceElement[] getParsingContext() {
        return this.getTypeFlow().getParsingContext();
    }

    public InvokeTypeFlow initAndGetContextInsensitiveInvoke(PointsToAnalysis bb, BytecodePosition originalLocation) {
        AbstractVirtualInvokeTypeFlow invoke;
        boolean set;
        if (this.contextInsensitiveInvoke.get() == null && (set = this.contextInsensitiveInvoke.compareAndSet(null, invoke = InvokeTypeFlow.createContextInsensitiveInvoke(bb, this, originalLocation)))) {
            InvokeTypeFlow.initContextInsensitiveInvoke(bb, this, invoke);
        }
        return this.contextInsensitiveInvoke.get();
    }

    public InvokeTypeFlow getContextInsensitiveInvoke() {
        InvokeTypeFlow invoke = this.contextInsensitiveInvoke.get();
        AnalysisError.guarantee(invoke != null);
        return invoke;
    }
}

