/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.object;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.FieldFilterTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.typestore.FieldTypeStore;
import com.oracle.graal.pointsto.typestore.UnifiedFieldTypeStore;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import jdk.vm.ci.code.BytecodePosition;

public class ContextSensitiveAnalysisObject
extends AnalysisObject {
    private List<AnalysisObject> referencedObjects;

    public ContextSensitiveAnalysisObject(AnalysisUniverse universe, AnalysisType type, AnalysisObject.AnalysisObjectKind kind) {
        super(universe, type, kind);
        assert (((Boolean)PointstoOptions.AllocationSiteSensitiveHeap.getValue(universe.hostVM().options())).booleanValue());
    }

    @Override
    public void noteMerge(PointsToAnalysis bb) {
        assert (bb.analysisPolicy().isMergingEnabled());
        if (!this.merged) {
            super.noteMerge(bb);
            if (this.type.isArray()) {
                if (this.isObjectArray()) {
                    this.mergeArrayElementsFlow(bb);
                }
            } else {
                this.mergeInstanceFieldsFlows(bb);
            }
        }
    }

    private void mergeArrayElementsFlow(PointsToAnalysis bb) {
        assert (this.isObjectArray());
        ArrayElementsTypeFlow contextInsensitiveWriteArrayElementsFlow = this.type.getContextInsensitiveAnalysisObject().getArrayElementsFlow(bb, true);
        contextInsensitiveWriteArrayElementsFlow.addUse(bb, this.arrayElementsTypeStore.writeFlow());
        ArrayElementsTypeFlow contextInsensitiveReadArrayElementsFlow = this.type.getContextInsensitiveAnalysisObject().getArrayElementsFlow(bb, false);
        this.arrayElementsTypeStore.readFlow().addUse(bb, contextInsensitiveReadArrayElementsFlow);
    }

    private void mergeInstanceFieldsFlows(PointsToAnalysis bb) {
        this.mergeInstanceFieldsFlows(bb, this.type.getContextInsensitiveAnalysisObject());
    }

    public void mergeInstanceFieldsFlows(PointsToAnalysis bb, AnalysisObject object) {
        if (this.instanceFieldsTypeStore != null) {
            for (int i = 0; i < this.instanceFieldsTypeStore.length(); ++i) {
                FieldTypeStore fieldTypeStore = (FieldTypeStore)this.instanceFieldsTypeStore.get(i);
                if (fieldTypeStore == null) continue;
                ContextSensitiveAnalysisObject.mergeInstanceFieldFlow(bb, fieldTypeStore, object);
            }
        }
    }

    protected void mergeInstanceFieldFlow(PointsToAnalysis bb, FieldTypeStore fieldTypeStore) {
        ContextSensitiveAnalysisObject.mergeInstanceFieldFlow(bb, fieldTypeStore, this.type.getContextInsensitiveAnalysisObject());
    }

    protected static void mergeInstanceFieldFlow(PointsToAnalysis bb, FieldTypeStore fieldTypeStore, AnalysisObject object) {
        AnalysisField field = fieldTypeStore.field();
        FieldTypeFlow readFieldFlow = fieldTypeStore.readFlow();
        FieldTypeFlow writeFieldFlow = fieldTypeStore.writeFlow();
        FieldTypeFlow parentWriteFieldFlow = object.getInstanceFieldFlow(bb, field, true);
        FieldTypeFlow parentReadFieldFlow = object.getInstanceFieldFlow(bb, field, false);
        parentWriteFieldFlow.addUse(bb, writeFieldFlow);
        readFieldFlow.addUse(bb, parentReadFieldFlow);
    }

    @Override
    public ArrayElementsTypeFlow getArrayElementsFlow(PointsToAnalysis bb, boolean isStore) {
        assert (this.type.isArray());
        assert (((Boolean)PointstoOptions.AllocationSiteSensitiveHeap.getValue(bb.getOptions())).booleanValue());
        return isStore ? this.arrayElementsTypeStore.writeFlow() : this.arrayElementsTypeStore.readFlow();
    }

    @Override
    public FieldFilterTypeFlow getInstanceFieldFilterFlow(PointsToAnalysis bb, TypeFlow<?> objectFlow, BytecodePosition context, AnalysisField field) {
        assert (!Modifier.isStatic(field.getModifiers()) && field.isUnsafeAccessed() && ((Boolean)PointstoOptions.AllocationSiteSensitiveHeap.getValue(bb.getOptions())).booleanValue());
        FieldTypeStore fieldTypeStore = this.getInstanceFieldTypeStore(bb, objectFlow, context, field);
        for (AnalysisObject mergedWith : this.getAllObjectsMergedWith()) {
            ContextSensitiveAnalysisObject.mergeInstanceFieldFlow(bb, fieldTypeStore, mergedWith);
        }
        return fieldTypeStore.writeFlow().filterFlow(bb);
    }

    @Override
    public FieldTypeFlow getInstanceFieldFlow(PointsToAnalysis bb, TypeFlow<?> objectFlow, BytecodePosition context, AnalysisField field, boolean isStore) {
        assert (!Modifier.isStatic(field.getModifiers()) && ((Boolean)PointstoOptions.AllocationSiteSensitiveHeap.getValue(bb.getOptions())).booleanValue());
        FieldTypeStore fieldTypeStore = this.getInstanceFieldTypeStore(bb, objectFlow, context, field);
        for (AnalysisObject mergedWith : this.getAllObjectsMergedWith()) {
            ContextSensitiveAnalysisObject.mergeInstanceFieldFlow(bb, fieldTypeStore, mergedWith);
        }
        return isStore ? fieldTypeStore.writeFlow() : fieldTypeStore.readFlow();
    }

    protected List<AnalysisObject> getAllObjectsMergedWith() {
        return this.merged ? Collections.singletonList(this.type().getContextInsensitiveAnalysisObject()) : Collections.emptyList();
    }

    public List<AnalysisObject> getReferencedObjects() {
        if (this.referencedObjects == null) {
            HashSet<AnalysisObject> objectsSet = new HashSet<AnalysisObject>();
            if (this.type().isArray()) {
                for (AnalysisObject object : this.arrayElementsTypeStore.readFlow().getState().objects()) {
                    objectsSet.add(object);
                }
            } else if (this.instanceFieldsTypeStore != null) {
                for (int i = 0; i < this.instanceFieldsTypeStore.length(); ++i) {
                    FieldTypeStore fieldTypeStore = (FieldTypeStore)this.instanceFieldsTypeStore.get(i);
                    if (fieldTypeStore == null) continue;
                    FieldTypeFlow fieldFlow = ((UnifiedFieldTypeStore)fieldTypeStore).readWriteFlow();
                    for (AnalysisObject object : fieldFlow.getState().objects()) {
                        objectsSet.add(object);
                    }
                }
            }
            this.referencedObjects = new ArrayList<AnalysisObject>(objectsSet);
        }
        return this.referencedObjects;
    }
}

