/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.object;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.flow.context.object.ContextSensitiveAnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;

public class AllocationContextSensitiveObject
extends ContextSensitiveAnalysisObject {
    protected final BytecodeLocation allocationLabel;
    protected final AnalysisContext allocationContext;
    protected AnalysisContext allocatorContext;

    public AllocationContextSensitiveObject(PointsToAnalysis bb, AnalysisType type, BytecodeLocation allocationSite, AnalysisContext context) {
        super(bb.getUniverse(), type, AnalysisObject.AnalysisObjectKind.AllocationContextSensitive);
        assert (bb.trackConcreteAnalysisObjects(type));
        this.allocationLabel = allocationSite;
        this.allocationContext = context;
    }

    public BytecodeLocation allocationLabel() {
        return this.allocationLabel;
    }

    public AnalysisContext allocationContext() {
        return this.allocationContext;
    }

    public void setAllocatorContext(AnalysisContext allocatorContext) {
        this.allocatorContext = allocatorContext;
    }

    @Override
    public ArrayElementsTypeFlow getArrayElementsFlow(PointsToAnalysis bb, boolean isStore) {
        assert (this.type.isArray());
        assert (((Boolean)PointstoOptions.AllocationSiteSensitiveHeap.getValue(bb.getOptions())).booleanValue());
        if (!this.arrayElementsTypeStore.writeFlow().getState().canBeNull()) {
            this.arrayElementsTypeStore.writeFlow().addState(bb, TypeState.forNull());
        }
        return isStore ? this.arrayElementsTypeStore.writeFlow() : this.arrayElementsTypeStore.readFlow();
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(super.toString());
        if (this.allocationLabel != BytecodeLocation.EMPTY_BYTECODE_LOCATION) {
            result.append("  ").append(this.allocationLabel);
        }
        result.append("  ").append(this.allocationContext);
        return result.toString();
    }
}

