/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.bytecode;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContextPolicy;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeAnalysisContext;
import com.oracle.graal.pointsto.flow.context.object.AllocationContextSensitiveObject;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import jdk.vm.ci.common.JVMCIError;

public class BytecodeAnalysisContextPolicy
extends AnalysisContextPolicy<BytecodeAnalysisContext> {
    public BytecodeAnalysisContextPolicy() {
        super(BytecodeAnalysisContextPolicy.getEmptyContext());
    }

    private static BytecodeAnalysisContext getEmptyContext() {
        return new BytecodeAnalysisContext(BytecodeAnalysisContext.emptyLabelList);
    }

    @Override
    public BytecodeAnalysisContext peel(BytecodeAnalysisContext context, int maxDepth) {
        assert (maxDepth >= 0);
        if (context.labels().length <= maxDepth) {
            return context;
        }
        assert (context.labels().length > maxDepth);
        BytecodeLocation[] resultingLabelList = BytecodeAnalysisContextPolicy.peel(context.labels(), maxDepth);
        return this.lookupContext(resultingLabelList);
    }

    @Override
    public BytecodeAnalysisContext calleeContext(BigBang bb, AnalysisObject receiverObject, BytecodeAnalysisContext callerContext, MethodTypeFlow callee) {
        BytecodeLocation[] labelList;
        int maxCalleeContextDepth = callee.getLocalCallingContextDepth();
        if (maxCalleeContextDepth == 0 || !receiverObject.isAllocationContextSensitiveObject()) {
            return (BytecodeAnalysisContext)this.emptyContext();
        }
        AllocationContextSensitiveObject receiverHeapObject = (AllocationContextSensitiveObject)receiverObject;
        if (receiverHeapObject.allocationContext() != null) {
            labelList = BytecodeAnalysisContextPolicy.extend(((BytecodeAnalysisContext)receiverHeapObject.allocationContext()).labels(), receiverHeapObject.allocationLabel(), maxCalleeContextDepth);
        } else {
            JVMCIError.shouldNotReachHere((String)"CoreAnalysisContextPolicy.merge: receiverHeapObject.heapContext() is null");
            labelList = new BytecodeLocation[]{receiverHeapObject.allocationLabel()};
        }
        return this.lookupContext(labelList);
    }

    @Override
    public BytecodeAnalysisContext staticCalleeContext(BigBang bb, BytecodeLocation invokeLocation, BytecodeAnalysisContext callerContext, MethodTypeFlow callee) {
        assert (callerContext != null);
        if (!((Boolean)PointstoOptions.HybridStaticContext.getValue(bb.getOptions())).booleanValue()) {
            return callerContext;
        }
        int maxCallingContextDepth = callee.getLocalCallingContextDepth();
        if (maxCallingContextDepth == 0) {
            return (BytecodeAnalysisContext)this.emptyContext();
        }
        BytecodeLocation[] labelList = BytecodeAnalysisContextPolicy.extend(callerContext.labels(), invokeLocation, maxCallingContextDepth);
        return this.lookupContext(labelList);
    }

    @Override
    public BytecodeAnalysisContext allocationContext(BytecodeAnalysisContext context, int maxHeapContextDepth) {
        return this.peel(context, maxHeapContextDepth);
    }

    public BytecodeAnalysisContext getContext(BytecodeLocation bcl) {
        return this.getContext(new BytecodeLocation[]{bcl});
    }

    public BytecodeAnalysisContext getContext(BytecodeLocation[] bytecodeLocations) {
        return this.lookupContext(bytecodeLocations);
    }

    private BytecodeAnalysisContext lookupContext(BytecodeLocation[] bytecodeLocations) {
        return (BytecodeAnalysisContext)this.lookupContext(new BytecodeAnalysisContext(bytecodeLocations));
    }
}

