/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.macho;

import com.oracle.objectfile.BasicProgbitsSectionImpl;
import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.ElementImpl;
import com.oracle.objectfile.ElementList;
import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.SymbolTable;
import com.oracle.objectfile.io.AssemblyBuffer;
import com.oracle.objectfile.io.OutputAssembler;
import com.oracle.objectfile.macho.MachOCpuType;
import com.oracle.objectfile.macho.MachORegularSection;
import com.oracle.objectfile.macho.MachORelocationElement;
import com.oracle.objectfile.macho.MachOStrtab;
import com.oracle.objectfile.macho.MachOSymtab;
import com.oracle.objectfile.macho.MachOUserDefinedSection;
import com.oracle.objectfile.macho.MachOZeroFillSection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;

public final class MachOObjectFile
extends ObjectFile {
    private static final int MAGIC = -17958193;
    private static final int CIGAM = -805638658;
    private static final ByteOrder nativeOrder = ByteOrder.nativeOrder();
    private static final ByteOrder oppositeOrder = nativeOrder == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    final MachOCpuType cpuType;
    final int cpuSubType;
    private final MachOHeader header;
    private ByteOrder fileByteOrder;
    MachORelocationElement relocs;
    private LoadCommandList loadCommands = new LoadCommandList();
    static Map<Integer, LoadCommandKind> loadCommandKindsByValue = new HashMap<Integer, LoadCommandKind>();
    private int minimumFileSize = 0;
    private EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);

    public MachOObjectFile(int pageSize) {
        this(pageSize, MachOCpuType.from(((Platform)ImageSingletons.lookup(Platform.class)).getArchitecture()));
    }

    public MachOObjectFile(int pageSize, MachOCpuType cpuType) {
        super(pageSize);
        this.cpuType = cpuType;
        switch (cpuType) {
            case X86_64: {
                this.cpuSubType = 3;
                break;
            }
            default: {
                this.cpuSubType = 0;
            }
        }
        this.header = new MachOHeader("MachOHeader");
        this.setByteOrder(ByteOrder.nativeOrder());
        Segment64Command segment = new Segment64Command("MachOUnnamedSegment", MachOObjectFile.getUnnamedSegmentName());
        segment.initprot = EnumSet.of(VMProt.READ, VMProt.WRITE, VMProt.EXECUTE);
        segment.maxprot = EnumSet.of(VMProt.READ, VMProt.WRITE, VMProt.EXECUTE);
        this.createSymbolTable();
        assert (this.getSymbolTable() != null);
        FunctionStartsCommand functionStarts = new FunctionStartsCommand("MachOFunctionStartsCommand");
        assert (this.loadCommands.otherCommands.contains(functionStarts));
    }

    @Override
    public ObjectFile.Format getFormat() {
        return ObjectFile.Format.MACH_O;
    }

    protected static String getUnnamedSegmentName() {
        return "";
    }

    @Override
    protected ElementList createElementList() {
        return new MachOElementList();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.fileByteOrder;
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        this.fileByteOrder = byteOrder;
    }

    @Override
    protected int initialVaddr() {
        return super.initialVaddr();
    }

    @Override
    public int getWordSizeInBytes() {
        return 8;
    }

    @Override
    public boolean shouldRecordDebugRelocations() {
        return false;
    }

    @Override
    public ObjectFile.Symbol createDefinedSymbol(String name, ObjectFile.Element baseSection, long position, int size, boolean isCode, boolean isGlobal) {
        MachOSymtab symtab = (MachOSymtab)this.getOrCreateSymbolTable();
        return symtab.newDefinedEntry(name, (MachOSection)baseSection, position, size, isGlobal, isCode);
    }

    @Override
    public ObjectFile.Symbol createUndefinedSymbol(String name, int size, boolean isCode) {
        MachOSymtab symtab = (MachOSymtab)this.getOrCreateSymbolTable();
        return symtab.newUndefinedEntry(name, isCode);
    }

    @Override
    protected Segment64Command getOrCreateSegment(String segmentNameOrNull, String sectionName, boolean writable, boolean executable) {
        String segmentName = segmentNameOrNull != null ? segmentNameOrNull : MachOObjectFile.getUnnamedSegmentName();
        Segment64Command nonNullSegment = (Segment64Command)this.findSegmentByName(segmentName);
        if (nonNullSegment != null) {
            if (nonNullSegment.isWritable() != writable) {
                nonNullSegment.initprot.add(VMProt.WRITE);
                nonNullSegment.maxprot.add(VMProt.WRITE);
            }
            if (nonNullSegment.isExecutable() != executable) {
                nonNullSegment.initprot.add(VMProt.EXECUTE);
                nonNullSegment.maxprot.add(VMProt.EXECUTE);
            }
        } else {
            nonNullSegment = new Segment64Command(sectionName, segmentName);
            nonNullSegment.initprot = EnumSet.of(VMProt.READ);
            if (writable) {
                nonNullSegment.initprot.add(VMProt.WRITE);
            }
            if (executable) {
                nonNullSegment.initprot.add(VMProt.EXECUTE);
            }
            nonNullSegment.maxprot = nonNullSegment.initprot;
            assert (this.loadCommands.otherCommands.contains(nonNullSegment));
        }
        assert (nonNullSegment != null);
        return nonNullSegment;
    }

    @Override
    public MachOZeroFillSection newNobitsSection(ObjectFile.Segment segment, String name, ObjectFile.NobitsSectionImpl impl) {
        assert (segment != null && impl != null);
        MachOZeroFillSection zeroFill = new MachOZeroFillSection(this, name, (Segment64Command)segment, impl);
        impl.setElement(zeroFill);
        return zeroFill;
    }

    @Override
    public MachORegularSection newProgbitsSection(ObjectFile.Segment segment, String name, int alignment, boolean writable, boolean executable, ObjectFile.ProgbitsSectionImpl impl) {
        assert (segment != null);
        EnumSet<SectionFlag> sectionFlags = EnumSet.noneOf(SectionFlag.class);
        if (executable) {
            sectionFlags.add(SectionFlag.SOME_INSTRUCTIONS);
        }
        MachORegularSection regular = new MachORegularSection(this, name, alignment, (Segment64Command)segment, impl, sectionFlags);
        impl.setElement(regular);
        if (executable) {
            ((Segment64Command)segment).initprot.add(VMProt.EXECUTE);
        }
        if (writable) {
            ((Segment64Command)segment).initprot.add(VMProt.WRITE);
        }
        return regular;
    }

    @Override
    public MachOUserDefinedSection newUserDefinedSection(ObjectFile.Segment segment, String name, int alignment, ElementImpl impl) {
        assert (segment != null);
        ElementImpl ourImpl = impl == null ? new BasicProgbitsSectionImpl((ObjectFile.Section)null) : impl;
        MachOUserDefinedSection userDefined = new MachOUserDefinedSection(this, name, alignment, (Segment64Command)segment, SectionType.REGULAR, ourImpl);
        ourImpl.setElement(userDefined);
        return userDefined;
    }

    public LoadCommand getLoadCommand(LoadCommandKind k) {
        if (k == LoadCommandKind.SEGMENT_64) {
            throw new IllegalArgumentException("use getSegments() to get segments");
        }
        for (LoadCommand cmd : this.loadCommands) {
            if (cmd.cmdKind != k) continue;
            return cmd;
        }
        return null;
    }

    public Segment64Command getLinkEditSegment() {
        Segment64Command result = (Segment64Command)this.findSegmentByName(MachOObjectFile.getUnnamedSegmentName());
        return result;
    }

    public MachORelocationElement getRelocationElement() {
        return this.relocs;
    }

    public MachORelocationElement getOrCreateRelocationElement() {
        if (this.relocs == null) {
            Segment64Command containingSegment = this.getOrCreateSegment(MachOObjectFile.getUnnamedSegmentName(), null, false, false);
            this.relocs = new MachORelocationElement(containingSegment);
        }
        return this.relocs;
    }

    @Override
    public Set<ObjectFile.Segment> getSegments() {
        return this.loadCommands.stream().filter(loadCmd -> loadCmd instanceof ObjectFile.Segment).map(loadCmd -> (ObjectFile.Segment)((Object)loadCmd)).collect(Collectors.toSet());
    }

    @Override
    public ObjectFile.Header getHeader() {
        return this.header;
    }

    static int encodedLengthLEB128(long value) {
        OutputAssembler dummy = AssemblyBuffer.createOutputAssembler();
        dummy.writeLEB128(value);
        return dummy.pos();
    }

    @Override
    protected int getMinimumFileSize() {
        return this.minimumFileSize;
    }

    @Override
    public int bake(List<ObjectFile.Element> sortedObjectFileElements) {
        this.minimumFileSize = 0;
        return super.bake(sortedObjectFileElements);
    }

    int segmentVaddrGivenFirstSectionVaddr(int sectionVaddr) {
        int effectiveMinVaddr = sectionVaddr >> this.getPageSizeShift() << this.getPageSizeShift();
        assert (effectiveMinVaddr <= sectionVaddr);
        return effectiveMinVaddr;
    }

    public Set<Flag> getFlags() {
        return Collections.unmodifiableSet(this.flags);
    }

    public void setFlags(EnumSet<Flag> flags) {
        this.flags.clear();
        this.flags.addAll(flags);
    }

    protected LinkEditSegment64Command getOrCreateLinkEditSegment() {
        if (this.loadCommands.linkEditCommand != null) {
            return this.loadCommands.linkEditCommand;
        }
        return this.createLinkEditSegment();
    }

    protected LinkEditSegment64Command createLinkEditSegment() {
        return new LinkEditSegment64Command();
    }

    @Override
    protected SymbolTable createSymbolTable() {
        assert (this.getSegments().size() == 1);
        Segment64Command segment = (Segment64Command)this.getSegments().iterator().next();
        MachOStrtab strtab = new MachOStrtab("MachOStrtab", this, segment);
        MachOSymtab symtab = new MachOSymtab("MachOSymtab", this, segment, strtab);
        assert (segment.contains(strtab));
        assert (segment.contains(symtab));
        SymtabCommand cmd = new SymtabCommand("MachOSymtabCommand", symtab);
        assert (cmd.symtab == symtab);
        return symtab;
    }

    @Override
    public MachOSymtab getSymbolTable() {
        ObjectFile.Segment segment = null;
        String segmentName = MachOObjectFile.getUnnamedSegmentName();
        Set<ObjectFile.Segment> segs = this.getSegments();
        for (ObjectFile.Segment seg : segs) {
            if (!seg.getName().equals(segmentName)) continue;
            segment = seg;
            break;
        }
        assert (segment != null);
        for (LoadCommand cmd : this.loadCommands) {
            if (!(cmd instanceof SymtabCommand)) continue;
            MachOSymtab e = ((SymtabCommand)cmd).symtab;
            assert (segment.contains(e));
            return e;
        }
        return null;
    }

    public void addOpaqueLoadCommand(String name, LoadCommandKind k, final byte[] bs) {
        new LoadCommand(name, k){

            @Override
            protected void writePayload(OutputAssembler out, Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided) {
                out.writeBlob(bs);
            }
        };
    }

    static {
        for (LoadCommandKind k : LoadCommandKind.values()) {
            loadCommandKindsByValue.put((int)k.getValue(), k);
        }
    }

    abstract class LinkEditElement
    extends ObjectFile.Element {
        final Segment64Command segment;

        @Override
        public ElementImpl getImpl() {
            return this;
        }

        LinkEditElement(String name, Segment64Command containingSegment) {
            this(name, containingSegment, containingSegment.isEmpty() ? this$0.getPageSize() : 1);
        }

        LinkEditElement(String name, Segment64Command containingSegment, int alignment) {
            super(name, alignment);
            this.segment = containingSegment;
            containingSegment.add(this);
        }

        @Override
        public boolean isLoadable() {
            return true;
        }

        @Override
        public int getOrDecideVaddr(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int vaddrHint) {
            return ObjectFile.defaultGetOrDecideVaddr(alreadyDecided, this, vaddrHint);
        }

        @Override
        public LayoutDecisionMap getDecisions(LayoutDecisionMap copyingIn) {
            return ObjectFile.defaultDecisions(this, copyingIn);
        }

        @Override
        public int getOrDecideOffset(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int offsetHint) {
            return ObjectFile.defaultGetOrDecideOffset(alreadyDecided, this, offsetHint);
        }
    }

    public class LinkEditSegment64Command
    extends Segment64Command {
        private MachOSymtab symtab;
        private MachOStrtab strtab;

        public LinkEditSegment64Command() {
            super("LinkEditSegment", "__LINKEDIT");
            this.initprot = EnumSet.of(VMProt.READ);
            this.maxprot = EnumSet.of(VMProt.READ, VMProt.WRITE, VMProt.EXECUTE);
        }

        public MachOSymtab getSymtab() {
            return this.symtab;
        }

        public MachOStrtab getStrtab() {
            return this.strtab;
        }

        public MachORelocationElement getRelocations() {
            return MachOObjectFile.this.relocs;
        }
    }

    public class Segment64Command
    extends LoadCommand
    implements ObjectFile.Segment {
        String segname;
        EnumSet<VMProt> maxprot;
        EnumSet<VMProt> initprot;
        int flags;
        List<ObjectFile.Element> elementsInSegment;
        List<SectionInfoStruct> readStructs;

        @Override
        public String getName() {
            return this.segname;
        }

        @Override
        public void setName(String name) {
            this.segname = name;
        }

        @Override
        public boolean isExecutable() {
            return this.initprot.contains(VMProt.EXECUTE);
        }

        @Override
        public boolean isWritable() {
            return this.initprot.contains(VMProt.WRITE);
        }

        public Segment64Command(String name, String segmentName) {
            super(name, LoadCommandKind.SEGMENT_64);
            this.maxprot = EnumSet.noneOf(VMProt.class);
            this.initprot = EnumSet.noneOf(VMProt.class);
            this.elementsInSegment = new ArrayList<ObjectFile.Element>();
            this.readStructs = new ArrayList<SectionInfoStruct>();
            this.segname = segmentName;
        }

        @Override
        protected void writePayload(OutputAssembler db, Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided) {
            db.writeStringPadded(this.segname, 16);
            HashMap<ObjectFile.Element, LayoutDecisionMap> decidedAboutOurElements = new HashMap<ObjectFile.Element, LayoutDecisionMap>();
            for (ObjectFile.Element e : this.elementsInSegment) {
                if (!(e instanceof MachOSection)) continue;
                decidedAboutOurElements.put(e, alreadyDecided.get(e));
            }
            List minVaddrDecisions = MachOObjectFile.minimalDecisionValues(decidedAboutOurElements, LayoutDecision.Kind.VADDR, new ObjectFile.IntegerDecisionComparator(true));
            int minVaddr = minVaddrDecisions == null || minVaddrDecisions.size() == 0 ? 0 : (Integer)((LayoutDecision)minVaddrDecisions.get(0)).getValue();
            List maxVaddrDecisions = MachOObjectFile.maximalDecisionValues(decidedAboutOurElements, LayoutDecision.Kind.VADDR, new ObjectFile.IntegerDecisionComparator(false));
            Collections.sort(maxVaddrDecisions, new ObjectFile.SizeTiebreakComparator(decidedAboutOurElements, false));
            LayoutDecision maxVaddrDecision = (LayoutDecision)maxVaddrDecisions.get(maxVaddrDecisions.size() - 1);
            int maxVaddr = maxVaddrDecision == null ? 0 : (Integer)maxVaddrDecision.getValue() + maxVaddrDecision.getElement().getMemSize(alreadyDecided);
            int vmSize = ObjectFile.nextIntegerMultiple(maxVaddr - minVaddr, MachOObjectFile.this.getPageSize());
            ObjectFile.Element firstSectionByVaddr = minVaddrDecisions == null ? null : ((LayoutDecision)minVaddrDecisions.get(0)).getElement();
            ObjectFile.Element lastSectionByVaddr = maxVaddrDecision == null ? null : maxVaddrDecision.getElement();
            List minOffsetDecisions = MachOObjectFile.minimalDecisionValues(decidedAboutOurElements, LayoutDecision.Kind.OFFSET, new ObjectFile.IntegerDecisionComparator(true));
            int minOffset = minOffsetDecisions == null || minOffsetDecisions.size() == 0 ? 0 : (Integer)((LayoutDecision)minOffsetDecisions.get(0)).getValue();
            List maxOffsetDecisions = MachOObjectFile.maximalDecisionValues(decidedAboutOurElements, LayoutDecision.Kind.OFFSET, new ObjectFile.IntegerDecisionComparator(false));
            Collections.sort(maxOffsetDecisions, new ObjectFile.SizeTiebreakComparator(decidedAboutOurElements, false));
            LayoutDecision maxOffsetDecision = (LayoutDecision)maxOffsetDecisions.get(maxOffsetDecisions.size() - 1);
            ObjectFile.Element firstElementByOffset = minOffsetDecisions == null ? null : ((LayoutDecision)minOffsetDecisions.get(0)).getElement();
            ObjectFile.Element lastElementByOffset = maxOffsetDecision == null ? null : maxOffsetDecision.getElement();
            int fileOffset = firstElementByOffset == null ? 0 : (Integer)alreadyDecided.get(firstElementByOffset).getDecidedValue(LayoutDecision.Kind.OFFSET);
            int maxOffset = maxOffsetDecision == null ? 0 : (Integer)maxOffsetDecision.getValue() + (Integer)alreadyDecided.get(maxOffsetDecision.getElement()).getDecidedValue(LayoutDecision.Kind.SIZE);
            int fileSize = maxOffset - minOffset;
            int effectiveMinVaddr = MachOObjectFile.this.segmentVaddrGivenFirstSectionVaddr(minVaddr);
            assert (effectiveMinVaddr >= 0);
            int prePadding = minVaddr - effectiveMinVaddr;
            int effectiveVmSize = vmSize + prePadding;
            int effectiveFileOffset = fileOffset - prePadding;
            int effectiveFileSize = fileSize + prePadding;
            db.write8Byte(effectiveMinVaddr);
            db.write8Byte(effectiveVmSize);
            db.write8Byte(effectiveFileOffset);
            if (this != MachOObjectFile.this.getLinkEditSegment()) {
                effectiveFileSize = ObjectFile.nextIntegerMultiple(effectiveFileSize, MachOObjectFile.this.getPageSize());
                MachOObjectFile.this.minimumFileSize = Math.max(MachOObjectFile.this.minimumFileSize, effectiveFileOffset + effectiveFileSize);
            }
            db.write8Byte(effectiveFileSize);
            db.write4Byte((int)ObjectFile.flagSetAsLong(this.maxprot));
            db.write4Byte((int)ObjectFile.flagSetAsLong(this.initprot));
            int sectionCountPos = db.pos();
            db.write4Byte(0);
            db.write4Byte(this.flags);
            db.align(8);
            int sectionCount = 0;
            for (ObjectFile.Element el : this.elementsInSegment) {
                if (!(el instanceof ObjectFile.Section)) continue;
                ++sectionCount;
                MachOSection s = (MachOSection)el;
                int logAlignment = (int)(Math.log10(s.getAlignment()) / Math.log10(2.0));
                MachORelocationElement ourRelocs = null;
                if (MachOObjectFile.this.getLinkEditSegment() != null) {
                    for (ObjectFile.Element e : MachOObjectFile.this.getLinkEditSegment().elementsInSegment) {
                        if (!(e instanceof MachORelocationElement) || !((MachORelocationElement)e).relocatesSegment(this)) continue;
                        if (ourRelocs == null) {
                            ourRelocs = (MachORelocationElement)e;
                            continue;
                        }
                        assert (false);
                    }
                }
                assert (s.destinationSegmentName != null);
                SectionInfoStruct si = new SectionInfoStruct(s.getName(), s.destinationSegmentName, s.getElement().isReferenceable() ? (long)((Integer)alreadyDecided.get(s).getDecidedValue(LayoutDecision.Kind.VADDR)).intValue() : 0L, ((Integer)alreadyDecided.get(s).getDecidedValue(LayoutDecision.Kind.SIZE)).intValue(), (Integer)alreadyDecided.get(s).getDecidedValue(LayoutDecision.Kind.OFFSET), logAlignment, ourRelocs == null ? 0 : (Integer)alreadyDecided.get(ourRelocs).getDecidedValue(LayoutDecision.Kind.OFFSET) + ourRelocs.startIndexFor(s) * ourRelocs.encodedEntrySize(), ourRelocs == null ? 0 : ourRelocs.countFor(s), (int)ObjectFile.flagSetAsLong(s.flags) | s.type.getValue(), 0, 0);
                int startPos = db.pos();
                si.write(db);
                assert (db.pos() - startPos == 80);
            }
            db.pushSeek(sectionCountPos);
            db.write4Byte(sectionCount);
            db.pop();
        }

        private int sectionsInSegment() {
            int count = 0;
            for (ObjectFile.Element e : this.elementsInSegment) {
                if (!(e instanceof ObjectFile.Section)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
            return 72 + this.sectionsInSegment() * 80;
        }

        @Override
        public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
            HashSet<BuildDependency> deps = ObjectFile.minimalDependencies(decisions, this);
            LayoutDecision ourContent = decisions.get(this).getDecision(LayoutDecision.Kind.CONTENT);
            for (ObjectFile.Element s : this.elementsInSegment) {
                deps.add(BuildDependency.createOrGet(ourContent, decisions.get(s).getDecision(LayoutDecision.Kind.SIZE)));
                deps.add(BuildDependency.createOrGet(ourContent, decisions.get(s).getDecision(LayoutDecision.Kind.OFFSET)));
                if (!s.getElement().isReferenceable()) continue;
                deps.add(BuildDependency.createOrGet(ourContent, decisions.get(s).getDecision(LayoutDecision.Kind.VADDR)));
            }
            if (this.getName() != null && this.getName().equals("__LINKEDIT")) {
                assert (this == MachOObjectFile.this.loadCommands.linkEditCommand);
            } else if (MachOObjectFile.this.getLinkEditSegment() != null) {
                for (ObjectFile.Element e : MachOObjectFile.this.getLinkEditSegment().elementsInSegment) {
                    if (!(e instanceof MachORelocationElement) || !((MachORelocationElement)e).relocatesSegment(this)) continue;
                    deps.add(BuildDependency.createOrGet(ourContent, decisions.get(e).getDecision(LayoutDecision.Kind.OFFSET)));
                }
            }
            return deps;
        }

        @Override
        public void add(int arg0, ObjectFile.Element arg1) {
            this.elementsInSegment.add(arg0, arg1);
        }

        @Override
        public boolean add(ObjectFile.Element arg0) {
            return this.elementsInSegment.add(arg0);
        }

        @Override
        public boolean addAll(Collection<? extends ObjectFile.Element> arg0) {
            return this.elementsInSegment.addAll(arg0);
        }

        @Override
        public boolean addAll(int arg0, Collection<? extends ObjectFile.Element> arg1) {
            return this.elementsInSegment.addAll(arg0, arg1);
        }

        @Override
        public void clear() {
            this.elementsInSegment.clear();
        }

        @Override
        public boolean contains(Object arg0) {
            return this.elementsInSegment.contains(arg0);
        }

        @Override
        public boolean containsAll(Collection<?> arg0) {
            return this.elementsInSegment.containsAll(arg0);
        }

        @Override
        public ObjectFile.Element get(int arg0) {
            return this.elementsInSegment.get(arg0);
        }

        @Override
        public int indexOf(Object arg0) {
            return this.elementsInSegment.indexOf(arg0);
        }

        @Override
        public boolean isEmpty() {
            return this.elementsInSegment.isEmpty();
        }

        @Override
        public Iterator<ObjectFile.Element> iterator() {
            return this.elementsInSegment.iterator();
        }

        @Override
        public int lastIndexOf(Object arg0) {
            return this.elementsInSegment.lastIndexOf(arg0);
        }

        @Override
        public ListIterator<ObjectFile.Element> listIterator() {
            return this.elementsInSegment.listIterator();
        }

        @Override
        public ListIterator<ObjectFile.Element> listIterator(int arg0) {
            return this.elementsInSegment.listIterator(arg0);
        }

        @Override
        public ObjectFile.Element remove(int arg0) {
            return this.elementsInSegment.remove(arg0);
        }

        @Override
        public boolean remove(Object arg0) {
            return this.elementsInSegment.remove(arg0);
        }

        @Override
        public boolean removeAll(Collection<?> arg0) {
            return this.elementsInSegment.removeAll(arg0);
        }

        @Override
        public boolean retainAll(Collection<?> arg0) {
            return this.elementsInSegment.retainAll(arg0);
        }

        @Override
        public ObjectFile.Element set(int arg0, ObjectFile.Element arg1) {
            return this.elementsInSegment.set(arg0, arg1);
        }

        @Override
        public int size() {
            return this.elementsInSegment.size();
        }

        @Override
        public List<ObjectFile.Element> subList(int arg0, int arg1) {
            return this.elementsInSegment.subList(arg0, arg1);
        }

        @Override
        public Object[] toArray() {
            return this.elementsInSegment.toArray();
        }

        @Override
        public <T> T[] toArray(T[] arg0) {
            return this.elementsInSegment.toArray(arg0);
        }
    }

    public static class SectionInfoStruct {
        public static final int DEFAULT_SIZE = 80;
        String sectName;
        String segName;
        long addr;
        long size;
        int offset;
        int align;
        int reloff;
        int nreloc;
        int flags;
        int reserved1;
        int reserved2;

        public SectionInfoStruct(String sectName, String segName, long addr, long size, int offset, int align, int reloff, int nreloc, int flags, int reserved1, int reserved2) {
            this.sectName = sectName;
            this.segName = segName;
            this.addr = addr;
            this.size = size;
            this.offset = offset;
            this.align = align;
            this.reloff = reloff;
            this.nreloc = nreloc;
            this.flags = flags;
            this.reserved1 = reserved1;
            this.reserved2 = reserved2;
        }

        public void write(OutputAssembler db) {
            db.writeStringPadded(this.sectName, 16);
            db.writeStringPadded(this.segName, 16);
            db.write8Byte(this.addr);
            db.write8Byte(this.size);
            db.write4Byte(this.offset);
            db.write4Byte(this.align);
            db.write4Byte(this.reloff);
            db.write4Byte(this.nreloc);
            db.write4Byte(this.flags);
            db.write4Byte(this.reserved1);
            db.write4Byte(this.reserved2);
            db.align(8);
        }

        public String toString() {
            return String.format("Section Info, name %s, segment %s", this.sectName, this.segName) + String.format("\n  address %#x, size %d (%2$#x), offset %d (%3$#x), align %#x", this.addr, this.size, this.offset, this.align) + String.format("\n  first relocation entry at %d (%1$#x), number of relocation entries %d", this.reloff, this.nreloc) + String.format("\n  flags %#x, reserved %d %d", this.flags, this.reserved1, this.reserved2);
        }
    }

    public static enum VMProt implements ObjectFile.ValueEnum
    {
        READ(1),
        WRITE(2),
        EXECUTE(4);

        private final int value;

        private VMProt(int value) {
            this.value = value;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    public class DySymtabCommand
    extends LoadCommand {
        MachOSymtab symtab;
        private static final int PAYLOAD_SIZE = 72;

        public DySymtabCommand(String name, MachOSymtab symtab) {
            super(name, LoadCommandKind.DYSYMTAB);
            this.symtab = symtab;
        }

        @Override
        protected void writePayload(OutputAssembler out, Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided) {
            int startPos = out.pos();
            out.write4Byte(this.symtab.firstLocal());
            out.write4Byte(this.symtab.nLocals());
            out.write4Byte(this.symtab.firstExtDef());
            out.write4Byte(this.symtab.nExtDef());
            out.write4Byte(this.symtab.firstUndef());
            out.write4Byte(this.symtab.nUndef());
            out.write4Byte(0);
            out.write4Byte(0);
            out.write4Byte(0);
            out.write4Byte(0);
            out.write4Byte(0);
            out.write4Byte(0);
            out.write4Byte(0);
            out.write4Byte(0);
            out.write4Byte(0);
            out.write4Byte(0);
            out.write4Byte(0);
            out.write4Byte(0);
            assert (out.pos() == startPos + 72);
        }

        @Override
        public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
            HashSet<BuildDependency> deps = ObjectFile.minimalDependencies(decisions, this);
            return deps;
        }

        @Override
        public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
            return this.getWrittenSize(72);
        }
    }

    public class SymtabCommand
    extends LoadCommand {
        MachOSymtab symtab;

        public SymtabCommand(String name, MachOSymtab symtab) {
            super(name, LoadCommandKind.SYMTAB);
            this.symtab = symtab;
        }

        @Override
        protected void writePayload(OutputAssembler out, Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided) {
            int symtabOffset = (Integer)alreadyDecided.get(this.symtab).getDecidedValue(LayoutDecision.Kind.OFFSET);
            int symtabEntriesCount = this.symtab.getEntryCount();
            int strtabOffset = (Integer)alreadyDecided.get(this.symtab.strtab).getDecidedValue(LayoutDecision.Kind.OFFSET);
            int strtabSize = (Integer)alreadyDecided.get(this.symtab.strtab).getDecidedValue(LayoutDecision.Kind.SIZE);
            this.writePayloadFields(out, symtabOffset, symtabEntriesCount, strtabOffset, strtabSize);
        }

        private void writePayloadFields(OutputAssembler out, int symtabOffset, int symtabEntriesCount, int strtabOffset, int strtabSize) {
            out.write4Byte(symtabOffset);
            out.write4Byte(symtabEntriesCount);
            out.write4Byte(strtabOffset);
            out.write4Byte(strtabSize);
        }

        private int getPayloadWrittenSize() {
            OutputAssembler oa = AssemblyBuffer.createOutputAssembler();
            this.writePayloadFields(oa, 0, 0, 0, 0);
            return oa.pos();
        }

        @Override
        public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
            return this.getWrittenSize(this.getPayloadWrittenSize());
        }

        @Override
        public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
            HashSet<BuildDependency> deps = ObjectFile.minimalDependencies(decisions, this);
            LayoutDecision ourContent = decisions.get(this).getDecision(LayoutDecision.Kind.CONTENT);
            LayoutDecision strtabSize = decisions.get(this.symtab.strtab).getDecision(LayoutDecision.Kind.SIZE);
            LayoutDecision strtabOffset = decisions.get(this.symtab.strtab).getDecision(LayoutDecision.Kind.OFFSET);
            LayoutDecision symtabOffset = decisions.get(this.symtab).getDecision(LayoutDecision.Kind.OFFSET);
            deps.add(BuildDependency.createOrGet(ourContent, strtabSize));
            deps.add(BuildDependency.createOrGet(ourContent, strtabOffset));
            deps.add(BuildDependency.createOrGet(ourContent, symtabOffset));
            return deps;
        }
    }

    public abstract class MachOSection
    extends ObjectFile.Section {
        SectionType type;
        EnumSet<SectionFlag> flags;
        Segment64Command segment;
        String destinationSegmentName;

        @Override
        public boolean isLoadable() {
            if (this.getImpl() == this) {
                return true;
            }
            return this.getImpl().isLoadable();
        }

        @Override
        public boolean isReferenceable() {
            if (this.getImpl() == this) {
                return this.isLoadable();
            }
            return this.getImpl().isReferenceable();
        }

        public MachOSection(String name, int alignment, Segment64Command segment, SectionType t, EnumSet<SectionFlag> flags) {
            int firstNonSectionPosition;
            super(name, alignment);
            if (name.length() > 16) {
                throw new IllegalArgumentException("Mach-O section names may not be longer than 16 characters");
            }
            this.type = SectionType.REGULAR;
            assert (t.equals((Object)this.type));
            this.flags = flags;
            for (firstNonSectionPosition = 0; firstNonSectionPosition < segment.size() && segment.get(firstNonSectionPosition) instanceof ObjectFile.Section; ++firstNonSectionPosition) {
            }
            segment.add(firstNonSectionPosition, this);
            this.segment = segment;
            this.destinationSegmentName = name.contains("debug") ? "__DWARF" : (flags.contains(SectionFlag.SOME_INSTRUCTIONS) ? "__TEXT" : "__DATA");
        }

        public ObjectFile.Segment getSegment() {
            return this.segment;
        }

        public void setDestinationSegmentName(String dest) {
            this.destinationSegmentName = dest;
        }

        @Override
        public MachOObjectFile getOwner() {
            return (MachOObjectFile)super.getOwner();
        }
    }

    public static enum SectionFlag implements ObjectFile.ValueEnum
    {
        LOC_RELOC(256),
        EXT_RELOC(512),
        SOME_INSTRUCTIONS(1024),
        DEBUG(0x2000000),
        SELF_MODIFYING_CODE(0x4000000),
        LIVE_SUPPORT(0x8000000),
        NO_DEAD_STRIP(0x10000000),
        STRIP_STATIC_SYMS(0x20000000),
        NO_TOC(0x40000000),
        PURE_INSTRUCTIONS(Integer.MIN_VALUE);

        private final int value;

        private SectionFlag(int value) {
            this.value = value;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    public static enum SectionType {
        REGULAR,
        ZEROFILL,
        LITERALS_CSTRING,
        LITERALS_4BYTE,
        LITERALS_8BYTE,
        LITERALS_POINTER,
        NON_LAZY_SYMBOL_POINTERS,
        LAZY_SYMBOL_POINTERS,
        SYMBOL_STUBS,
        MOD_INIT_FUNC_POINTERS,
        MOD_TERM_FUNC_POINTERS,
        COALESCED,
        GB_ZEROFILL;


        static SectionType fromFlags(int flags) {
            return SectionType.values()[flags & 0xFF];
        }

        int getValue() {
            return this.ordinal();
        }
    }

    class DataInCodeCommand
    extends LoadCommand {
        DataInCodeElement el;

        DataInCodeCommand(String name) {
            super(name, LoadCommandKind.DATA_IN_CODE);
            this.el = new DataInCodeElement(name);
        }

        @Override
        public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
            HashSet<BuildDependency> deps = ObjectFile.minimalDependencies(decisions, this);
            LayoutDecision ourContent = decisions.get(this).getDecision(LayoutDecision.Kind.CONTENT);
            LayoutDecision elOffset = decisions.get(this.el).getDecision(LayoutDecision.Kind.OFFSET);
            LayoutDecision elSize = decisions.get(this.el).getDecision(LayoutDecision.Kind.SIZE);
            deps.add(BuildDependency.createOrGet(ourContent, elOffset));
            deps.add(BuildDependency.createOrGet(ourContent, elSize));
            return deps;
        }

        @Override
        protected void writePayload(OutputAssembler out, Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided) {
            out.write4Byte((Integer)alreadyDecided.get(this.el).getDecidedValue(LayoutDecision.Kind.OFFSET));
            out.write4Byte((Integer)alreadyDecided.get(this.el).getDecidedValue(LayoutDecision.Kind.SIZE));
        }

        @Override
        public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
            return this.getWrittenSize(8);
        }
    }

    class DataInCodeElement
    extends LinkEditElement {
        DataInCodeElement(String name) {
            super(name, MachOObjectFile.this.getLinkEditSegment());
        }

        @Override
        public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
            HashSet<BuildDependency> deps = ObjectFile.minimalDependencies(decisions, this);
            LayoutDecision ourContent = decisions.get(this).getDecision(LayoutDecision.Kind.CONTENT);
            for (ObjectFile.Section s : MachOObjectFile.this.getSections()) {
                MachOSection ms = (MachOSection)s;
                if (!ms.flags.contains(SectionFlag.SOME_INSTRUCTIONS)) continue;
                deps.add(BuildDependency.createOrGet(ourContent, decisions.get(s).getDecision(LayoutDecision.Kind.OFFSET)));
                deps.add(BuildDependency.createOrGet(ourContent, decisions.get(s).getDecision(LayoutDecision.Kind.SIZE)));
            }
            return deps;
        }

        @Override
        public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
            int count = 0;
            for (ObjectFile.Section s : MachOObjectFile.this.getSections()) {
                MachOSection ms = (MachOSection)s;
                if (!ms.flags.contains(SectionFlag.SOME_INSTRUCTIONS)) continue;
                ++count;
            }
            return count * new EntryStruct().getWrittenSize();
        }

        @Override
        public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
            OutputAssembler out = AssemblyBuffer.createOutputAssembler(this.getOwner().getByteOrder());
            ArrayList<LayoutDecision> decisionsOfInterest = new ArrayList<LayoutDecision>();
            for (ObjectFile.Section s : MachOObjectFile.this.getSections()) {
                MachOSection ms = (MachOSection)s;
                if (!ms.flags.contains(SectionFlag.SOME_INSTRUCTIONS)) continue;
                decisionsOfInterest.add(alreadyDecided.get(s).getDecision(LayoutDecision.Kind.OFFSET));
            }
            Collections.sort(decisionsOfInterest, new ObjectFile.IntegerDecisionComparator(false));
            assert (decisionsOfInterest.size() == 0 || ((LayoutDecision)decisionsOfInterest.get(0)).isTaken());
            EntryStruct ent = new EntryStruct();
            for (int i = 0; i < decisionsOfInterest.size(); ++i) {
                LayoutDecision decision = (LayoutDecision)decisionsOfInterest.get(i);
                ent.fileOffset = (Integer)decision.getValue();
                int fileSize = (Integer)alreadyDecided.get(decision.getElement()).getDecidedValue(LayoutDecision.Kind.SIZE);
                int sectionEndInFile = ent.fileOffset + fileSize;
                Integer nextOffset = i + 1 < decisionsOfInterest.size() ? Integer.valueOf((Integer)((LayoutDecision)decisionsOfInterest.get(i + 1)).getValue()) : null;
                int nextPageBoundary = sectionEndInFile % MachOObjectFile.this.getPageSize() == 0 ? sectionEndInFile : (sectionEndInFile >> MachOObjectFile.this.getPageSizeShift()) + 1 << MachOObjectFile.this.getPageSizeShift();
                ent.length = (short)(nextOffset == null ? nextPageBoundary : Math.min(nextPageBoundary, nextOffset));
                ent.entryKind = 0;
                ent.write(out);
            }
            return out.getBlob();
        }

        class EntryStruct {
            int fileOffset;
            short length;
            short entryKind;

            EntryStruct() {
            }

            int getWrittenSize() {
                return 8;
            }

            void write(OutputAssembler oa) {
                oa.write4Byte(this.fileOffset);
                oa.write2Byte(this.length);
                oa.write2Byte(this.entryKind);
            }
        }
    }

    class FunctionStartsElement
    extends LinkEditElement {
        private static final int BIGGEST_INTER_FUNCTION_GAP = 65536;

        FunctionStartsElement(String name) {
            super(name, MachOObjectFile.this.getLinkEditSegment());
        }

        @Override
        public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
            OutputAssembler out = AssemblyBuffer.createOutputAssembler(this.getOwner().getByteOrder());
            TreeSet<Integer> fileOffsets = new TreeSet<Integer>();
            for (ObjectFile.Symbol symbol : this.symbolsOfInterest()) {
                ObjectFile.Section s = symbol.getDefinedSection();
                assert (s != null);
                int sectionOffset = (Integer)alreadyDecided.get(s).getDecidedValue(LayoutDecision.Kind.OFFSET);
                fileOffsets.add(sectionOffset + (int)symbol.getDefinedOffset());
            }
            Integer previousOffset = null;
            for (Integer i : fileOffsets) {
                if (previousOffset == null) {
                    ObjectFile.Segment textSegment = null;
                    for (ObjectFile.Segment s : MachOObjectFile.this.getSegments()) {
                        if (!s.getName().equals("__TEXT")) continue;
                        textSegment = s;
                        break;
                    }
                    if (textSegment == null) break;
                    out.writeLEB128(i.intValue());
                    continue;
                }
                out.writeLEB128(i - previousOffset);
            }
            out.writeLEB128(0L);
            int n = this.overapproximateSize();
            assert (out.pos() <= n);
            out.skip(n - out.pos());
            return out.getBlob();
        }

        private int overapproximateSize() {
            int size = 1;
            for (ObjectFile.Symbol sym : this.symbolsOfInterest()) {
                ObjectFile.Section s = sym.getDefinedSection();
                assert (s != null);
                int offsetEncodedLength = MachOObjectFile.encodedLengthLEB128(65536L);
                size += offsetEncodedLength;
            }
            return size;
        }

        @Override
        public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
            Object decidedContent = alreadyDecided.get(this).getDecidedValue(LayoutDecision.Kind.CONTENT);
            assert (decidedContent != null);
            return ((byte[])decidedContent).length;
        }

        @Override
        public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
            HashSet<BuildDependency> deps = ObjectFile.defaultDependencies(decisions, this);
            ArrayList<ObjectFile.Section> requiredOffsets = new ArrayList<ObjectFile.Section>();
            for (LoadCommand c : MachOObjectFile.this.loadCommands) {
                if (!(c instanceof SymtabCommand)) continue;
                SymtabCommand syms = (SymtabCommand)c;
                for (ObjectFile.Symbol sym : syms.symtab) {
                    if (!sym.isDefined() || !sym.isFunction() || sym.isAbsolute()) continue;
                    ObjectFile.Section s = sym.getDefinedSection();
                    assert (s != null);
                    requiredOffsets.add(s);
                }
            }
            LayoutDecision ourContent = decisions.get(this).getDecision(LayoutDecision.Kind.CONTENT);
            for (ObjectFile.Section s : requiredOffsets) {
                deps.add(BuildDependency.createOrGet(ourContent, decisions.get(s).getDecision(LayoutDecision.Kind.OFFSET)));
            }
            return deps;
        }

        private List<ObjectFile.Symbol> symbolsOfInterest() {
            ArrayList<ObjectFile.Symbol> ofInterest = new ArrayList<ObjectFile.Symbol>();
            for (LoadCommand c : MachOObjectFile.this.loadCommands) {
                if (!(c instanceof SymtabCommand)) continue;
                SymtabCommand syms = (SymtabCommand)c;
                for (ObjectFile.Symbol sym : syms.symtab) {
                    if (!sym.isDefined() || !sym.isFunction() || sym.isAbsolute()) continue;
                    ofInterest.add(sym);
                }
            }
            return ofInterest;
        }
    }

    class FunctionStartsCommand
    extends LoadCommand {
        FunctionStartsElement el;

        FunctionStartsCommand(String name) {
            super(name, LoadCommandKind.FUNCTION_STARTS);
            this.el = new FunctionStartsElement("MachOFunctionStartsElement");
        }

        @Override
        public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
            HashSet<BuildDependency> deps = ObjectFile.minimalDependencies(decisions, this);
            LayoutDecision ourContent = decisions.get(this).getDecision(LayoutDecision.Kind.CONTENT);
            deps.add(BuildDependency.createOrGet(ourContent, decisions.get(this.el).getDecision(LayoutDecision.Kind.OFFSET)));
            deps.add(BuildDependency.createOrGet(ourContent, decisions.get(this.el).getDecision(LayoutDecision.Kind.SIZE)));
            return deps;
        }

        @Override
        protected void writePayload(OutputAssembler out, Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided) {
            int elOffset = (Integer)alreadyDecided.get(this.el).getDecidedValue(LayoutDecision.Kind.OFFSET);
            int elSize = (Integer)alreadyDecided.get(this.el).getDecidedValue(LayoutDecision.Kind.SIZE);
            out.write4Byte(elOffset);
            out.write4Byte(elSize);
        }

        @Override
        public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
            return this.getWrittenSize(8);
        }
    }

    public class RPathCommand
    extends LoadCommand {
        String dirname;

        public RPathCommand(String name, String dirname) {
            super(name, LoadCommandKind.RPATH);
            this.dirname = dirname;
        }

        @Override
        protected void writePayload(OutputAssembler out, Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided) {
            int loadCommandHeaderSize = this.getWrittenSize(0);
            int stroff = loadCommandHeaderSize + 4;
            out.write4Byte(stroff);
            out.writeString(this.dirname);
        }
    }

    public class LoadDylibCommand
    extends AbstractDylibCommand {
        int timestamp;
        int currentVersion;
        int compatVersion;

        public LoadDylibCommand(String name, String libname, int timestamp, int currentVersion, int compatVersion) {
            super(name, LoadCommandKind.LOAD_DYLIB);
            this.libName = libname;
            this.timestamp = timestamp;
            this.currentVersion = currentVersion;
            this.compatVersion = compatVersion;
        }

        @Override
        protected void writePayload(OutputAssembler out, Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided) {
            int loadCommandHeaderSize = this.getWrittenSize(0);
            DylibStruct s = new DylibStruct(0, this.timestamp, this.currentVersion, this.compatVersion);
            s.stroff = loadCommandHeaderSize + s.getWrittenSize();
            s.write(out);
            out.writeString(this.libName);
        }
    }

    class VersionMinMacOSCommand
    extends LoadCommand {
        VersionMinMacOSCommand(String name) {
            super(name, LoadCommandKind.VERSION_MIN_MACOS);
        }

        @Override
        protected void writePayload(OutputAssembler out, Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided) {
            out.writeByte((byte)0);
            out.writeByte((byte)7);
            out.writeByte((byte)10);
            out.writeByte((byte)0);
            out.write4Byte(0);
        }
    }

    public class IDDylibCommand
    extends AbstractDylibCommand {
        public IDDylibCommand(String name, String libName) {
            super(name, LoadCommandKind.ID_DYLIB);
            this.libName = libName;
        }

        public IDDylibCommand(String name) {
            super(name, LoadCommandKind.ID_DYLIB);
        }
    }

    public abstract class AbstractDylibCommand
    extends LoadCommand {
        String libName;

        public AbstractDylibCommand(String name, LoadCommandKind k, String libName) {
            super(name, k);
            this.libName = "blah.dylib";
            this.libName = libName;
        }

        public AbstractDylibCommand(String name, LoadCommandKind k) {
            super(name, k);
            this.libName = "blah.dylib";
        }

        @Override
        protected void writePayload(OutputAssembler out, Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided) {
            int loadCommandHeaderLength = this.getWrittenSize(0);
            DylibStruct s = new DylibStruct(0, 0, 0, 0);
            s.stroff = loadCommandHeaderLength + s.getWrittenSize();
            s.write(out);
            out.writeString(this.libName);
        }

        public void setLibName(String libName) {
            this.libName = libName;
        }
    }

    static class DylibStruct {
        int stroff;
        int timestamp;
        int currentVersion;
        int compatibilityVersion;

        public void write(OutputAssembler out) {
            out.write4Byte(this.stroff);
            out.write4Byte(this.timestamp);
            out.write4Byte(this.currentVersion);
            out.write4Byte(this.compatibilityVersion);
        }

        DylibStruct(int stroff, int timestamp, int currentVersion, int compatibilityVersion) {
            this.stroff = stroff;
            this.timestamp = timestamp;
            this.currentVersion = currentVersion;
            this.compatibilityVersion = compatibilityVersion;
        }

        public int getWrittenSize() {
            OutputAssembler oa = AssemblyBuffer.createOutputAssembler();
            this.write(oa);
            return oa.pos();
        }
    }

    public class UUIDCommand
    extends LoadCommand {
        byte[] uuidbytes;

        public UUIDCommand(String name) {
            super(name, LoadCommandKind.UUID);
            UUID randomUUID = UUID.randomUUID();
            OutputAssembler oa = AssemblyBuffer.createOutputAssembler(ByteOrder.BIG_ENDIAN);
            oa.write8Byte(randomUUID.getMostSignificantBits());
            oa.write8Byte(randomUUID.getLeastSignificantBits());
            assert (oa.pos() == 16);
            this.uuidbytes = oa.getBlob();
            assert (this.uuidbytes.length == 16);
        }

        @Override
        protected void writePayload(OutputAssembler out, Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided) {
            out.writeBlob(this.uuidbytes);
        }
    }

    public abstract class LoadCommand
    extends ObjectFile.Header {
        LoadCommandKind cmdKind;

        public LoadCommand(String name, LoadCommandKind k) {
            super(name);
            this.cmdKind = k;
            MachOObjectFile.this.loadCommands.add(this);
        }

        protected abstract void writePayload(OutputAssembler var1, Map<ObjectFile.Element, LayoutDecisionMap> var2);

        @Override
        public MachOObjectFile getOwner() {
            return (MachOObjectFile)super.getOwner();
        }

        @Override
        public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
            OutputAssembler out = AssemblyBuffer.createOutputAssembler(MachOObjectFile.this.getByteOrder());
            int startPos = out.pos();
            out.write4Byte((int)this.cmdKind.getValue());
            int sizePos = out.pos();
            out.write4Byte(0);
            this.writePayload(out, alreadyDecided);
            out.align(8);
            int cmdSize = out.pos() - startPos;
            out.pushSeek(sizePos);
            out.write4Byte(cmdSize);
            out.pop();
            assert (out.pos() == startPos + cmdSize);
            return out.getBlob();
        }

        int sizeBeforePayload() {
            return this.getWrittenSize(0);
        }

        protected int getWrittenSize(int payloadSize) {
            OutputAssembler out = AssemblyBuffer.createOutputAssembler(MachOObjectFile.this.getByteOrder());
            int startPos = out.pos();
            out.write4Byte((int)this.cmdKind.getValue());
            out.write4Byte(0);
            out.skip(payloadSize);
            out.align(8);
            return out.pos() - startPos;
        }
    }

    public static enum LoadCommandKind {
        unused0,
        SEGMENT{
            {
                assert (this.getValue() == 1L);
            }
        }
        ,
        SYMTAB{
            {
                assert (this.getValue() == 2L);
            }
        }
        ,
        SYMSEG{
            {
                assert (this.getValue() == 3L);
            }
        }
        ,
        THREAD{
            {
                assert (this.getValue() == 4L);
            }
        }
        ,
        UNIXTHREAD{
            {
                assert (this.getValue() == 5L);
            }
        }
        ,
        unused6{
            {
                assert (this.getValue() == 6L);
            }
        }
        ,
        unused7{
            {
                assert (this.getValue() == 7L);
            }
        }
        ,
        unused8{
            {
                assert (this.getValue() == 8L);
            }
        }
        ,
        unused9{
            {
                assert (this.getValue() == 9L);
            }
        }
        ,
        unuseda{
            {
                assert (this.getValue() == 10L);
            }
        }
        ,
        DYSYMTAB{
            {
                assert (this.getValue() == 11L);
            }
        }
        ,
        LOAD_DYLIB{
            {
                assert (this.getValue() == 12L);
            }
        }
        ,
        ID_DYLIB{
            {
                assert (this.getValue() == 13L);
            }
        }
        ,
        LOAD_DYLINKER{
            {
                assert (this.getValue() == 14L);
            }
        }
        ,
        ID_DYLINKER{
            {
                assert (this.getValue() == 15L);
            }
        }
        ,
        PREBOUND_DYLIB{
            {
                assert (this.getValue() == 16L);
            }
        }
        ,
        ROUTINES{
            {
                assert (this.getValue() == 17L);
            }
        }
        ,
        SUB_FRAMEWORK{
            {
                assert (this.getValue() == 18L);
            }
        }
        ,
        SUB_UMBRELLA{
            {
                assert (this.getValue() == 19L);
            }
        }
        ,
        SUB_CLIENT{
            {
                assert (this.getValue() == 20L);
            }
        }
        ,
        SUB_LIBRARY{
            {
                assert (this.getValue() == 21L);
            }
        }
        ,
        TWOLEVEL_HINTS{
            {
                assert (this.getValue() == 22L);
            }
        }
        ,
        unused17{
            {
                assert (this.getValue() == 23L);
            }
        }
        ,
        unused18{
            {
                assert (this.getValue() == 0x80000018L);
            }

            @Override
            public long getValue() {
                return super.getValue() | 0x80000000L;
            }
        }
        ,
        SEGMENT_64{
            {
                assert (this.getValue() == 25L);
            }
        }
        ,
        ROUTINES_64{
            {
                assert (this.getValue() == 26L);
            }
        }
        ,
        UUID{
            {
                assert (this.getValue() == 27L);
            }
        }
        ,
        RPATH{
            {
                assert (this.getValue() == 2147483676L);
            }

            @Override
            public long getValue() {
                return super.getValue() | 0x80000000L;
            }
        }
        ,
        unused1d{
            {
                assert (this.getValue() == 29L);
            }
        }
        ,
        unused1e{
            {
                assert (this.getValue() == 30L);
            }
        }
        ,
        unused1f{
            {
                assert (this.getValue() == 2147483679L);
            }

            @Override
            public long getValue() {
                return super.getValue() | 0x80000000L;
            }
        }
        ,
        unused20{
            {
                assert (this.getValue() == 32L);
            }
        }
        ,
        unused21{
            {
                assert (this.getValue() == 33L);
            }
        }
        ,
        DYLD_INFO{
            {
                assert (this.getValue() == 34L);
            }
        }
        ,
        unused23{
            {
                assert (this.getValue() == 35L);
            }
        }
        ,
        VERSION_MIN_MACOS{
            {
                assert (this.getValue() == 36L);
            }
        }
        ,
        unused25{
            {
                assert (this.getValue() == 37L);
            }
        }
        ,
        FUNCTION_STARTS{
            {
                assert (this.getValue() == 38L);
            }
        }
        ,
        unused27{
            {
                assert (this.getValue() == 39L);
            }
        }
        ,
        unused28{
            {
                assert (this.getValue() == 0x80000028L);
            }

            @Override
            public long getValue() {
                return super.getValue() | 0x80000000L;
            }
        }
        ,
        DATA_IN_CODE{
            {
                assert (this.getValue() == 41L);
            }
        }
        ,
        unused2a{
            {
                assert (this.getValue() == 42L);
            }
        }
        ,
        unused2b{
            {
                assert (this.getValue() == 43L);
            }
        }
        ,
        REQ_DYLD{

            @Override
            public long getValue() {
                return 0x80000000L;
            }
        }
        ,
        DYLD_INFO_ONLY{

            @Override
            public long getValue() {
                return DYLD_INFO.getValue() | 0x80000000L;
            }
        };


        public long getValue() {
            return this.ordinal();
        }
    }

    class MachOHeader
    extends ObjectFile.Header {
        MachOHeader(String name) {
            super(name);
        }

        @Override
        public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
            OutputAssembler out = AssemblyBuffer.createOutputAssembler(ByteBuffer.allocate(65536).order(this.getOwner().getByteOrder()));
            out.skip(new HeaderStruct().getWrittenSize());
            out.align(8);
            int loadCommandsSizeInBytes = 0;
            for (LoadCommand cmd : MachOObjectFile.this.loadCommands) {
                loadCommandsSizeInBytes += ((Integer)alreadyDecided.get(cmd).getDecidedValue(LayoutDecision.Kind.SIZE)).intValue();
            }
            out.pushSeek(0L);
            new HeaderStruct(this.getOwner().getByteOrder() == nativeOrder ? -17958193 : -805638658, MachOObjectFile.this.cpuType, MachOObjectFile.this.cpuSubType, MachOObjectFile.this.loadCommands.size(), loadCommandsSizeInBytes, (int)ObjectFile.flagSetAsLong(MachOObjectFile.this.flags)).write(out);
            out.pop();
            return out.getBlob();
        }

        @Override
        public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
            return 32;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
            void var5_12;
            HashSet<BuildDependency> deps = new HashSet<BuildDependency>();
            ObjectFile.Segment prevNonEmptySegment = null;
            for (ObjectFile.Segment segment : MachOObjectFile.this.getSegments()) {
                Object prev = null;
                for (Object e : segment) {
                    assert (!(e instanceof ObjectFile.Header));
                    if (prev != null) {
                        assert (e != prev);
                        deps.add(BuildDependency.createOrGet(decisions.get(e).getDecision(LayoutDecision.Kind.OFFSET), decisions.get(prev).getDecision(LayoutDecision.Kind.OFFSET)));
                    }
                    prev = e;
                }
                if (segment.size() > 0 && prevNonEmptySegment != null) {
                    assert (prevNonEmptySegment != segment);
                    deps.add(BuildDependency.createOrGet(decisions.get(segment.get(0)).getDecision(LayoutDecision.Kind.OFFSET), decisions.get(prevNonEmptySegment.get(prevNonEmptySegment.size() - 1)).getDecision(LayoutDecision.Kind.OFFSET)));
                    if (((ObjectFile.Element)segment.get(0)).isReferenceable() && ((ObjectFile.Element)prevNonEmptySegment.get(prevNonEmptySegment.size() - 1)).isReferenceable()) {
                        deps.add(BuildDependency.createOrGet(decisions.get(segment.get(0)).getDecision(LayoutDecision.Kind.VADDR), decisions.get(prevNonEmptySegment.get(prevNonEmptySegment.size() - 1)).getDecision(LayoutDecision.Kind.VADDR)));
                    }
                }
                if (segment.size() <= 0) continue;
                prevNonEmptySegment = segment;
            }
            for (LoadCommand loadCommand : MachOObjectFile.this.loadCommands) {
                deps.add(BuildDependency.createOrGet(decisions.get(this).getDecision(LayoutDecision.Kind.CONTENT), decisions.get(loadCommand).getDecision(LayoutDecision.Kind.SIZE)));
            }
            deps.add(BuildDependency.createOrGet(decisions.get(this).getDecision(LayoutDecision.Kind.OFFSET), decisions.get(this).getDecision(LayoutDecision.Kind.SIZE)));
            for (ObjectFile.Segment segment : MachOObjectFile.this.getSegments()) {
                for (ObjectFile.Element el : segment) {
                    for (LoadCommand cmd : MachOObjectFile.this.loadCommands) {
                        deps.add(BuildDependency.createOrGet(decisions.get(el).getDecision(LayoutDecision.Kind.OFFSET), decisions.get(cmd).getDecision(LayoutDecision.Kind.OFFSET)));
                    }
                }
            }
            Segment64Command previousSegCmd = null;
            for (ObjectFile.Segment seg : MachOObjectFile.this.getSegments()) {
                Segment64Command segCmd = (Segment64Command)seg;
                if (previousSegCmd != null) {
                    deps.add(BuildDependency.createOrGet(decisions.get(segCmd).getDecision(LayoutDecision.Kind.OFFSET), decisions.get(previousSegCmd).getDecision(LayoutDecision.Kind.OFFSET)));
                }
                previousSegCmd = segCmd;
            }
            Object var5_11 = null;
            LoadCommand previousCmd = null;
            for (LoadCommand cmd : MachOObjectFile.this.loadCommands) {
                if (cmd instanceof Segment64Command) continue;
                if (previousCmd != null) {
                    deps.add(BuildDependency.createOrGet(decisions.get(cmd).getDecision(LayoutDecision.Kind.OFFSET), decisions.get(previousCmd).getDecision(LayoutDecision.Kind.OFFSET)));
                } else {
                    LoadCommand loadCommand = cmd;
                }
                previousCmd = cmd;
            }
            if (var5_12 != null) {
                assert (previousSegCmd != null);
                deps.add(BuildDependency.createOrGet(decisions.get(var5_12).getDecision(LayoutDecision.Kind.OFFSET), decisions.get(previousSegCmd).getDecision(LayoutDecision.Kind.OFFSET)));
            }
            return deps;
        }
    }

    private class LoadCommandList
    implements Iterable<LoadCommand> {
        LinkEditSegment64Command linkEditCommand;
        List<LoadCommand> otherCommands = new ArrayList<LoadCommand>();

        private LoadCommandList() {
        }

        private int size() {
            return this.otherCommands.size() + (this.linkEditCommand == null ? 0 : 1);
        }

        @Override
        public Iterator<LoadCommand> iterator() {
            return this.stream().iterator();
        }

        private Stream<LoadCommand> stream() {
            if (this.linkEditCommand != null) {
                return Stream.concat(this.otherCommands.stream(), Stream.of(this.linkEditCommand));
            }
            return this.otherCommands.stream();
        }

        private void add(LoadCommand arg) {
            if (arg instanceof LinkEditSegment64Command) {
                assert (this.linkEditCommand == null) : "cannot have more than one __LINKEDIT segment";
                this.linkEditCommand = (LinkEditSegment64Command)arg;
            } else {
                this.otherCommands.add(arg);
            }
        }
    }

    static class HeaderStruct {
        private int magic;
        private MachOCpuType cpuType;
        private int cpuSubtype;
        private int ncmds;
        private int sizeOfCmds;
        private int flags;
        public static final int HEADER_SIZE = 32;

        HeaderStruct(int magic, MachOCpuType cpuType, int cpuSubtype, int ncmds, int sizeOfCmds, int flags) {
            this.magic = magic;
            this.cpuType = cpuType;
            this.cpuSubtype = cpuSubtype;
            this.ncmds = ncmds;
            this.sizeOfCmds = sizeOfCmds;
            this.flags = flags;
        }

        HeaderStruct() {
        }

        public void write(OutputAssembler out) {
            int startPos = out.pos();
            assert (this.magic == -17958193 || this.magic == -805638658);
            out.setByteOrder(ByteOrder.nativeOrder());
            out.write4Byte(this.magic);
            out.setByteOrder(this.magic == -17958193 ? nativeOrder : oppositeOrder);
            out.write4Byte(this.cpuType.toInt());
            out.write4Byte(this.cpuSubtype);
            out.write4Byte(FileType.OBJECT.value);
            out.write4Byte(this.ncmds);
            out.write4Byte(this.sizeOfCmds);
            out.write4Byte(this.flags);
            out.write4Byte(0);
            assert (out.pos() - startPos == 32);
        }

        public int getWrittenSize() {
            return 32;
        }
    }

    static enum Flag implements ObjectFile.ValueEnum
    {
        NOUNDEFS(1),
        INCRLINK(2),
        DYLDLINK(4),
        BINDATLOAD(8),
        PREBOUND(16),
        SPLIT_SEGS(32),
        LAZY_INIT(64),
        TWOLEVEL(128),
        FORCE_FLAT(256),
        NOMULTIDEFS(512),
        NOFIXPREBINDING(1024),
        PREBINDABLE(2048),
        ALLMODSBOUND(4096),
        SUBSECTIONS_VIA_SYMBOLS(8192),
        CANONICAL(16384);

        private final int value;

        private Flag(int value) {
            this.value = value;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    public static enum FileType {
        OBJECT(1),
        EXECUTE(2),
        FVMLIB(3),
        PRELOAD(5),
        DYLIB(6),
        DYLINKER(7),
        BUNDLE(8),
        DYLIB_STUB(9),
        DSYM(10),
        KEXT_BUNDLE(11);

        final int value;

        private FileType(int value) {
            this.value = value;
        }
    }

    private final class MachOElementList
    extends ElementList {
        private MachOElementList() {
        }

        @Override
        public int sectionIndexToElementIndex(int sectionIndex) {
            int i = 0;
            Iterator<ObjectFile.Section> it = this.sectionsIterator();
            while (it.hasNext()) {
                ObjectFile.Section s = it.next();
                if (sectionIndex == i) {
                    return MachOObjectFile.this.elements.indexOf(s);
                }
                ++i;
            }
            return -1;
        }

        @Override
        public Iterator<ObjectFile.Section> sectionsIterator() {
            return MachOObjectFile.this.getSegments().stream().flatMap(segment -> ((Segment64Command)segment).elementsInSegment.stream()).filter(element -> element instanceof ObjectFile.Section).map(element -> (ObjectFile.Section)element).iterator();
        }
    }
}

