/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.DebugInfoBase;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.MemberEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;

public class MethodEntry
extends MemberEntry {
    private final TypeEntry[] paramTypes;
    private final String[] paramNames;
    static final int DEOPT = 1;
    static final int IN_RANGE = 2;
    static final int INLINED = 4;
    int flags;
    final String symbolName;

    public MethodEntry(DebugInfoBase debugInfoBase, DebugInfoProvider.DebugMethodInfo debugMethodInfo, FileEntry fileEntry, String methodName, ClassEntry ownerType, TypeEntry valueType, TypeEntry[] paramTypes, String[] paramNames) {
        super(fileEntry, methodName, ownerType, valueType, debugMethodInfo.modifiers());
        assert (paramTypes == null && paramNames == null || paramTypes != null && paramNames != null && paramTypes.length == paramNames.length);
        this.paramTypes = paramTypes;
        this.paramNames = paramNames;
        this.symbolName = debugMethodInfo.symbolNameForMethod();
        this.flags = 0;
        if (debugMethodInfo.isDeoptTarget()) {
            this.setIsDeopt();
        }
        this.updateRangeInfo(debugInfoBase, debugMethodInfo);
    }

    public String methodName() {
        return this.memberName;
    }

    @Override
    public ClassEntry ownerType() {
        assert (this.ownerType instanceof ClassEntry);
        return (ClassEntry)this.ownerType;
    }

    public int getParamCount() {
        return this.paramTypes == null ? 0 : this.paramTypes.length;
    }

    public TypeEntry getParamType(int idx) {
        assert (this.paramTypes != null);
        assert (idx < this.paramTypes.length);
        return this.paramTypes[idx];
    }

    public TypeEntry[] getParamTypes() {
        return this.paramTypes;
    }

    public String getParamTypeName(int idx) {
        assert (this.paramTypes != null);
        assert (idx < this.paramTypes.length);
        assert (this.paramTypes[idx] != null);
        return this.paramTypes[idx].getTypeName();
    }

    public String getParamName(int idx) {
        assert (this.paramNames != null);
        assert (idx < this.paramNames.length);
        return this.paramNames[idx];
    }

    private void setIsDeopt() {
        this.flags |= 1;
    }

    public boolean isDeopt() {
        return (this.flags & 1) != 0;
    }

    private void setIsInRange() {
        this.flags |= 2;
    }

    public boolean isInRange() {
        return (this.flags & 2) != 0;
    }

    private void setIsInlined() {
        this.flags |= 4;
    }

    public boolean isInlined() {
        return (this.flags & 4) != 0;
    }

    public void updateRangeInfo(DebugInfoBase debugInfoBase, DebugInfoProvider.DebugMethodInfo debugMethodInfo) {
        if (debugMethodInfo instanceof DebugInfoProvider.DebugLineInfo) {
            DebugInfoProvider.DebugLineInfo lineInfo = (DebugInfoProvider.DebugLineInfo)debugMethodInfo;
            if (lineInfo.getCaller() != null) {
                this.setIsInlined();
            }
        } else if (debugMethodInfo instanceof DebugInfoProvider.DebugCodeInfo) {
            if (this.isInRange()) {
                assert (this.fileEntry == debugInfoBase.ensureFileEntry(debugMethodInfo));
            } else {
                this.setIsInRange();
                this.fileEntry = debugInfoBase.ensureFileEntry(debugMethodInfo);
            }
        }
    }

    public String getSymbolName() {
        return this.symbolName;
    }
}

