/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.DirEntry;
import java.nio.file.Path;

public class FileEntry {
    private String fileName;
    private DirEntry dirEntry;
    private Path cachePath;

    public FileEntry(String fileName, DirEntry dirEntry, Path cachePath) {
        this.fileName = fileName;
        this.dirEntry = dirEntry;
        this.cachePath = cachePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPathName() {
        DirEntry dirEntry = this.getDirEntry();
        if (dirEntry == null) {
            return "";
        }
        return dirEntry.getPathString();
    }

    public String getFullName() {
        if (this.dirEntry == null) {
            return this.fileName;
        }
        return this.dirEntry.getPath().resolve(this.getFileName()).toString();
    }

    public DirEntry getDirEntry() {
        return this.dirEntry;
    }

    public Path getCachePath() {
        return this.cachePath;
    }

    public String toString() {
        if (this.getDirEntry() == null) {
            return this.getFileName() == null ? "-" : this.getFileName();
        }
        if (this.getFileName() == null) {
            return "--";
        }
        return String.format("FileEntry(%s)", this.getFullName());
    }
}

