/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.intl.GetOptionsObjectNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.TemporalMonthDayFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarSlotValueNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarHolder;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDay;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDayObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonth;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.List;

public abstract class ToTemporalMonthDayNode
extends JavaScriptBaseNode {
    @Node.Child
    private PropertyGetNode getCalendarNode;

    protected ToTemporalMonthDayNode() {
    }

    public abstract JSTemporalPlainMonthDayObject execute(Object var1, Object var2);

    @Specialization
    public JSTemporalPlainMonthDayObject toTemporalMonthDay(Object item, Object options, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile returnPlainMonthDay, @Cached InlinedConditionProfile getCalendarPath, @Cached IsObjectNode isObjectNode, @Cached(value="create(getJSContext())") GetOptionsObjectNode getOptionsObject, @Cached(value="createWithISO8601()") ToTemporalCalendarSlotValueNode toCalendarSlotValue, @Cached TemporalGetOptionNode temporalGetOptionNode, @Cached TemporalMonthDayFromFieldsNode monthDayFromFieldsNode) {
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        if (isObjectProfile.profile((Node)this, isObjectNode.executeBoolean(item))) {
            TruffleString calendar;
            JSDynamicObject itemObj = (JSDynamicObject)((Object)item);
            if (JSTemporalPlainMonthDay.isJSTemporalPlainMonthDay((Object)itemObj)) {
                Object resolvedOptions = getOptionsObject.execute(options);
                TemporalUtil.getTemporalOverflowOption(resolvedOptions, temporalGetOptionNode);
                JSTemporalPlainMonthDayObject pmd = (JSTemporalPlainMonthDayObject)itemObj;
                return JSTemporalPlainMonthDay.create(ctx, realm, pmd.getMonth(), pmd.getDay(), pmd.getCalendar(), pmd.getYear(), this, errorBranch);
            }
            if (getCalendarPath.profile((Node)this, JSTemporalPlainDate.isJSTemporalPlainDate((Object)itemObj) || JSTemporalPlainDateTime.isJSTemporalPlainDateTime((Object)itemObj) || JSTemporalPlainTime.isJSTemporalPlainTime((Object)itemObj) || JSTemporalPlainYearMonth.isJSTemporalPlainYearMonth((Object)itemObj) || TemporalUtil.isTemporalZonedDateTime((Object)itemObj))) {
                calendar = ((JSTemporalCalendarHolder)itemObj).getCalendar();
            } else {
                Object calendarLike = this.getCalendar(itemObj);
                calendar = toCalendarSlotValue.execute(calendarLike);
            }
            List<TruffleString> fieldNames = TemporalUtil.listDMMCY;
            JSObject fields = TemporalUtil.prepareTemporalFields(ctx, (Object)itemObj, fieldNames, TemporalUtil.listEmpty);
            Object resolvedOptions = getOptionsObject.execute(options);
            TemporalUtil.Overflow overflow = TemporalUtil.getTemporalOverflowOption(resolvedOptions, temporalGetOptionNode);
            return monthDayFromFieldsNode.execute(calendar, fields, overflow);
        }
        if (item instanceof TruffleString) {
            TruffleString string = (TruffleString)item;
            JSTemporalDateTimeRecord result = TemporalUtil.parseTemporalMonthDayString(string);
            TruffleString calendar = result.getCalendar();
            if (calendar == null) {
                calendar = TemporalConstants.ISO8601;
            }
            if (!TemporalUtil.isBuiltinCalendar(calendar)) {
                throw Errors.createRangeError("built-in calendar expected");
            }
            Object resolvedOptions = getOptionsObject.execute(options);
            TemporalUtil.Overflow overflow = TemporalUtil.getTemporalOverflowOption(resolvedOptions, temporalGetOptionNode);
            if (returnPlainMonthDay.profile((Node)this, result.getYear() == Integer.MIN_VALUE)) {
                int referenceISOYear = 1972;
                return JSTemporalPlainMonthDay.create(ctx, realm, result.getMonth(), result.getDay(), calendar, referenceISOYear, this, errorBranch);
            }
            JSTemporalPlainMonthDayObject result2 = JSTemporalPlainMonthDay.create(ctx, realm, result.getMonth(), result.getDay(), calendar, result.getYear(), this, errorBranch);
            return monthDayFromFieldsNode.execute(calendar, result2, overflow);
        }
        errorBranch.enter((Node)this);
        throw Errors.createTypeErrorNotAString(item);
    }

    private Object getCalendar(JSDynamicObject obj) {
        if (this.getCalendarNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getCalendarNode = (PropertyGetNode)this.insert(PropertyGetNode.create(TemporalConstants.CALENDAR, this.getLanguage().getJSContext()));
        }
        return this.getCalendarNode.getValue((Object)obj);
    }
}

