/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class JSInteropUtil {
    private JSInteropUtil() {
    }

    public static long getArraySize(Object foreignObj, InteropLibrary interop, Node originatingNode) {
        try {
            return interop.getArraySize(foreignObj);
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorInteropException(foreignObj, (InteropException)((Object)e), "getArraySize", originatingNode);
        }
    }

    public static boolean setArraySize(Object obj, Object value, boolean isStrict, InteropLibrary interop, Node originatingNode, BranchProfile errorBranch) {
        long oldLen;
        long newLen = JSAbstractArray.toArrayLengthOrRangeError(value, originatingNode);
        try {
            oldLen = interop.getArraySize(obj);
        }
        catch (UnsupportedMessageException e) {
            if (errorBranch != null) {
                errorBranch.enter();
            }
            throw Errors.createTypeErrorInteropException(obj, (InteropException)((Object)e), "getArraySize", originatingNode);
        }
        String message = null;
        try {
            if (newLen < oldLen) {
                message = "removeArrayElement";
                for (long idx = oldLen - 1L; idx >= newLen; --idx) {
                    interop.removeArrayElement(obj, idx);
                }
            } else {
                message = "writeArrayElement";
                for (long idx = oldLen; idx < newLen; ++idx) {
                    interop.writeArrayElement(obj, idx, (Object)Undefined.instance);
                }
            }
        }
        catch (InteropException e) {
            if (isStrict) {
                if (errorBranch != null) {
                    errorBranch.enter();
                }
                throw Errors.createTypeErrorInteropException(obj, e, message, originatingNode);
            }
            return false;
        }
        return true;
    }

    public static Object readMemberOrDefault(Object obj, Object member, Object defaultValue) {
        return JSInteropUtil.readMemberOrDefault(obj, member, defaultValue, InteropLibrary.getUncached(), ImportValueNode.getUncached(), null);
    }

    public static Object readMemberOrDefault(Object obj, Object member, Object defaultValue, InteropLibrary interop, ImportValueNode importValue, Node originatingNode) {
        if (!Strings.isTString(member)) {
            return defaultValue;
        }
        try {
            return importValue.executeWithTarget(interop.readMember(obj, Strings.toJavaString((TruffleString)member)));
        }
        catch (UnknownIdentifierException e) {
            return defaultValue;
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorInteropException(obj, (InteropException)((Object)e), "readMember", member, originatingNode);
        }
    }

    public static Object readArrayElementOrDefault(Object obj, long index, Object defaultValue, InteropLibrary interop, ImportValueNode importValue, Node originatingNode) {
        try {
            return importValue.executeWithTarget(interop.readArrayElement(obj, index));
        }
        catch (InvalidArrayIndexException e) {
            return defaultValue;
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorInteropException(obj, (InteropException)((Object)e), "readArrayElement", index, originatingNode);
        }
    }

    public static Object readArrayElementOrDefault(Object obj, long index, Object defaultValue) {
        return JSInteropUtil.readArrayElementOrDefault(obj, index, defaultValue, InteropLibrary.getUncached(), ImportValueNode.getUncached(), null);
    }

    public static void writeMember(Object obj, Object member, Object value) {
        JSInteropUtil.writeMember(obj, member, value, InteropLibrary.getUncached(), ExportValueNode.getUncached(), null);
    }

    public static void writeMember(Object obj, Object member, Object value, InteropLibrary interop, ExportValueNode exportValue, Node originatingNode) {
        if (!Strings.isTString(member)) {
            return;
        }
        try {
            interop.writeMember(obj, Strings.toJavaString((TruffleString)member), exportValue.execute(value));
        }
        catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw Errors.createTypeErrorInteropException(obj, (InteropException)e, "writeMember", member, originatingNode);
        }
    }

    @HostCompilerDirectives.InliningCutoff
    public static Object toPrimitiveOrDefaultLossy(Object obj, Object defaultValue, InteropLibrary interop, Node originatingNode) {
        if (interop.isNull(obj)) {
            return Null.instance;
        }
        try {
            if (interop.isBoolean(obj)) {
                return interop.asBoolean(obj);
            }
            if (interop.isString(obj)) {
                return Strings.interopAsTruffleString(obj, interop);
            }
            if (interop.isNumber(obj)) {
                if (interop.fitsInInt(obj)) {
                    return interop.asInt(obj);
                }
                if (interop.fitsInDouble(obj)) {
                    return interop.asDouble(obj);
                }
                if (interop.fitsInLong(obj)) {
                    return (double)interop.asLong(obj);
                }
                if (interop.fitsInBigInteger(obj)) {
                    return BigInt.doubleValueOf(interop.asBigInteger(obj));
                }
            }
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorUnboxException(obj, (InteropException)((Object)e), originatingNode);
        }
        return defaultValue;
    }

    @HostCompilerDirectives.InliningCutoff
    public static Object toPrimitiveOrDefaultLossless(Object obj, Object defaultValue, InteropLibrary interop, TruffleString.SwitchEncodingNode switchEncoding, Node originatingNode) {
        if (interop.isNull(obj)) {
            return Null.instance;
        }
        try {
            if (interop.isBoolean(obj)) {
                return interop.asBoolean(obj);
            }
            if (interop.isString(obj)) {
                return Strings.interopAsTruffleString(obj, interop, switchEncoding);
            }
            if (interop.isNumber(obj)) {
                if (interop.fitsInInt(obj)) {
                    return interop.asInt(obj);
                }
                if (interop.fitsInLong(obj)) {
                    return interop.asLong(obj);
                }
                if (interop.fitsInBigInteger(obj)) {
                    return BigInt.fromForeignBigInteger(interop.asBigInteger(obj));
                }
                if (interop.fitsInDouble(obj)) {
                    return interop.asDouble(obj);
                }
            }
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorUnboxException(obj, (InteropException)((Object)e), originatingNode);
        }
        return defaultValue;
    }

    @CompilerDirectives.TruffleBoundary
    public static List<Object> keys(Object obj) {
        try {
            Object keysObj = InteropLibrary.getUncached().getMembers(obj);
            InteropLibrary keysInterop = InteropLibrary.getUncached((Object)keysObj);
            long size = keysInterop.getArraySize(keysObj);
            if (size < 0L || size >= Integer.MAX_VALUE) {
                throw Errors.createRangeErrorInvalidArrayLength();
            }
            ArrayList<Object> keys = new ArrayList<Object>((int)size);
            int i = 0;
            while ((long)i < size) {
                Object key = keysInterop.readArrayElement(keysObj, (long)i);
                keys.add(Strings.interopAsTruffleString(key));
                ++i;
            }
            return keys;
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException e) {
            throw Errors.createTypeErrorInteropException(obj, (InteropException)e, "readArrayElement", null);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean hasProperty(Object obj, Object key) {
        if (key instanceof TruffleString) {
            return InteropLibrary.getUncached().isMemberExisting(obj, Strings.toJavaString((TruffleString)key));
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean remove(Object obj, Object key) {
        if (key instanceof TruffleString) {
            try {
                InteropLibrary.getUncached().removeMember(obj, Strings.toJavaString((TruffleString)key));
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(obj, (InteropException)e, "removeMember", key, null);
            }
            return true;
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object call(Object function, Object[] args) {
        Object[] exportedArgs = JSRuntime.exportValueArray(args);
        try {
            return JSRuntime.importValue(InteropLibrary.getUncached().execute(function, exportedArgs));
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw Errors.createTypeErrorInteropException(function, (InteropException)e, "execute", null);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static Object construct(Object target, Object[] args) {
        Object[] exportedArgs = JSRuntime.exportValueArray(args);
        try {
            return JSRuntime.importValue(InteropLibrary.getUncached().instantiate(target, exportedArgs));
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw Errors.createTypeErrorInteropException(target, (InteropException)e, "instantiate", null);
        }
    }

    public static boolean isBoxedPrimitive(Object receiver, InteropLibrary interop) {
        return interop.isString(receiver) || interop.isNumber(receiver) || interop.isBoolean(receiver);
    }

    public static PropertyDescriptor getOwnProperty(Object object, TruffleString propertyKey) {
        return JSInteropUtil.getOwnProperty(object, propertyKey, InteropLibrary.getUncached(), ImportValueNode.getUncached(), TruffleString.ReadCharUTF16Node.getUncached());
    }

    @HostCompilerDirectives.InliningCutoff
    public static PropertyDescriptor getOwnProperty(Object object, TruffleString propertyKey, InteropLibrary interop, ImportValueNode importValueNode, TruffleString.ReadCharUTF16Node charAtNode) {
        try {
            PropertyDescriptor desc;
            String key = Strings.toJavaString(propertyKey);
            if (interop.hasMembers(object) && interop.isMemberExisting(object, key) && (desc = JSInteropUtil.getExistingMemberProperty(object, key, interop, importValueNode)) != null) {
                return desc;
            }
            long index = JSRuntime.propertyNameToArrayIndex(propertyKey, charAtNode);
            if (JSRuntime.isArrayIndex(index) && interop.hasArrayElements(object)) {
                return JSInteropUtil.getArrayElementProperty(object, index, interop, importValueNode);
            }
        }
        catch (InteropException interopException) {
            // empty catch block
        }
        return null;
    }

    @HostCompilerDirectives.InliningCutoff
    public static PropertyDescriptor getExistingMemberProperty(Object object, String key, InteropLibrary interop, ImportValueNode importValueNode) throws InteropException {
        assert (interop.hasMembers(object) && interop.isMemberExisting(object, key));
        if (interop.isMemberReadable(object, key)) {
            return PropertyDescriptor.createData(importValueNode.executeWithTarget(interop.readMember(object, key)), !interop.isMemberInternal(object, key), interop.isMemberWritable(object, key), interop.isMemberRemovable(object, key));
        }
        return null;
    }

    @HostCompilerDirectives.InliningCutoff
    public static PropertyDescriptor getArrayElementProperty(Object object, long index, InteropLibrary interop, ImportValueNode importValueNode) throws InteropException {
        assert (interop.hasArrayElements(object) && JSRuntime.isArrayIndex(index));
        if (interop.isArrayElementExisting(object, index) && interop.isArrayElementReadable(object, index)) {
            return PropertyDescriptor.createData(importValueNode.executeWithTarget(interop.readArrayElement(object, index)), true, interop.isArrayElementWritable(object, index), interop.isArrayElementRemovable(object, index));
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static String formatError(Object error, InteropLibrary interopExc, InteropLibrary interopStr) {
        block12: {
            if (interopExc.isException(error)) {
                try {
                    String message = null;
                    if (interopExc.hasExceptionMessage(error)) {
                        message = interopStr.asString(interopExc.getExceptionMessage(error));
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(Objects.requireNonNullElse(message, "Error"));
                    if (interopExc.hasExceptionStackTrace(error)) {
                        Object stackTrace = interopExc.getExceptionStackTrace(error);
                        InteropLibrary interopST = InteropLibrary.getUncached((Object)stackTrace);
                        long length = interopST.getArraySize(stackTrace);
                        for (long i = 0L; i < length; ++i) {
                            Object stackTraceElement = interopST.readArrayElement(stackTrace, i);
                            InteropLibrary interopSTE = InteropLibrary.getUncached((Object)stackTraceElement);
                            String name = "";
                            SourceSection sourceLocation = null;
                            if (interopSTE.hasExecutableName(stackTraceElement)) {
                                name = interopStr.asString(interopSTE.getExecutableName(stackTraceElement));
                            }
                            if (interopSTE.hasSourceLocation(stackTraceElement)) {
                                sourceLocation = interopSTE.getSourceLocation(stackTraceElement);
                            }
                            String className = "";
                            if (interopSTE.hasDeclaringMetaObject(stackTraceElement)) {
                                Object metaObject = interopSTE.getDeclaringMetaObject(stackTraceElement);
                                className = interopStr.asString(InteropLibrary.getUncached((Object)metaObject).getMetaQualifiedName(metaObject));
                            }
                            if (name.isEmpty() && sourceLocation == null) continue;
                            sb.append('\n');
                            sb.append("    at ");
                            if (!className.isEmpty()) {
                                sb.append(className).append('.');
                            }
                            if (!name.isEmpty()) {
                                sb.append(name);
                            } else {
                                sb.append(JSError.ANONYMOUS_FUNCTION_NAME);
                            }
                            if (sourceLocation == null) continue;
                            sb.append(" (").append(JSInteropUtil.formatSourceLocation(sourceLocation)).append(")");
                        }
                    }
                    return sb.toString();
                }
                catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                    if ($assertionsDisabled) break block12;
                    throw new AssertionError((Object)e);
                }
            }
        }
        return JSRuntime.safeToString(error).toString();
    }

    private static String formatSourceLocation(SourceSection sourceSection) {
        if (sourceSection == null) {
            return "Unknown";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sourceSection.getSource().getName());
        sb.append(":");
        sb.append(sourceSection.getStartLine());
        if (sourceSection.getStartLine() < sourceSection.getEndLine()) {
            sb.append("-").append(sourceSection.getEndLine());
        }
        sb.append(":");
        sb.append(sourceSection.getCharIndex());
        if (sourceSection.getCharLength() > 1) {
            sb.append("-").append(sourceSection.getCharEndIndex() - 1);
        }
        return sb.toString();
    }

    public static ByteBuffer wasmMemoryAsByteBuffer(JSArrayBufferObject interopArrayBuffer, InteropLibrary interop, JSRealm realm) {
        assert (JSArrayBuffer.isJSInteropArrayBuffer((Object)interopArrayBuffer));
        Object memAsByteBuffer = realm.getWASMMemAsByteBuffer();
        if (memAsByteBuffer == null) {
            return null;
        }
        try {
            Object buffer;
            Object interopBuffer = JSArrayBuffer.getInteropBuffer((Object)interopArrayBuffer);
            if (interopBuffer == null) {
                assert (JSArrayBuffer.isDetachedBuffer(interopArrayBuffer));
                return null;
            }
            Object bufferObject = interop.execute(memAsByteBuffer, new Object[]{interopBuffer});
            TruffleLanguage.Env env = realm.getEnv();
            if (env.isHostObject(bufferObject) && (buffer = env.asHostObject(bufferObject)) instanceof ByteBuffer) {
                return (ByteBuffer)buffer;
            }
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
        return null;
    }
}

