/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.temporal.TemporalPlainYearMonthFunctionBuiltins;
import com.oracle.truffle.js.builtins.temporal.TemporalPlainYearMonthPrototypeBuiltins;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonthObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public final class JSTemporalPlainYearMonth
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final JSTemporalPlainYearMonth INSTANCE = new JSTemporalPlainYearMonth();
    public static final TruffleString CLASS_NAME = Strings.constant("PlainYearMonth");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("PlainYearMonth.prototype");
    public static final TruffleString TO_STRING_TAG = Strings.constant("Temporal.PlainYearMonth");

    private JSTemporalPlainYearMonth() {
    }

    public static JSTemporalPlainYearMonthObject create(JSContext context, JSRealm realm, int isoYear, int isoMonth, JSDynamicObject calendar, int referenceISODay, Node node, InlinedBranchProfile errorBranch) {
        return JSTemporalPlainYearMonth.create(context, realm, INSTANCE.getIntrinsicDefaultProto(realm), isoYear, isoMonth, calendar, referenceISODay, node, errorBranch);
    }

    public static JSTemporalPlainYearMonthObject create(JSContext context, JSRealm realm, JSDynamicObject proto, int isoYear, int isoMonth, JSDynamicObject calendar, int referenceISODay, Node node, InlinedBranchProfile errorBranch) {
        if (!TemporalUtil.validateISODate(isoYear, isoMonth, referenceISODay)) {
            errorBranch.enter(node);
            throw TemporalErrors.createRangeErrorDateOutsideRange();
        }
        if (!TemporalUtil.isoYearMonthWithinLimits(isoYear, isoMonth)) {
            errorBranch.enter(node);
            throw TemporalErrors.createRangeErrorYearMonthOutsideRange();
        }
        return JSTemporalPlainYearMonth.createIntl(context, realm, proto, isoYear, isoMonth, calendar, referenceISODay);
    }

    private static JSTemporalPlainYearMonthObject createIntl(JSContext context, JSRealm realm, JSDynamicObject proto, int isoYear, int isoMonth, JSDynamicObject calendar, int referenceISODay) {
        JSObjectFactory factory = context.getTemporalPlainYearMonthFactory();
        Shape shape = factory.getShape(realm, proto);
        JSTemporalPlainYearMonthObject newObj = factory.initProto(new JSTemporalPlainYearMonthObject(shape, proto, isoYear, isoMonth, referenceISODay, calendar), realm, proto);
        return factory.trackAllocation(newObj);
    }

    @Override
    public TruffleString getClassName(JSDynamicObject object) {
        return TO_STRING_TAG;
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject constructor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(prototype, constructor);
        JSObjectUtil.putAccessorsFromContainer(realm, prototype, TemporalPlainYearMonthPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, TemporalPlainYearMonthPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, TO_STRING_TAG);
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getTemporalPlainYearMonthPrototype();
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, TemporalPlainYearMonthFunctionBuiltins.BUILTINS);
    }

    public static boolean isJSTemporalPlainYearMonth(Object obj) {
        return obj instanceof JSTemporalPlainYearMonthObject;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString temporalYearMonthToString(JSTemporalPlainYearMonthObject ym, TemporalUtil.ShowCalendar showCalendar) {
        TruffleString calendarString;
        TruffleString year = TemporalUtil.padISOYear(ym.getYear());
        TruffleString month = TemporalUtil.toZeroPaddedDecimalString(ym.getMonth(), 2);
        TruffleString result = Strings.concatAll(year, Strings.DASH, month);
        TruffleString calendarID = JSRuntime.toString(ym.getCalendar());
        if (showCalendar == TemporalUtil.ShowCalendar.ALWAYS || !TemporalConstants.ISO8601.equals((Object)calendarID)) {
            TruffleString day = TemporalUtil.toZeroPaddedDecimalString(ym.getDay(), 2);
            result = Strings.concatAll(result, Strings.DASH, day);
        }
        if (!(calendarString = TemporalUtil.formatCalendarAnnotation(calendarID, showCalendar)).isEmpty()) {
            result = Strings.concat(result, calendarString);
        }
        return result;
    }
}

