// CheckStyle: start generated
package com.oracle.truffle.js.nodes.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.strings.TruffleString.SwitchEncodingNode;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.runtime.JSConfig;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link ToJSValueNode#i32}
 *     Activation probability: 0.32000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link ToJSValueNode#i64}
 *     Activation probability: 0.26000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link ToJSValueNode#f32}
 *     Activation probability: 0.20000
 *     With/without class size: 6/0 bytes
 *   Specialization {@link ToJSValueNode#f64}
 *     Activation probability: 0.14000
 *     With/without class size: 5/0 bytes
 *   Specialization {@link ToJSValueNode#convert}
 *     Activation probability: 0.08000
 *     With/without class size: 6/16 bytes
 * </pre>
 */
@GeneratedBy(ToJSValueNode.class)
@SuppressWarnings("javadoc")
public final class ToJSValueNodeGen extends ToJSValueNode implements Introspection.Provider {

    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link ToJSValueNode#i32}
     *   1: SpecializationActive {@link ToJSValueNode#i64}
     *   2: SpecializationActive {@link ToJSValueNode#f32}
     *   3: SpecializationActive {@link ToJSValueNode#f64}
     *   4: SpecializationActive {@link ToJSValueNode#convert}
     *   5-7: ImplicitCast[type=double, index=0]
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private FallbackData fallback_cache;

    private ToJSValueNodeGen() {
    }

    @SuppressWarnings("static-method")
    private boolean fallbackGuard_(int state_0, Object arg0Value) {
        if (!((state_0 & 0b10) != 0 /* is SpecializationActive[ToJSValueNode.i64(long)] */) && arg0Value instanceof Long) {
            return false;
        }
        if (!((state_0 & 0b100) != 0 /* is SpecializationActive[ToJSValueNode.f32(float)] */) && arg0Value instanceof Float) {
            return false;
        }
        if (JSTypesGen.isImplicitDouble(arg0Value)) {
            return false;
        }
        return true;
    }

    @Override
    public Object execute(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11111) != 0 /* is SpecializationActive[ToJSValueNode.i32(int)] || SpecializationActive[ToJSValueNode.i64(long)] || SpecializationActive[ToJSValueNode.f32(float)] || SpecializationActive[ToJSValueNode.f64(double)] || SpecializationActive[ToJSValueNode.convert(Object, InteropLibrary, InteropLibrary, InteropLibrary, SwitchEncodingNode)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[ToJSValueNode.i32(int)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return ToJSValueNode.i32(arg0Value_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToJSValueNode.i64(long)] */ && arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return ToJSValueNode.i64(arg0Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToJSValueNode.f32(float)] */ && arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return ToJSValueNode.f32(arg0Value_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToJSValueNode.f64(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arg0Value);
                return ToJSValueNode.f64(arg0Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToJSValueNode.convert(Object, InteropLibrary, InteropLibrary, InteropLibrary, SwitchEncodingNode)] */) {
                FallbackData s4_ = this.fallback_cache;
                if (s4_ != null) {
                    if (fallbackGuard_(state_0, arg0Value)) {
                        return convert(arg0Value, s4_.isFuncLib_, s4_.funcTypeLib_, s4_.asTStringLib_, s4_.switchEncoding_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    private Object executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (int) arg0Value;
            state_0 = state_0 | 0b1 /* add SpecializationActive[ToJSValueNode.i32(int)] */;
            this.state_0_ = state_0;
            return ToJSValueNode.i32(arg0Value_);
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (long) arg0Value;
            state_0 = state_0 | 0b10 /* add SpecializationActive[ToJSValueNode.i64(long)] */;
            this.state_0_ = state_0;
            return ToJSValueNode.i64(arg0Value_);
        }
        if (arg0Value instanceof Float) {
            float arg0Value_ = (float) arg0Value;
            state_0 = state_0 | 0b100 /* add SpecializationActive[ToJSValueNode.f32(float)] */;
            this.state_0_ = state_0;
            return ToJSValueNode.f32(arg0Value_);
        }
        {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                state_0 = (state_0 | (doubleCast0 << 5) /* set-int ImplicitCast[type=double, index=0] */);
                state_0 = state_0 | 0b1000 /* add SpecializationActive[ToJSValueNode.f64(double)] */;
                this.state_0_ = state_0;
                return ToJSValueNode.f64(arg0Value_);
            }
        }
        FallbackData s4_ = this.insert(new FallbackData());
        InteropLibrary isFuncLib__ = s4_.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
        Objects.requireNonNull(isFuncLib__, "Specialization 'convert(Object, InteropLibrary, InteropLibrary, InteropLibrary, SwitchEncodingNode)' cache 'isFuncLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        s4_.isFuncLib_ = isFuncLib__;
        InteropLibrary funcTypeLib__ = s4_.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
        Objects.requireNonNull(funcTypeLib__, "Specialization 'convert(Object, InteropLibrary, InteropLibrary, InteropLibrary, SwitchEncodingNode)' cache 'funcTypeLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        s4_.funcTypeLib_ = funcTypeLib__;
        InteropLibrary asTStringLib__ = s4_.insert((INTEROP_LIBRARY_.createDispatched(JSConfig.InteropLibraryLimit)));
        Objects.requireNonNull(asTStringLib__, "Specialization 'convert(Object, InteropLibrary, InteropLibrary, InteropLibrary, SwitchEncodingNode)' cache 'asTStringLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        s4_.asTStringLib_ = asTStringLib__;
        SwitchEncodingNode switchEncoding__ = s4_.insert((SwitchEncodingNode.create()));
        Objects.requireNonNull(switchEncoding__, "Specialization 'convert(Object, InteropLibrary, InteropLibrary, InteropLibrary, SwitchEncodingNode)' cache 'switchEncoding' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        s4_.switchEncoding_ = switchEncoding__;
        VarHandle.storeStoreFence();
        this.fallback_cache = s4_;
        state_0 = state_0 | 0b10000 /* add SpecializationActive[ToJSValueNode.convert(Object, InteropLibrary, InteropLibrary, InteropLibrary, SwitchEncodingNode)] */;
        this.state_0_ = state_0;
        return convert(arg0Value, isFuncLib__, funcTypeLib__, asTStringLib__, switchEncoding__);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11111) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b11111) & ((state_0 & 0b11111) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[6];
        Object[] s;
        data[0] = 0;
        int state_0 = this.state_0_;
        s = new Object[3];
        s[0] = "i32";
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[ToJSValueNode.i32(int)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "i64";
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToJSValueNode.i64(long)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "f32";
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[ToJSValueNode.f32(float)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "f64";
        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToJSValueNode.f64(double)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "convert";
        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToJSValueNode.convert(Object, InteropLibrary, InteropLibrary, InteropLibrary, SwitchEncodingNode)] */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            FallbackData s4_ = this.fallback_cache;
            if (s4_ != null) {
                cached.add(Arrays.<Object>asList(s4_.isFuncLib_, s4_.funcTypeLib_, s4_.asTStringLib_, s4_.switchEncoding_));
            }
            s[2] = cached;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[5] = s;
        return Provider.create(data);
    }

    @NeverDefault
    public static ToJSValueNode create() {
        return new ToJSValueNodeGen();
    }

    @NeverDefault
    public static ToJSValueNode getUncached() {
        return ToJSValueNodeGen.UNCACHED;
    }

    @GeneratedBy(ToJSValueNode.class)
    @DenyReplace
    private static final class FallbackData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link ToJSValueNode#convert}
         *   Parameter: {@link InteropLibrary} isFuncLib</pre>
         */
        @Child InteropLibrary isFuncLib_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToJSValueNode#convert}
         *   Parameter: {@link InteropLibrary} funcTypeLib</pre>
         */
        @Child InteropLibrary funcTypeLib_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToJSValueNode#convert}
         *   Parameter: {@link InteropLibrary} asTStringLib</pre>
         */
        @Child InteropLibrary asTStringLib_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToJSValueNode#convert}
         *   Parameter: {@link SwitchEncodingNode} switchEncoding</pre>
         */
        @Child SwitchEncodingNode switchEncoding_;

        FallbackData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(ToJSValueNode.class)
    @DenyReplace
    private static final class Uncached extends ToJSValueNode {

        @TruffleBoundary
        @Override
        public Object execute(Object arg0Value) {
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                return ToJSValueNode.i32(arg0Value_);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (long) arg0Value;
                return ToJSValueNode.i64(arg0Value_);
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = (float) arg0Value;
                return ToJSValueNode.f32(arg0Value_);
            }
            if (JSTypesGen.isImplicitDouble(arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(arg0Value);
                return ToJSValueNode.f64(arg0Value_);
            }
            return convert(arg0Value, (INTEROP_LIBRARY_.getUncached()), (INTEROP_LIBRARY_.getUncached()), (INTEROP_LIBRARY_.getUncached()), (SwitchEncodingNode.getUncached()));
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
