// CheckStyle: start generated
package com.oracle.truffle.js.nodes.promise;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;

/**
 * Debug Info: <pre>
 *   Specialization {@link UnwrapPromiseNode#fulfilled}
 *     Activation probability: 0.48333
 *     With/without class size: 9/0 bytes
 *   Specialization {@link UnwrapPromiseNode#rejected}
 *     Activation probability: 0.33333
 *     With/without class size: 8/0 bytes
 *   Specialization {@link UnwrapPromiseNode#pending}
 *     Activation probability: 0.18333
 *     With/without class size: 6/0 bytes
 * </pre>
 */
@GeneratedBy(UnwrapPromiseNode.class)
@SuppressWarnings("javadoc")
public final class UnwrapPromiseNodeGen extends UnwrapPromiseNode implements Introspection.Provider {

    private static final Uncached UNCACHED = new Uncached();

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link UnwrapPromiseNode#fulfilled}
     *   1: SpecializationActive {@link UnwrapPromiseNode#rejected}
     *   2: SpecializationActive {@link UnwrapPromiseNode#pending}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private UnwrapPromiseNodeGen() {
    }

    @Override
    protected Object execute(JSPromiseObject arg0Value, int arg1Value, Object arg2Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0 /* is SpecializationActive[UnwrapPromiseNode.fulfilled(JSPromiseObject, int, Object)] || SpecializationActive[UnwrapPromiseNode.rejected(JSPromiseObject, int, Object)] || SpecializationActive[UnwrapPromiseNode.pending(JSPromiseObject, int, Object)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[UnwrapPromiseNode.fulfilled(JSPromiseObject, int, Object)] */) {
                if ((arg1Value == JSPromise.FULFILLED)) {
                    return UnwrapPromiseNode.fulfilled(arg0Value, arg1Value, arg2Value);
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[UnwrapPromiseNode.rejected(JSPromiseObject, int, Object)] */) {
                if ((arg1Value == JSPromise.REJECTED)) {
                    return UnwrapPromiseNode.rejected(arg0Value, arg1Value, arg2Value);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[UnwrapPromiseNode.pending(JSPromiseObject, int, Object)] */) {
                if ((arg1Value == JSPromise.PENDING)) {
                    return UnwrapPromiseNode.pending(arg0Value, arg1Value, arg2Value);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private Object executeAndSpecialize(JSPromiseObject arg0Value, int arg1Value, Object arg2Value) {
        int state_0 = this.state_0_;
        if ((arg1Value == JSPromise.FULFILLED)) {
            state_0 = state_0 | 0b1 /* add SpecializationActive[UnwrapPromiseNode.fulfilled(JSPromiseObject, int, Object)] */;
            this.state_0_ = state_0;
            return UnwrapPromiseNode.fulfilled(arg0Value, arg1Value, arg2Value);
        }
        if ((arg1Value == JSPromise.REJECTED)) {
            state_0 = state_0 | 0b10 /* add SpecializationActive[UnwrapPromiseNode.rejected(JSPromiseObject, int, Object)] */;
            this.state_0_ = state_0;
            return UnwrapPromiseNode.rejected(arg0Value, arg1Value, arg2Value);
        }
        if ((arg1Value == JSPromise.PENDING)) {
            state_0 = state_0 | 0b100 /* add SpecializationActive[UnwrapPromiseNode.pending(JSPromiseObject, int, Object)] */;
            this.state_0_ = state_0;
            return UnwrapPromiseNode.pending(arg0Value, arg1Value, arg2Value);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[4];
        Object[] s;
        data[0] = 0;
        int state_0 = this.state_0_;
        s = new Object[3];
        s[0] = "fulfilled";
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[UnwrapPromiseNode.fulfilled(JSPromiseObject, int, Object)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "rejected";
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[UnwrapPromiseNode.rejected(JSPromiseObject, int, Object)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "pending";
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[UnwrapPromiseNode.pending(JSPromiseObject, int, Object)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        return Provider.create(data);
    }

    @NeverDefault
    public static UnwrapPromiseNode create() {
        return new UnwrapPromiseNodeGen();
    }

    @NeverDefault
    public static UnwrapPromiseNode getUncached() {
        return UnwrapPromiseNodeGen.UNCACHED;
    }

    @GeneratedBy(UnwrapPromiseNode.class)
    @DenyReplace
    private static final class Uncached extends UnwrapPromiseNode {

        @TruffleBoundary
        @Override
        protected Object execute(JSPromiseObject arg0Value, int arg1Value, Object arg2Value) {
            if ((arg1Value == JSPromise.FULFILLED)) {
                return UnwrapPromiseNode.fulfilled(arg0Value, arg1Value, arg2Value);
            }
            if ((arg1Value == JSPromise.REJECTED)) {
                return UnwrapPromiseNode.rejected(arg0Value, arg1Value, arg2Value);
            }
            if ((arg1Value == JSPromise.PENDING)) {
                return UnwrapPromiseNode.pending(arg0Value, arg1Value, arg2Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
