// CheckStyle: start generated
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * Debug Info: <pre>
 *   Specialization {@link InternalCallNode#directCall}
 *     Activation probability: 0.65000
 *     With/without class size: 22/8 bytes
 *   Specialization {@link InternalCallNode#indirectCall}
 *     Activation probability: 0.35000
 *     With/without class size: 11/4 bytes
 * </pre>
 */
@GeneratedBy(InternalCallNode.class)
@SuppressWarnings("javadoc")
public final class InternalCallNodeGen extends InternalCallNode implements Introspection.Provider {

    static final ReferenceField<DirectCallData> DIRECT_CALL_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "directCall_cache", DirectCallData.class);

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link InternalCallNode#directCall}
     *   1: SpecializationActive {@link InternalCallNode#indirectCall}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @Child private DirectCallData directCall_cache;
    /**
     * Source Info: <pre>
     *   Specialization: {@link InternalCallNode#indirectCall}
     *   Parameter: {@link IndirectCallNode} indirectCallNode</pre>
     */
    @Child private IndirectCallNode indirectCall_indirectCallNode_;

    private InternalCallNodeGen() {
    }

    @ExplodeLoop
    @Override
    public Object execute(CallTarget arg0Value, Object[] arg1Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0 /* is SpecializationActive[InternalCallNode.directCall(CallTarget, Object[], CallTarget, DirectCallNode)] || SpecializationActive[InternalCallNode.indirectCall(CallTarget, Object[], IndirectCallNode)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[InternalCallNode.directCall(CallTarget, Object[], CallTarget, DirectCallNode)] */) {
                DirectCallData s0_ = this.directCall_cache;
                while (s0_ != null) {
                    if ((arg0Value == s0_.cachedCallTarget_)) {
                        return InternalCallNode.directCall(arg0Value, arg1Value, s0_.cachedCallTarget_, s0_.directCallNode_);
                    }
                    s0_ = s0_.next_;
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[InternalCallNode.indirectCall(CallTarget, Object[], IndirectCallNode)] */) {
                {
                    IndirectCallNode indirectCallNode__ = this.indirectCall_indirectCallNode_;
                    if (indirectCallNode__ != null) {
                        return InternalCallNode.indirectCall(arg0Value, arg1Value, indirectCallNode__);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value);
    }

    private Object executeAndSpecialize(CallTarget arg0Value, Object[] arg1Value) {
        int state_0 = this.state_0_;
        while (true) {
            int count0_ = 0;
            DirectCallData s0_ = DIRECT_CALL_CACHE_UPDATER.getVolatile(this);
            DirectCallData s0_original = s0_;
            while (s0_ != null) {
                if ((arg0Value == s0_.cachedCallTarget_)) {
                    break;
                }
                count0_++;
                s0_ = s0_.next_;
            }
            if (s0_ == null) {
                // assert (arg0Value == s0_.cachedCallTarget_);
                if (count0_ < (InternalCallNode.LIMIT)) {
                    s0_ = this.insert(new DirectCallData(s0_original));
                    s0_.cachedCallTarget_ = (arg0Value);
                    s0_.directCallNode_ = s0_.insert((DirectCallNode.create(s0_.cachedCallTarget_)));
                    if (!DIRECT_CALL_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                        continue;
                    }
                    state_0 = state_0 | 0b1 /* add SpecializationActive[InternalCallNode.directCall(CallTarget, Object[], CallTarget, DirectCallNode)] */;
                    this.state_0_ = state_0;
                }
            }
            if (s0_ != null) {
                return InternalCallNode.directCall(arg0Value, arg1Value, s0_.cachedCallTarget_, s0_.directCallNode_);
            }
            break;
        }
        VarHandle.storeStoreFence();
        this.indirectCall_indirectCallNode_ = this.insert((IndirectCallNode.create()));
        state_0 = state_0 | 0b10 /* add SpecializationActive[InternalCallNode.indirectCall(CallTarget, Object[], IndirectCallNode)] */;
        this.state_0_ = state_0;
        return InternalCallNode.indirectCall(arg0Value, arg1Value, this.indirectCall_indirectCallNode_);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                DirectCallData s0_ = this.directCall_cache;
                if ((s0_ == null || s0_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[3];
        Object[] s;
        data[0] = 0;
        int state_0 = this.state_0_;
        s = new Object[3];
        s[0] = "directCall";
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[InternalCallNode.directCall(CallTarget, Object[], CallTarget, DirectCallNode)] */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            DirectCallData s0_ = this.directCall_cache;
            while (s0_ != null) {
                cached.add(Arrays.<Object>asList(s0_.cachedCallTarget_, s0_.directCallNode_));
                s0_ = s0_.next_;
            }
            s[2] = cached;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "indirectCall";
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[InternalCallNode.indirectCall(CallTarget, Object[], IndirectCallNode)] */) {
            {
                IndirectCallNode indirectCallNode__ = this.indirectCall_indirectCallNode_;
                if (indirectCallNode__ != null) {
                    s[1] = (byte)0b01 /* active */;
                    ArrayList<Object> cached = new ArrayList<>();
                    cached.add(Arrays.<Object>asList(this.indirectCall_indirectCallNode_));
                    s[2] = cached;
                }
            }
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        return Provider.create(data);
    }

    @NeverDefault
    public static InternalCallNode create() {
        return new InternalCallNodeGen();
    }

    @GeneratedBy(InternalCallNode.class)
    @DenyReplace
    private static final class DirectCallData extends Node implements SpecializationDataNode {

        @Child DirectCallData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link InternalCallNode#directCall}
         *   Parameter: {@link CallTarget} cachedCallTarget</pre>
         */
        @CompilationFinal CallTarget cachedCallTarget_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link InternalCallNode#directCall}
         *   Parameter: {@link DirectCallNode} directCallNode</pre>
         */
        @Child DirectCallNode directCallNode_;

        DirectCallData(DirectCallData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
}
