// CheckStyle: start generated
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link JSToBooleanNode#doBoolean}
 *     Activation probability: 0.14679
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToBooleanNode#doNull}
 *     Activation probability: 0.13526
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToBooleanNode#doUndefined}
 *     Activation probability: 0.12372
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToBooleanNode#doInt}
 *     Activation probability: 0.11218
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToBooleanNode#doLong}
 *     Activation probability: 0.10064
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToBooleanNode#doDouble}
 *     Activation probability: 0.08910
 *     With/without class size: 5/0 bytes
 *   Specialization {@link JSToBooleanNode#doBigInt}
 *     Activation probability: 0.07756
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSToBooleanNode#doString}
 *     Activation probability: 0.06603
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSToBooleanNode#doJSObject}
 *     Activation probability: 0.05449
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSToBooleanNode#doSymbol}
 *     Activation probability: 0.04295
 *     With/without class size: 4/0 bytes
 *   Specialization {@link JSToBooleanNode#doForeignObject}
 *     Activation probability: 0.03141
 *     With/without class size: 4/4 bytes
 *   Specialization {@link JSToBooleanNode#doForeignObject}
 *     Activation probability: 0.01987
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(JSToBooleanNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class JSToBooleanNodeGen extends JSToBooleanNode implements Introspection.Provider {

    static final ReferenceField<ForeignObject0Data> FOREIGN_OBJECT0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "foreignObject0_cache", ForeignObject0Data.class);
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link JSToBooleanNode#doBoolean}
     *   1: SpecializationActive {@link JSToBooleanNode#doNull}
     *   2: SpecializationActive {@link JSToBooleanNode#doUndefined}
     *   3: SpecializationActive {@link JSToBooleanNode#doInt}
     *   4: SpecializationActive {@link JSToBooleanNode#doLong}
     *   5: SpecializationActive {@link JSToBooleanNode#doDouble}
     *   6: SpecializationActive {@link JSToBooleanNode#doBigInt}
     *   7: SpecializationActive {@link JSToBooleanNode#doString}
     *   8: SpecializationActive {@link JSToBooleanNode#doJSObject}
     *   9: SpecializationActive {@link JSToBooleanNode#doSymbol}
     *   10: SpecializationActive {@link JSToBooleanNode#doForeignObject}
     *   11: SpecializationActive {@link JSToBooleanNode#doForeignObject}
     *   12-14: ImplicitCast[type=double, index=1]
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @Child private ForeignObject0Data foreignObject0_cache;

    private JSToBooleanNodeGen() {
    }

    @ExplodeLoop
    @Override
    public boolean executeBoolean(Node arg0Value, Object arg1Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111111111111) != 0 /* is SpecializationActive[JSToBooleanNode.doBoolean(boolean)] || SpecializationActive[JSToBooleanNode.doNull(Object)] || SpecializationActive[JSToBooleanNode.doUndefined(Object)] || SpecializationActive[JSToBooleanNode.doInt(int)] || SpecializationActive[JSToBooleanNode.doLong(long)] || SpecializationActive[JSToBooleanNode.doDouble(double)] || SpecializationActive[JSToBooleanNode.doBigInt(BigInt)] || SpecializationActive[JSToBooleanNode.doString(TruffleString)] || SpecializationActive[JSToBooleanNode.doJSObject(JSObject)] || SpecializationActive[JSToBooleanNode.doSymbol(Symbol)] || SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] || SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSToBooleanNode.doBoolean(boolean)] */ && arg1Value instanceof Boolean) {
                boolean arg1Value_ = (boolean) arg1Value;
                return JSToBooleanNode.doBoolean(arg1Value_);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[JSToBooleanNode.doNull(Object)] || SpecializationActive[JSToBooleanNode.doUndefined(Object)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSToBooleanNode.doNull(Object)] */) {
                    if ((JSGuards.isJSNull(arg1Value))) {
                        return JSToBooleanNode.doNull(arg1Value);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSToBooleanNode.doUndefined(Object)] */) {
                    if ((JSGuards.isUndefined(arg1Value))) {
                        return JSToBooleanNode.doUndefined(arg1Value);
                    }
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSToBooleanNode.doInt(int)] */ && arg1Value instanceof Integer) {
                int arg1Value_ = (int) arg1Value;
                return JSToBooleanNode.doInt(arg1Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSToBooleanNode.doLong(long)] */ && arg1Value instanceof Long) {
                long arg1Value_ = (long) arg1Value;
                return JSToBooleanNode.doLong(arg1Value_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSToBooleanNode.doDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=double, index=1] */, arg1Value)) {
                double arg1Value_ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=double, index=1] */, arg1Value);
                return JSToBooleanNode.doDouble(arg1Value_);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSToBooleanNode.doBigInt(BigInt)] */ && arg1Value instanceof BigInt) {
                BigInt arg1Value_ = (BigInt) arg1Value;
                return JSToBooleanNode.doBigInt(arg1Value_);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[JSToBooleanNode.doString(TruffleString)] */ && arg1Value instanceof TruffleString) {
                TruffleString arg1Value_ = (TruffleString) arg1Value;
                return JSToBooleanNode.doString(arg1Value_);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSToBooleanNode.doJSObject(JSObject)] */ && arg1Value instanceof JSObject) {
                JSObject arg1Value_ = (JSObject) arg1Value;
                return JSToBooleanNode.doJSObject(arg1Value_);
            }
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSToBooleanNode.doSymbol(Symbol)] */ && arg1Value instanceof Symbol) {
                Symbol arg1Value_ = (Symbol) arg1Value;
                return JSToBooleanNode.doSymbol(arg1Value_);
            }
            if ((state_0 & 0b110000000000) != 0 /* is SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] || SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */) {
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */) {
                    ForeignObject0Data s10_ = this.foreignObject0_cache;
                    while (s10_ != null) {
                        if ((s10_.interop_.accepts(arg1Value)) && (JSGuards.isForeignObject(arg1Value))) {
                            return doForeignObject(arg1Value, s10_.interop_);
                        }
                        s10_ = s10_.next_;
                    }
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */) {
                    if ((JSGuards.isForeignObject(arg1Value))) {
                        return this.foreignObject1Boundary(state_0, arg0Value, arg1Value);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private boolean foreignObject1Boundary(int state_0, Node arg0Value, Object arg1Value) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value));
                return doForeignObject(arg1Value, interop__);
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    private boolean executeAndSpecialize(Node arg0Value, Object arg1Value) {
        int state_0 = this.state_0_;
        if (arg1Value instanceof Boolean) {
            boolean arg1Value_ = (boolean) arg1Value;
            state_0 = state_0 | 0b1 /* add SpecializationActive[JSToBooleanNode.doBoolean(boolean)] */;
            this.state_0_ = state_0;
            return JSToBooleanNode.doBoolean(arg1Value_);
        }
        if ((JSGuards.isJSNull(arg1Value))) {
            state_0 = state_0 | 0b10 /* add SpecializationActive[JSToBooleanNode.doNull(Object)] */;
            this.state_0_ = state_0;
            return JSToBooleanNode.doNull(arg1Value);
        }
        if ((JSGuards.isUndefined(arg1Value))) {
            state_0 = state_0 | 0b100 /* add SpecializationActive[JSToBooleanNode.doUndefined(Object)] */;
            this.state_0_ = state_0;
            return JSToBooleanNode.doUndefined(arg1Value);
        }
        if (arg1Value instanceof Integer) {
            int arg1Value_ = (int) arg1Value;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[JSToBooleanNode.doInt(int)] */;
            this.state_0_ = state_0;
            return JSToBooleanNode.doInt(arg1Value_);
        }
        if (arg1Value instanceof Long) {
            long arg1Value_ = (long) arg1Value;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[JSToBooleanNode.doLong(long)] */;
            this.state_0_ = state_0;
            return JSToBooleanNode.doLong(arg1Value_);
        }
        {
            int doubleCast1;
            if ((doubleCast1 = JSTypesGen.specializeImplicitDouble(arg1Value)) != 0) {
                double arg1Value_ = JSTypesGen.asImplicitDouble(doubleCast1, arg1Value);
                state_0 = (state_0 | (doubleCast1 << 12) /* set-int ImplicitCast[type=double, index=1] */);
                state_0 = state_0 | 0b100000 /* add SpecializationActive[JSToBooleanNode.doDouble(double)] */;
                this.state_0_ = state_0;
                return JSToBooleanNode.doDouble(arg1Value_);
            }
        }
        if (arg1Value instanceof BigInt) {
            BigInt arg1Value_ = (BigInt) arg1Value;
            state_0 = state_0 | 0b1000000 /* add SpecializationActive[JSToBooleanNode.doBigInt(BigInt)] */;
            this.state_0_ = state_0;
            return JSToBooleanNode.doBigInt(arg1Value_);
        }
        if (arg1Value instanceof TruffleString) {
            TruffleString arg1Value_ = (TruffleString) arg1Value;
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[JSToBooleanNode.doString(TruffleString)] */;
            this.state_0_ = state_0;
            return JSToBooleanNode.doString(arg1Value_);
        }
        if (arg1Value instanceof JSObject) {
            JSObject arg1Value_ = (JSObject) arg1Value;
            state_0 = state_0 | 0b100000000 /* add SpecializationActive[JSToBooleanNode.doJSObject(JSObject)] */;
            this.state_0_ = state_0;
            return JSToBooleanNode.doJSObject(arg1Value_);
        }
        if (arg1Value instanceof Symbol) {
            Symbol arg1Value_ = (Symbol) arg1Value;
            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[JSToBooleanNode.doSymbol(Symbol)] */;
            this.state_0_ = state_0;
            return JSToBooleanNode.doSymbol(arg1Value_);
        }
        if (((state_0 & 0b100000000000)) == 0 /* is-not SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */) {
            while (true) {
                int count10_ = 0;
                ForeignObject0Data s10_ = FOREIGN_OBJECT0_CACHE_UPDATER.getVolatile(this);
                ForeignObject0Data s10_original = s10_;
                while (s10_ != null) {
                    if ((s10_.interop_.accepts(arg1Value)) && (JSGuards.isForeignObject(arg1Value))) {
                        break;
                    }
                    count10_++;
                    s10_ = s10_.next_;
                }
                if (s10_ == null) {
                    if ((JSGuards.isForeignObject(arg1Value)) && count10_ < (JSConfig.InteropLibraryLimit)) {
                        // assert (s10_.interop_.accepts(arg1Value));
                        s10_ = this.insert(new ForeignObject0Data(s10_original));
                        InteropLibrary interop__ = s10_.insert((INTEROP_LIBRARY_.create(arg1Value)));
                        Objects.requireNonNull(interop__, "Specialization 'doForeignObject(Object, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s10_.interop_ = interop__;
                        if (!FOREIGN_OBJECT0_CACHE_UPDATER.compareAndSet(this, s10_original, s10_)) {
                            continue;
                        }
                        state_0 = state_0 | 0b10000000000 /* add SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */;
                        this.state_0_ = state_0;
                    }
                }
                if (s10_ != null) {
                    return doForeignObject(arg1Value, s10_.interop_);
                }
                break;
            }
        }
        {
            InteropLibrary interop__ = null;
            {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    if ((JSGuards.isForeignObject(arg1Value))) {
                        interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value));
                        this.foreignObject0_cache = null;
                        state_0 = state_0 & 0xfffffbff /* remove SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */;
                        state_0 = state_0 | 0b100000000000 /* add SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        return doForeignObject(arg1Value, interop__);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111111111111) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b111111111111) & ((state_0 & 0b111111111111) - 1)) == 0 /* is-single  */) {
                ForeignObject0Data s10_ = this.foreignObject0_cache;
                if ((s10_ == null || s10_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[13];
        Object[] s;
        data[0] = 0;
        int state_0 = this.state_0_;
        s = new Object[3];
        s[0] = "doBoolean";
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSToBooleanNode.doBoolean(boolean)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doNull";
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSToBooleanNode.doNull(Object)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doUndefined";
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSToBooleanNode.doUndefined(Object)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doInt";
        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSToBooleanNode.doInt(int)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "doLong";
        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSToBooleanNode.doLong(long)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "doDouble";
        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSToBooleanNode.doDouble(double)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[6] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSToBooleanNode.doBigInt(BigInt)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[7] = s;
        s = new Object[3];
        s[0] = "doString";
        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[JSToBooleanNode.doString(TruffleString)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[8] = s;
        s = new Object[3];
        s[0] = "doJSObject";
        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSToBooleanNode.doJSObject(JSObject)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSToBooleanNode.doSymbol(Symbol)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[10] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            ForeignObject0Data s10_ = this.foreignObject0_cache;
            while (s10_ != null) {
                cached.add(Arrays.<Object>asList(s10_.interop_));
                s10_ = s10_.next_;
            }
            s[2] = cached;
        }
        if (s[1] == null) {
            if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[11] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.<Object>asList());
            s[2] = cached;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[12] = s;
        return Provider.create(data);
    }

    @NeverDefault
    public static JSToBooleanNode create() {
        return new JSToBooleanNodeGen();
    }

    @NeverDefault
    public static JSToBooleanNode getUncached() {
        return JSToBooleanNodeGen.UNCACHED;
    }

    /**
     * Required Fields: <ul>
     * <li>{@link Inlined#state_0_}
     * <li>{@link Inlined#foreignObject0_cache}
     * </ul>
     */
    @NeverDefault
    public static JSToBooleanNode inline(@RequiredField(bits = 15, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
        return new JSToBooleanNodeGen.Inlined(target);
    }

    @GeneratedBy(JSToBooleanNode.class)
    @DenyReplace
    private static final class Inlined extends JSToBooleanNode implements Introspection.Provider {

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link JSToBooleanNode#doBoolean}
         *   1: SpecializationActive {@link JSToBooleanNode#doNull}
         *   2: SpecializationActive {@link JSToBooleanNode#doUndefined}
         *   3: SpecializationActive {@link JSToBooleanNode#doInt}
         *   4: SpecializationActive {@link JSToBooleanNode#doLong}
         *   5: SpecializationActive {@link JSToBooleanNode#doDouble}
         *   6: SpecializationActive {@link JSToBooleanNode#doBigInt}
         *   7: SpecializationActive {@link JSToBooleanNode#doString}
         *   8: SpecializationActive {@link JSToBooleanNode#doJSObject}
         *   9: SpecializationActive {@link JSToBooleanNode#doSymbol}
         *   10: SpecializationActive {@link JSToBooleanNode#doForeignObject}
         *   11: SpecializationActive {@link JSToBooleanNode#doForeignObject}
         *   12-14: ImplicitCast[type=double, index=1]
         * </pre>
         */
        private final StateField state_0_;
        private final ReferenceField<ForeignObject0Data> foreignObject0_cache;

        @SuppressWarnings("unchecked")
        private Inlined(InlineTarget target) {
            assert target.getTargetClass().isAssignableFrom(JSToBooleanNode.class);
            this.state_0_ = target.getState(0, 15);
            this.foreignObject0_cache = target.getReference(1, ForeignObject0Data.class);
        }

        @ExplodeLoop
        @Override
        public boolean executeBoolean(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0b111111111111) != 0 /* is SpecializationActive[JSToBooleanNode.doBoolean(boolean)] || SpecializationActive[JSToBooleanNode.doNull(Object)] || SpecializationActive[JSToBooleanNode.doUndefined(Object)] || SpecializationActive[JSToBooleanNode.doInt(int)] || SpecializationActive[JSToBooleanNode.doLong(long)] || SpecializationActive[JSToBooleanNode.doDouble(double)] || SpecializationActive[JSToBooleanNode.doBigInt(BigInt)] || SpecializationActive[JSToBooleanNode.doString(TruffleString)] || SpecializationActive[JSToBooleanNode.doJSObject(JSObject)] || SpecializationActive[JSToBooleanNode.doSymbol(Symbol)] || SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] || SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSToBooleanNode.doBoolean(boolean)] */ && arg1Value instanceof Boolean) {
                    boolean arg1Value_ = (boolean) arg1Value;
                    return JSToBooleanNode.doBoolean(arg1Value_);
                }
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[JSToBooleanNode.doNull(Object)] || SpecializationActive[JSToBooleanNode.doUndefined(Object)] */) {
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSToBooleanNode.doNull(Object)] */) {
                        if ((JSGuards.isJSNull(arg1Value))) {
                            return JSToBooleanNode.doNull(arg1Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSToBooleanNode.doUndefined(Object)] */) {
                        if ((JSGuards.isUndefined(arg1Value))) {
                            return JSToBooleanNode.doUndefined(arg1Value);
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSToBooleanNode.doInt(int)] */ && arg1Value instanceof Integer) {
                    int arg1Value_ = (int) arg1Value;
                    return JSToBooleanNode.doInt(arg1Value_);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSToBooleanNode.doLong(long)] */ && arg1Value instanceof Long) {
                    long arg1Value_ = (long) arg1Value;
                    return JSToBooleanNode.doLong(arg1Value_);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSToBooleanNode.doDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=double, index=1] */, arg1Value)) {
                    double arg1Value_ = JSTypesGen.asImplicitDouble((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=double, index=1] */, arg1Value);
                    return JSToBooleanNode.doDouble(arg1Value_);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSToBooleanNode.doBigInt(BigInt)] */ && arg1Value instanceof BigInt) {
                    BigInt arg1Value_ = (BigInt) arg1Value;
                    return JSToBooleanNode.doBigInt(arg1Value_);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[JSToBooleanNode.doString(TruffleString)] */ && arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString) arg1Value;
                    return JSToBooleanNode.doString(arg1Value_);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSToBooleanNode.doJSObject(JSObject)] */ && arg1Value instanceof JSObject) {
                    JSObject arg1Value_ = (JSObject) arg1Value;
                    return JSToBooleanNode.doJSObject(arg1Value_);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSToBooleanNode.doSymbol(Symbol)] */ && arg1Value instanceof Symbol) {
                    Symbol arg1Value_ = (Symbol) arg1Value;
                    return JSToBooleanNode.doSymbol(arg1Value_);
                }
                if ((state_0 & 0b110000000000) != 0 /* is SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] || SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */) {
                    if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */) {
                        ForeignObject0Data s10_ = this.foreignObject0_cache.get(arg0Value);
                        while (s10_ != null) {
                            if ((s10_.interop_.accepts(arg1Value)) && (JSGuards.isForeignObject(arg1Value))) {
                                return doForeignObject(arg1Value, s10_.interop_);
                            }
                            s10_ = s10_.next_;
                        }
                    }
                    if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */) {
                        if ((JSGuards.isForeignObject(arg1Value))) {
                            return this.foreignObject1Boundary0(state_0, arg0Value, arg1Value);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private boolean foreignObject1Boundary0(int state_0, Node arg0Value, Object arg1Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(arg0Value);
            try {
                {
                    InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value));
                    return doForeignObject(arg1Value, interop__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private boolean executeAndSpecialize(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (arg1Value instanceof Boolean) {
                boolean arg1Value_ = (boolean) arg1Value;
                state_0 = state_0 | 0b1 /* add SpecializationActive[JSToBooleanNode.doBoolean(boolean)] */;
                this.state_0_.set(arg0Value, state_0);
                return JSToBooleanNode.doBoolean(arg1Value_);
            }
            if ((JSGuards.isJSNull(arg1Value))) {
                state_0 = state_0 | 0b10 /* add SpecializationActive[JSToBooleanNode.doNull(Object)] */;
                this.state_0_.set(arg0Value, state_0);
                return JSToBooleanNode.doNull(arg1Value);
            }
            if ((JSGuards.isUndefined(arg1Value))) {
                state_0 = state_0 | 0b100 /* add SpecializationActive[JSToBooleanNode.doUndefined(Object)] */;
                this.state_0_.set(arg0Value, state_0);
                return JSToBooleanNode.doUndefined(arg1Value);
            }
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (int) arg1Value;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[JSToBooleanNode.doInt(int)] */;
                this.state_0_.set(arg0Value, state_0);
                return JSToBooleanNode.doInt(arg1Value_);
            }
            if (arg1Value instanceof Long) {
                long arg1Value_ = (long) arg1Value;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[JSToBooleanNode.doLong(long)] */;
                this.state_0_.set(arg0Value, state_0);
                return JSToBooleanNode.doLong(arg1Value_);
            }
            {
                int doubleCast1;
                if ((doubleCast1 = JSTypesGen.specializeImplicitDouble(arg1Value)) != 0) {
                    double arg1Value_ = JSTypesGen.asImplicitDouble(doubleCast1, arg1Value);
                    state_0 = (state_0 | (doubleCast1 << 12) /* set-int ImplicitCast[type=double, index=1] */);
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[JSToBooleanNode.doDouble(double)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return JSToBooleanNode.doDouble(arg1Value_);
                }
            }
            if (arg1Value instanceof BigInt) {
                BigInt arg1Value_ = (BigInt) arg1Value;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[JSToBooleanNode.doBigInt(BigInt)] */;
                this.state_0_.set(arg0Value, state_0);
                return JSToBooleanNode.doBigInt(arg1Value_);
            }
            if (arg1Value instanceof TruffleString) {
                TruffleString arg1Value_ = (TruffleString) arg1Value;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[JSToBooleanNode.doString(TruffleString)] */;
                this.state_0_.set(arg0Value, state_0);
                return JSToBooleanNode.doString(arg1Value_);
            }
            if (arg1Value instanceof JSObject) {
                JSObject arg1Value_ = (JSObject) arg1Value;
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[JSToBooleanNode.doJSObject(JSObject)] */;
                this.state_0_.set(arg0Value, state_0);
                return JSToBooleanNode.doJSObject(arg1Value_);
            }
            if (arg1Value instanceof Symbol) {
                Symbol arg1Value_ = (Symbol) arg1Value;
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[JSToBooleanNode.doSymbol(Symbol)] */;
                this.state_0_.set(arg0Value, state_0);
                return JSToBooleanNode.doSymbol(arg1Value_);
            }
            if (((state_0 & 0b100000000000)) == 0 /* is-not SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */) {
                while (true) {
                    int count10_ = 0;
                    ForeignObject0Data s10_ = this.foreignObject0_cache.getVolatile(arg0Value);
                    ForeignObject0Data s10_original = s10_;
                    while (s10_ != null) {
                        if ((s10_.interop_.accepts(arg1Value)) && (JSGuards.isForeignObject(arg1Value))) {
                            break;
                        }
                        count10_++;
                        s10_ = s10_.next_;
                    }
                    if (s10_ == null) {
                        if ((JSGuards.isForeignObject(arg1Value)) && count10_ < (JSConfig.InteropLibraryLimit)) {
                            // assert (s10_.interop_.accepts(arg1Value));
                            s10_ = arg0Value.insert(new ForeignObject0Data(s10_original));
                            InteropLibrary interop__ = s10_.insert((INTEROP_LIBRARY_.create(arg1Value)));
                            Objects.requireNonNull(interop__, "Specialization 'doForeignObject(Object, InteropLibrary)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s10_.interop_ = interop__;
                            if (!this.foreignObject0_cache.compareAndSet(arg0Value, s10_original, s10_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b10000000000 /* add SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */;
                            this.state_0_.set(arg0Value, state_0);
                        }
                    }
                    if (s10_ != null) {
                        return doForeignObject(arg1Value, s10_.interop_);
                    }
                    break;
                }
            }
            {
                InteropLibrary interop__ = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(arg0Value);
                    try {
                        if ((JSGuards.isForeignObject(arg1Value))) {
                            interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value));
                            this.foreignObject0_cache.set(arg0Value, null);
                            state_0 = state_0 & 0xfffffbff /* remove SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */;
                            state_0 = state_0 | 0b100000000000 /* add SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */;
                            this.state_0_.set(arg0Value, state_0);
                            return doForeignObject(arg1Value, interop__);
                        }
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

        @Override
        public Introspection getIntrospectionData(Node arg0Value) {
            Object[] data = new Object[13];
            Object[] s;
            data[0] = 0;
            int state_0 = this.state_0_.get(arg0Value);
            s = new Object[3];
            s[0] = "doBoolean";
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[JSToBooleanNode.doBoolean(boolean)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "doNull";
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[JSToBooleanNode.doNull(Object)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "doUndefined";
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[JSToBooleanNode.doUndefined(Object)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[3] = s;
            s = new Object[3];
            s[0] = "doInt";
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[JSToBooleanNode.doInt(int)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[4] = s;
            s = new Object[3];
            s[0] = "doLong";
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[JSToBooleanNode.doLong(long)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[5] = s;
            s = new Object[3];
            s[0] = "doDouble";
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[JSToBooleanNode.doDouble(double)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[6] = s;
            s = new Object[3];
            s[0] = "doBigInt";
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[JSToBooleanNode.doBigInt(BigInt)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[7] = s;
            s = new Object[3];
            s[0] = "doString";
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[JSToBooleanNode.doString(TruffleString)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[8] = s;
            s = new Object[3];
            s[0] = "doJSObject";
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[JSToBooleanNode.doJSObject(JSObject)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[9] = s;
            s = new Object[3];
            s[0] = "doSymbol";
            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[JSToBooleanNode.doSymbol(Symbol)] */) {
                s[1] = (byte)0b01 /* active */;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[10] = s;
            s = new Object[3];
            s[0] = "doForeignObject";
            if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                ForeignObject0Data s10_ = this.foreignObject0_cache.get(arg0Value);
                while (s10_ != null) {
                    cached.add(Arrays.<Object>asList(s10_.interop_));
                    s10_ = s10_.next_;
                }
                s[2] = cached;
            }
            if (s[1] == null) {
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */) {
                    s[1] = (byte)0b10 /* excluded */;
                } else {
                    s[1] = (byte)0b00 /* inactive */;
                }
            }
            data[11] = s;
            s = new Object[3];
            s[0] = "doForeignObject";
            if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[JSToBooleanNode.doForeignObject(Object, InteropLibrary)] */) {
                s[1] = (byte)0b01 /* active */;
                ArrayList<Object> cached = new ArrayList<>();
                cached.add(Arrays.<Object>asList());
                s[2] = cached;
            }
            if (s[1] == null) {
                s[1] = (byte)0b00 /* inactive */;
            }
            data[12] = s;
            return Provider.create(data);
        }

    }
    @GeneratedBy(JSToBooleanNode.class)
    @DenyReplace
    private static final class ForeignObject0Data extends Node implements SpecializationDataNode {

        @Child ForeignObject0Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link JSToBooleanNode#doForeignObject}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child InteropLibrary interop_;

        ForeignObject0Data(ForeignObject0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(JSToBooleanNode.class)
    @DenyReplace
    private static final class Uncached extends JSToBooleanNode {

        @TruffleBoundary
        @Override
        public boolean executeBoolean(Node arg0Value, Object arg1Value) {
            if (arg1Value instanceof Boolean) {
                boolean arg1Value_ = (boolean) arg1Value;
                return JSToBooleanNode.doBoolean(arg1Value_);
            }
            if ((JSGuards.isJSNull(arg1Value))) {
                return JSToBooleanNode.doNull(arg1Value);
            }
            if ((JSGuards.isUndefined(arg1Value))) {
                return JSToBooleanNode.doUndefined(arg1Value);
            }
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (int) arg1Value;
                return JSToBooleanNode.doInt(arg1Value_);
            }
            if (arg1Value instanceof Long) {
                long arg1Value_ = (long) arg1Value;
                return JSToBooleanNode.doLong(arg1Value_);
            }
            if (JSTypesGen.isImplicitDouble(arg1Value)) {
                double arg1Value_ = JSTypesGen.asImplicitDouble(arg1Value);
                return JSToBooleanNode.doDouble(arg1Value_);
            }
            if (arg1Value instanceof BigInt) {
                BigInt arg1Value_ = (BigInt) arg1Value;
                return JSToBooleanNode.doBigInt(arg1Value_);
            }
            if (arg1Value instanceof TruffleString) {
                TruffleString arg1Value_ = (TruffleString) arg1Value;
                return JSToBooleanNode.doString(arg1Value_);
            }
            if (arg1Value instanceof JSObject) {
                JSObject arg1Value_ = (JSObject) arg1Value;
                return JSToBooleanNode.doJSObject(arg1Value_);
            }
            if (arg1Value instanceof Symbol) {
                Symbol arg1Value_ = (Symbol) arg1Value;
                return JSToBooleanNode.doSymbol(arg1Value_);
            }
            if ((JSGuards.isForeignObject(arg1Value))) {
                return doForeignObject(arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)));
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
