// CheckStyle: start generated
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link RequireObjectNode#doObjectShape}
 *     Activation probability: 0.65000
 *     With/without class size: 15/5 bytes
 *   Specialization {@link RequireObjectNode#doObject}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre>
 */
@GeneratedBy(RequireObjectNode.class)
@SuppressWarnings("javadoc")
public final class RequireObjectNodeGen extends RequireObjectNode implements Introspection.Provider {

    static final ReferenceField<ObjectShapeData> OBJECT_SHAPE_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "objectShape_cache", ObjectShapeData.class);

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link RequireObjectNode#doObjectShape}
     *   1: SpecializationActive {@link RequireObjectNode#doObject}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @CompilationFinal private ObjectShapeData objectShape_cache;

    private RequireObjectNodeGen(JavaScriptNode operand) {
        super(operand);
    }

    @Override
    public Object execute(Object operandNodeValue) {
        int state_0 = this.state_0_;
        if (state_0 != 0 /* is SpecializationActive[RequireObjectNode.doObjectShape(JSDynamicObject, Shape, boolean)] || SpecializationActive[RequireObjectNode.doObject(Object)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[RequireObjectNode.doObjectShape(JSDynamicObject, Shape, boolean)] */ && operandNodeValue instanceof JSDynamicObject) {
                JSDynamicObject operandNodeValue_ = (JSDynamicObject) operandNodeValue;
                ObjectShapeData s0_ = this.objectShape_cache;
                if (s0_ != null) {
                    if ((s0_.cachedShape_.check(operandNodeValue_))) {
                        return RequireObjectNode.doObjectShape(operandNodeValue_, s0_.cachedShape_, s0_.cachedResult_);
                    }
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[RequireObjectNode.doObject(Object)] */) {
                return RequireObjectNode.doObject(operandNodeValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object operandNodeValue_ = super.operandNode.execute(frameValue);
        if (state_0 != 0 /* is SpecializationActive[RequireObjectNode.doObjectShape(JSDynamicObject, Shape, boolean)] || SpecializationActive[RequireObjectNode.doObject(Object)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[RequireObjectNode.doObjectShape(JSDynamicObject, Shape, boolean)] */ && operandNodeValue_ instanceof JSDynamicObject) {
                JSDynamicObject operandNodeValue__ = (JSDynamicObject) operandNodeValue_;
                ObjectShapeData s0_ = this.objectShape_cache;
                if (s0_ != null) {
                    if ((s0_.cachedShape_.check(operandNodeValue__))) {
                        return RequireObjectNode.doObjectShape(operandNodeValue__, s0_.cachedShape_, s0_.cachedResult_);
                    }
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[RequireObjectNode.doObject(Object)] */) {
                return RequireObjectNode.doObject(operandNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        execute(frameValue);
        return;
    }

    @SuppressWarnings("unused")
    private Object executeAndSpecialize(Object operandNodeValue) {
        int state_0 = this.state_0_;
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[RequireObjectNode.doObject(Object)] */ && operandNodeValue instanceof JSDynamicObject) {
            JSDynamicObject operandNodeValue_ = (JSDynamicObject) operandNodeValue;
            while (true) {
                int count0_ = 0;
                ObjectShapeData s0_ = OBJECT_SHAPE_CACHE_UPDATER.getVolatile(this);
                ObjectShapeData s0_original = s0_;
                while (s0_ != null) {
                    if ((s0_.cachedShape_.check(operandNodeValue_))) {
                        break;
                    }
                    count0_++;
                    s0_ = null;
                    break;
                }
                if (s0_ == null && count0_ < 1) {
                    {
                        Shape cachedShape__ = (operandNodeValue_.getShape());
                        if ((cachedShape__.check(operandNodeValue_))) {
                            s0_ = new ObjectShapeData();
                            Objects.requireNonNull(cachedShape__, "Specialization 'doObjectShape(JSDynamicObject, Shape, boolean)' cache 'cachedShape' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s0_.cachedShape_ = cachedShape__;
                            s0_.cachedResult_ = (JSGuards.isJSObject(operandNodeValue_));
                            if (!OBJECT_SHAPE_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b1 /* add SpecializationActive[RequireObjectNode.doObjectShape(JSDynamicObject, Shape, boolean)] */;
                            this.state_0_ = state_0;
                        }
                    }
                }
                if (s0_ != null) {
                    return RequireObjectNode.doObjectShape(operandNodeValue_, s0_.cachedShape_, s0_.cachedResult_);
                }
                break;
            }
        }
        this.objectShape_cache = null;
        state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[RequireObjectNode.doObjectShape(JSDynamicObject, Shape, boolean)] */;
        state_0 = state_0 | 0b10 /* add SpecializationActive[RequireObjectNode.doObject(Object)] */;
        this.state_0_ = state_0;
        return RequireObjectNode.doObject(operandNodeValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[3];
        Object[] s;
        data[0] = 0;
        int state_0 = this.state_0_;
        s = new Object[3];
        s[0] = "doObjectShape";
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[RequireObjectNode.doObjectShape(JSDynamicObject, Shape, boolean)] */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            ObjectShapeData s0_ = this.objectShape_cache;
            if (s0_ != null) {
                cached.add(Arrays.<Object>asList(s0_.cachedShape_, s0_.cachedResult_));
            }
            s[2] = cached;
        }
        if (s[1] == null) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[RequireObjectNode.doObject(Object)] */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doObject";
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[RequireObjectNode.doObject(Object)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        return Provider.create(data);
    }

    @NeverDefault
    public static RequireObjectNode create(JavaScriptNode operand) {
        return new RequireObjectNodeGen(operand);
    }

    @GeneratedBy(RequireObjectNode.class)
    @DenyReplace
    private static final class ObjectShapeData implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link RequireObjectNode#doObjectShape}
         *   Parameter: {@link Shape} cachedShape</pre>
         */
        @CompilationFinal Shape cachedShape_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link RequireObjectNode#doObjectShape}
         *   Parameter: boolean cachedResult</pre>
         */
        @CompilationFinal boolean cachedResult_;

        ObjectShapeData() {
        }

    }
}
