// CheckStyle: start generated
package com.oracle.truffle.js.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import java.lang.invoke.VarHandle;

@GeneratedBy(JavaScriptNode.class)
@SuppressWarnings("javadoc")
public final class JavaScriptNodeGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(JavaScriptNode.class, new NodeLibraryExports());
    }

    private JavaScriptNodeGen() {
    }

    @GeneratedBy(JavaScriptNode.class)
    public static class NodeLibraryExports extends LibraryExport<NodeLibrary> {

        private NodeLibraryExports() {
            super(NodeLibrary.class, JavaScriptNode.class, false, false, 0);
        }

        @Override
        protected NodeLibrary createUncached(Object receiver) {
            assert receiver instanceof JavaScriptNode;
            NodeLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected NodeLibrary createCached(Object receiver) {
            assert receiver instanceof JavaScriptNode;
            return new Cached(receiver);
        }

        @GeneratedBy(JavaScriptNode.class)
        public static class Cached extends NodeLibrary {

            private final Class<? extends JavaScriptNode> receiverClass_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link JavaScriptNode#getScope(JavaScriptNode, Frame, boolean, Node, Node)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link JavaScriptNode#accepts(JavaScriptNode, JavaScriptNode)}
             *   Parameter: {@link JavaScriptNode} cachedNode</pre>
             */
            @CompilationFinal private JavaScriptNode acceptsNode__accepts_cachedNode_;
            @Child private GetScopeNode_GetScopeData getScopeNode__getScope_cache;

            protected Cached(Object receiver) {
                JavaScriptNode castReceiver = ((JavaScriptNode) receiver) ;
                VarHandle.storeStoreFence();
                this.acceptsNode__accepts_cachedNode_ = (castReceiver);
                this.receiverClass_ = castReceiver.getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_) && accepts_(receiver);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link JavaScriptNode#accepts(JavaScriptNode, JavaScriptNode)}
             *     Activation probability: 0.50000
             *     With/without class size: 10/0 bytes
             * </pre>
             */
            private boolean accepts_(Object arg0Value_) {
                JavaScriptNode arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                return arg0Value.accepts(this.acceptsNode__accepts_cachedNode_);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public boolean hasScope(Object receiver, Frame frame) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (CompilerDirectives.castExact(receiver, receiverClass_)).hasScope(frame);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link JavaScriptNode#getScope(JavaScriptNode, Frame, boolean, Node, Node)}
             *     Activation probability: 0.50000
             *     With/without class size: 16/8 bytes
             * </pre>
             */
            @Override
            public Object getScope(Object arg0Value_, Frame arg1Value, boolean arg2Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                JavaScriptNode arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[JavaScriptNode.getScope(JavaScriptNode, Frame, boolean, Node, Node)] */) {
                    GetScopeNode_GetScopeData s0_ = this.getScopeNode__getScope_cache;
                    if (s0_ != null) {
                        return arg0Value.getScope(arg1Value, arg2Value, s0_.blockNode_, s0_.frameBlockNode_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getScopeNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object getScopeNode_AndSpecialize(JavaScriptNode arg0Value, Frame arg1Value, boolean arg2Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                GetScopeNode_GetScopeData s0_ = this.insert(new GetScopeNode_GetScopeData());
                s0_.blockNode_ = (JavaScriptNode.findBlockScopeNode(arg0Value));
                s0_.frameBlockNode_ = (JavaScriptNode.findFrameScopeNode(s0_.blockNode_));
                VarHandle.storeStoreFence();
                this.getScopeNode__getScope_cache = s0_;
                state_0 = state_0 | 0b1 /* add SpecializationActive[JavaScriptNode.getScope(JavaScriptNode, Frame, boolean, Node, Node)] */;
                this.state_0_ = state_0;
                return arg0Value.getScope(arg1Value, arg2Value, s0_.blockNode_, s0_.frameBlockNode_);
            }

            @Override
            public boolean hasReceiverMember(Object receiver, Frame frame) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (CompilerDirectives.castExact(receiver, receiverClass_)).hasReceiverMember(frame);
            }

            @Override
            public Object getReceiverMember(Object receiver, Frame frame) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (CompilerDirectives.castExact(receiver, receiverClass_)).getReceiverMember(frame);
            }

            @Override
            public boolean hasRootInstance(Object receiver, Frame frame) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (CompilerDirectives.castExact(receiver, receiverClass_)).hasRootInstance(frame);
            }

            @Override
            public Object getRootInstance(Object receiver, Frame frame) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (CompilerDirectives.castExact(receiver, receiverClass_)).getRootInstance(frame);
            }

            @GeneratedBy(JavaScriptNode.class)
            @DenyReplace
            private static final class GetScopeNode_GetScopeData extends Node implements SpecializationDataNode {

                /**
                 * Source Info: <pre>
                 *   Specialization: {@link JavaScriptNode#getScope(JavaScriptNode, Frame, boolean, Node, Node)}
                 *   Parameter: {@link Node} blockNode</pre>
                 */
                @CompilationFinal Node blockNode_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link JavaScriptNode#getScope(JavaScriptNode, Frame, boolean, Node, Node)}
                 *   Parameter: {@link Node} frameBlockNode</pre>
                 */
                @CompilationFinal Node frameBlockNode_;

                GetScopeNode_GetScopeData() {
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

            }
        }
        @GeneratedBy(JavaScriptNode.class)
        public static class Uncached extends NodeLibrary {

            private final Class<? extends JavaScriptNode> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((JavaScriptNode) receiver).getClass();
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_) && accepts_(receiver);
            }

            @Override
            public final boolean isAdoptable() {
                return false;
            }

            @Override
            public final NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean hasScope(Object receiver, Frame frame) {
                // declared: true
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((JavaScriptNode) receiver) .hasScope(frame);
            }

            @Override
            public Object getScope(Object arg0Value_, Frame arg1Value, boolean arg2Value) throws UnsupportedMessageException {
                // declared: true
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                JavaScriptNode arg0Value = ((JavaScriptNode) arg0Value_);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return arg0Value.getScope(arg1Value, arg2Value, (JavaScriptNode.findBlockScopeNode(arg0Value)), (JavaScriptNode.findFrameScopeNode((JavaScriptNode.findBlockScopeNode(arg0Value)))));
            }

            @Override
            public boolean hasReceiverMember(Object receiver, Frame frame) {
                // declared: true
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((JavaScriptNode) receiver) .hasReceiverMember(frame);
            }

            @Override
            public Object getReceiverMember(Object receiver, Frame frame) throws UnsupportedMessageException {
                // declared: true
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((JavaScriptNode) receiver) .getReceiverMember(frame);
            }

            @Override
            public boolean hasRootInstance(Object receiver, Frame frame) {
                // declared: true
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((JavaScriptNode) receiver) .hasRootInstance(frame);
            }

            @Override
            public Object getRootInstance(Object receiver, Frame frame) throws UnsupportedMessageException {
                // declared: true
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((JavaScriptNode) receiver) .getRootInstance(frame);
            }

            @TruffleBoundary
            private static boolean accepts_(Object arg0Value_) {
                JavaScriptNode arg0Value = ((JavaScriptNode) arg0Value_);
                return arg0Value.accepts((arg0Value));
            }

        }
    }
}
