/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.graalvm.buildtools.maven.NativeCompileNoForkMojo;
import org.graalvm.buildtools.utils.NativeImageUtils;

@Mojo(name="write-args-file", requiresDependencyResolution=ResolutionScope.RUNTIME, requiresDependencyCollection=ResolutionScope.RUNTIME)
public class WriteArgsFileMojo
extends NativeCompileNoForkMojo {
    public static final String NAME = "write-args-file";
    public static final String PROPERTY_NAME = "graalvm.native-image.args-file";

    @Override
    public void execute() throws MojoExecutionException {
        List<String> args = this.getBuildArgs();
        this.getLog().debug((CharSequence)"Cleaning old native image build args");
        try (Stream<Path> listStream = Files.list(this.outputDirectory.toPath());){
            listStream.map(path -> path.getFileName().toString()).filter(f -> f.startsWith("native-image") && f.endsWith("args")).map(this.outputDirectory.toPath()::resolve).forEach(file -> {
                try {
                    Files.delete(file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        List conversionResult = NativeImageUtils.convertToArgsFile(args, (Path)this.outputDirectory.toPath());
        if (conversionResult.size() != 1) {
            throw new MojoExecutionException("Error writing args file");
        }
        String argsFileName = ((String)conversionResult.get(0)).replace("@", "");
        this.getLog().info((CharSequence)("Args file written to: " + argsFileName));
        File argsFile = new File(argsFileName);
        this.project.getProperties().setProperty(PROPERTY_NAME, argsFile.getAbsolutePath());
    }
}

