/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.junit.platform;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.junit.platform.PrintTestExecutionListener;
import org.graalvm.nativeimage.ImageInfo;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.junit.platform.reporting.legacy.xml.LegacyXmlReportGeneratingListener;

public class NativeImageJUnitLauncher {
    static final String DEFAULT_OUTPUT_FOLDER = Paths.get("test-results-native", new String[0]).resolve("test").toString();

    static String stringPad(String input) {
        return String.format("%1$-20s", input);
    }

    public static void main(String ... args) {
        long failedCount;
        if (!ImageInfo.inImageCode()) {
            System.err.println("NativeImageJUnitLauncher can only be used for native-image compiled tests.");
            System.exit(1);
        }
        String xmlOutput = DEFAULT_OUTPUT_FOLDER;
        boolean silent = false;
        LinkedList<String> arguments = new LinkedList<String>(Arrays.asList(args));
        block10: while (!arguments.isEmpty()) {
            String arg;
            switch (arg = arguments.poll()) {
                case "--help": {
                    System.out.println("JUnit Platform launcher for GraalVM Native Image");
                    System.out.println("----------------------------------------\n");
                    System.out.println("Flags:");
                    System.out.println(NativeImageJUnitLauncher.stringPad("--xml-output-dir") + "Selects report xml output directory (default: `" + DEFAULT_OUTPUT_FOLDER + "`)");
                    System.out.println(NativeImageJUnitLauncher.stringPad("--silent") + "Only output xml without stdout summary");
                    System.out.println(NativeImageJUnitLauncher.stringPad("--help") + "Displays this help screen");
                    System.exit(0);
                    continue block10;
                }
                case "--xml-output-dir": {
                    xmlOutput = arguments.poll();
                    continue block10;
                }
                case "--silent": {
                    silent = true;
                    continue block10;
                }
            }
            System.err.println("Found unknown command line option: " + arg);
            System.exit(1);
        }
        if (xmlOutput == null) {
            throw new RuntimeException("xml-output-dir argument passed incorrectly to the launcher class.");
        }
        Launcher launcher = LauncherFactory.create();
        TestPlan testPlan = NativeImageJUnitLauncher.getTestPlan(launcher);
        PrintWriter out = new PrintWriter(System.out);
        if (!silent) {
            out.println("JUnit Platform on Native Image - report");
            out.println("----------------------------------------\n");
            out.flush();
            NativeImageJUnitLauncher.configurePrintTestExecutionListener(launcher, out);
        }
        SummaryGeneratingListener summaryListener = new SummaryGeneratingListener();
        launcher.registerTestExecutionListeners(new TestExecutionListener[]{summaryListener});
        NativeImageJUnitLauncher.configureLegacyXMLReport(launcher, xmlOutput, out);
        launcher.execute(testPlan, new TestExecutionListener[0]);
        TestExecutionSummary summary = summaryListener.getSummary();
        if (!silent) {
            summary.printFailuresTo(out);
            summary.printTo(out);
        }
        System.exit((failedCount = summary.getTotalFailureCount()) > 0L ? 1 : 0);
    }

    private static TestPlan getTestPlan(Launcher launcher) {
        List<? extends DiscoverySelector> selectors = NativeImageJUnitLauncher.getSelectors();
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(selectors).build();
        return launcher.discover(request);
    }

    private static List<? extends DiscoverySelector> getSelectors() {
        try {
            String systemPropertyBasedLocation = System.getProperty("junit.platform.listeners.uid.tracking.output.dir");
            Path uniqueIdDirectory = systemPropertyBasedLocation != null ? Path.of(systemPropertyBasedLocation, new String[0]) : NativeImageJUnitLauncher.getTestIDsFromDefaultLocations();
            String uniqueIdFilePrefix = System.getProperty("junit.platform.listeners.uid.tracking.output.file.prefix", "junit-platform-unique-ids");
            if (uniqueIdFilePrefix == null) {
                throw new RuntimeException("Test-ids unique id file prefix not provided to the NativeImageJUnitLauncher.");
            }
            List selectors = NativeImageJUnitLauncher.readAllFiles(uniqueIdDirectory, uniqueIdFilePrefix).map(DiscoverySelectors::selectUniqueId).collect(Collectors.toList());
            if (!selectors.isEmpty()) {
                System.out.printf("[junit-platform-native] Running in 'test listener' mode using files matching pattern [%s*] found in folder [%s] and its subfolders.%n", uniqueIdFilePrefix, uniqueIdDirectory.toAbsolutePath());
                return selectors;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to read UIDs from UniqueIdTrackingListener output files: " + ex.getMessage());
        }
        throw new RuntimeException("Cannot compute test selectors from test ids.");
    }

    private static Stream<String> readAllFiles(Path dir, String prefix) throws IOException {
        return NativeImageJUnitLauncher.findFiles(dir, prefix).flatMap(outputFile -> {
            try {
                return Files.readAllLines(outputFile).stream();
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        });
    }

    private static Stream<Path> findFiles(Path dir, String prefix) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            return Stream.empty();
        }
        return Files.find(dir, Integer.MAX_VALUE, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile() && path.getFileName().toString().startsWith(prefix), new FileVisitOption[0]);
    }

    private static Path getTestIDsFromDefaultLocations() {
        System.out.println("[junit-platform-native] WARNING: -djunit.platform.listeners.uid.tracking.output.dir not specified, trying to find test-ids on default Gradle/Maven locations. As this is a fallback mode, it could take a while. This should only happen if you are running tests executable manually and you didn't pass uid output directory with -djunit.platform.listeners.uid.tracking.output.dir=<path>.");
        Path defaultGradleTestIDsLocation = NativeImageJUnitLauncher.getGradleTestIdsDefaultLocation();
        Path defaultMavenTestIDsLocation = NativeImageJUnitLauncher.getMavenTestIDsDefaultLocation();
        if (NativeImageJUnitLauncher.testIdsDirectoryExists(defaultGradleTestIDsLocation) && NativeImageJUnitLauncher.testIdsDirectoryExists(defaultMavenTestIDsLocation)) {
            throw new RuntimeException("[junit-platform-native] test-ids found in both " + String.valueOf(defaultGradleTestIDsLocation) + " and " + String.valueOf(defaultMavenTestIDsLocation) + ". Please specify the test-ids location by passing the '--test-ids <path-to-test-ids>' argument to your tests executable.");
        }
        if (NativeImageJUnitLauncher.testIdsDirectoryExists(defaultGradleTestIDsLocation)) {
            System.out.println("[junit-platform-native] WARNING: Using test-ids from default Gradle project location:" + String.valueOf(defaultGradleTestIDsLocation));
            return defaultGradleTestIDsLocation;
        }
        if (NativeImageJUnitLauncher.testIdsDirectoryExists(defaultMavenTestIDsLocation)) {
            System.out.println("[junit-platform-native] WARNING: Using test-ids from default Maven project location:" + String.valueOf(defaultMavenTestIDsLocation));
            return defaultMavenTestIDsLocation;
        }
        throw new RuntimeException("[junit-platform-native] test-ids not provided to the NativeImageJUnitLauncher and cannot be found on default locations.");
    }

    private static Path getGradleTestIdsDefaultLocation() {
        File gradleBuildDirectory = new File(NativeImageJUnitLauncher.getBuildDirectory(File.separator + "build" + File.separator));
        return NativeImageJUnitLauncher.searchForDirectory(gradleBuildDirectory, "testlist");
    }

    private static Path getMavenTestIDsDefaultLocation() {
        File mavenTargetDirectory = new File(NativeImageJUnitLauncher.getBuildDirectory(File.separator + "target" + File.separator));
        return NativeImageJUnitLauncher.searchForDirectory(mavenTargetDirectory, "test-ids");
    }

    private static String getBuildDirectory(String buildDir) {
        String executableLocation = Path.of(".", new String[0]).toAbsolutePath().toString();
        int index = executableLocation.indexOf(buildDir);
        if (index < 0) {
            return buildDir.substring(1);
        }
        return executableLocation.substring(0, index + buildDir.length());
    }

    private static Path searchForDirectory(File root, String target) {
        if (root == null || !root.isDirectory()) {
            return null;
        }
        if (root.getName().equals(target)) {
            return Path.of(root.getAbsolutePath(), new String[0]);
        }
        File[] content = root.listFiles();
        if (content == null) {
            return null;
        }
        for (File file : content) {
            Path result = NativeImageJUnitLauncher.searchForDirectory(file, target);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static boolean testIdsDirectoryExists(Path directory) {
        return directory != null && Files.exists(directory, new LinkOption[0]);
    }

    private static void configurePrintTestExecutionListener(Launcher launcher, PrintWriter out) {
        try {
            Class.forName("org.junit.platform.reporting.legacy.LegacyReportingUtils");
            launcher.registerTestExecutionListeners(new TestExecutionListener[]{new PrintTestExecutionListener(out)});
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
    }

    private static void configureLegacyXMLReport(Launcher launcher, String xmlOutput, PrintWriter out) {
        try {
            launcher.registerTestExecutionListeners(new TestExecutionListener[]{new LegacyXmlReportGeneratingListener(Paths.get(xmlOutput, new String[0]), out)});
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

