/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.junit.platform.config.jupiter;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.junit.platform.JUnitPlatformFeature;
import org.graalvm.junit.platform.config.core.NativeImageConfiguration;
import org.graalvm.junit.platform.config.core.PluginConfigProvider;
import org.graalvm.junit.platform.config.util.AnnotationUtils;
import org.junit.jupiter.api.DisplayNameGeneration;
import org.junit.jupiter.api.IndicativeSentencesGeneration;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.aggregator.AggregateWith;
import org.junit.jupiter.params.converter.ConvertWith;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.FieldSource;
import org.junit.jupiter.params.provider.MethodSource;

public class JupiterConfigProvider
extends PluginConfigProvider {
    @Override
    public void onLoad(NativeImageConfiguration config) {
        config.registerAllClassMembersForReflection("org.junit.jupiter.engine.extension.TimeoutExtension$ExecutorResource", "org.junit.jupiter.engine.extension.TimeoutInvocationFactory$SingleThreadExecutorResource");
    }

    @Override
    public void onTestClassRegistered(Class<?> testClass, NativeImageConfiguration registry) {
        try {
            AnnotationUtils.registerClassesFromAnnotationForReflection(testClass, registry, TestMethodOrder.class, TestMethodOrder::value);
            AnnotationUtils.registerClassesFromAnnotationForReflection(testClass, registry, ExtendWith.class, ExtendWith::value);
            AnnotationUtils.registerClassesFromAnnotationForReflection(testClass, registry, DisplayNameGeneration.class, DisplayNameGeneration::value);
            AnnotationUtils.registerClassesFromAnnotationForReflection(testClass, registry, IndicativeSentencesGeneration.class, IndicativeSentencesGeneration::generator);
            AnnotationUtils.registerClassesFromAnnotationForReflection(testClass, registry, EnabledIf.class, JupiterConfigProvider::handleEnabledIf);
            AnnotationUtils.registerClassesFromAnnotationForReflection(testClass, registry, DisabledIf.class, JupiterConfigProvider::handleDisabledIf);
        }
        catch (NoClassDefFoundError e) {
            JUnitPlatformFeature.debug("Cannot register annotations %s from 'org.junit.jupiter.api'. Please verify that you have dependency that includes 'org.junit.jupiter.api' if you want to use these annotations.", List.of("TestMethodOrder", "ExtendWith", "DisplayNameGeneration", "IndicativeSentencesGeneration", "EnabledIf", "DisabledIf"));
        }
        try {
            AnnotationUtils.registerClassesFromAnnotationForReflection(testClass, registry, ArgumentsSource.class, ArgumentsSource::value);
            AnnotationUtils.forEachAnnotatedMethodParameter(testClass, ConvertWith.class, annotation -> registry.registerAllClassMembersForReflection(annotation.value()));
            AnnotationUtils.forEachAnnotatedMethodParameter(testClass, AggregateWith.class, annotation -> registry.registerAllClassMembersForReflection(annotation.value()));
            AnnotationUtils.forEachAnnotatedMethod(testClass, EnumSource.class, (m, annotation) -> JupiterConfigProvider.handleEnumSource(m, annotation, registry));
            AnnotationUtils.registerClassesFromAnnotationForReflection(testClass, registry, MethodSource.class, JupiterConfigProvider::handleMethodSource);
            try {
                AnnotationUtils.registerClassesFromAnnotationForReflection(testClass, registry, FieldSource.class, JupiterConfigProvider::handleFieldSource);
            }
            catch (NoClassDefFoundError e) {
                JUnitPlatformFeature.debug("Cannot register @FieldSource annotation from org.junit.jupiter.params. Please verify that you have this dependency (with version greater than JUnit 5.13) if you want to use this annotation.", new Object[0]);
            }
        }
        catch (NoClassDefFoundError e) {
            JUnitPlatformFeature.debug("Cannot register annotations %s from 'org.junit.jupiter.params'. Please verify that you have dependency that includes 'org.junit.jupiter.params' if you want to use these annotations.", List.of("ArgumentsSource", "ConvertWith", "AggregateWith", "EnumSource", "MethodSource", "FieldSource"));
        }
    }

    private static Class<?>[] handleMethodSource(MethodSource annotation) {
        return JupiterConfigProvider.handleMethodReference(annotation.value());
    }

    private static Class<?>[] handleFieldSource(FieldSource annotation) {
        return JupiterConfigProvider.handleMethodReference(annotation.value());
    }

    private static Class<?>[] handleEnabledIf(EnabledIf annotation) {
        return JupiterConfigProvider.handleMethodReference(annotation.value());
    }

    private static Class<?>[] handleDisabledIf(DisabledIf annotation) {
        return JupiterConfigProvider.handleMethodReference(annotation.value());
    }

    private static Class<?>[] handleMethodReference(String ... methodNames) {
        ArrayList classList = new ArrayList();
        for (String methodName : methodNames) {
            String[] parts = methodName.split("#");
            JUnitPlatformFeature.debug("Found method reference: %s", methodName);
            if (parts.length == 2) {
                String className = parts[0];
                JUnitPlatformFeature.debug("Processing method reference from another class: %s", className);
                try {
                    classList.add(Class.forName(className));
                }
                catch (ClassNotFoundException e) {
                    JUnitPlatformFeature.debug("Failed to register method reference for reflection: %s Reason: %s", className, e);
                }
                continue;
            }
            JUnitPlatformFeature.debug("Skipping method reference as it originates in the same class as the test: %s", methodName);
        }
        return classList.toArray(new Class[0]);
    }

    public static void handleEnumSource(Method method, EnumSource source, NativeImageConfiguration registry) {
        registry.registerAllClassMembersForReflection(source.value());
        if (method.getParameterCount() > 0) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> enumParameterType = parameterTypes[0];
            if (enumParameterType.isEnum()) {
                JUnitPlatformFeature.debug("Registering method enum parameter for reflection. Method: %s Parameter: %s", method, parameterTypes[0]);
                registry.registerAllClassMembersForReflection(enumParameterType);
            } else {
                JUnitPlatformFeature.debug("First parameter of method not an enum - skipping. Method: %s", method);
            }
        } else {
            JUnitPlatformFeature.debug("Method doesn't have at least 1 parameter - skipping enum registration. Method: %s", method);
        }
    }
}

