/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.junit.platform;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

class TestClassRegistrar {
    private final Set<Class<?>> registeredClasses = new HashSet();
    private final Consumer<Class<?>> registrationCallback;

    TestClassRegistrar(Consumer<Class<?>> registrationCallback) {
        this.registrationCallback = registrationCallback;
    }

    void registerTestClassForReflection(Class<?> clazz) {
        Class<?>[] interfaces;
        Class<?>[] declaredClasses;
        if (!this.shouldRegisterClass(clazz)) {
            return;
        }
        this.registrationCallback.accept(clazz);
        for (Class<?> declaredClass : declaredClasses = clazz.getDeclaredClasses()) {
            this.registerTestClassForReflection(declaredClass);
        }
        for (Class<?> inter : interfaces = clazz.getInterfaces()) {
            this.registerTestClassForReflection(inter);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            this.registerTestClassForReflection(superClass);
        }
    }

    private boolean shouldRegisterClass(Class<?> clazz) {
        if (ModuleLayer.boot().modules().contains(clazz.getModule())) {
            return false;
        }
        if (this.registeredClasses.contains(clazz)) {
            return false;
        }
        this.registeredClasses.add(clazz);
        return true;
    }
}

