/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.reachability.internal.index.modules;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.reachability.internal.UncheckedIOException;
import org.graalvm.reachability.internal.index.modules.ModuleEntry;
import org.graalvm.reachability.internal.index.modules.ModuleToConfigDirectoryIndex;

public class JsonModuleToConfigDirectoryIndex
implements ModuleToConfigDirectoryIndex {
    private final Path rootPath;
    private final Map<String, Set<Path>> index;

    public JsonModuleToConfigDirectoryIndex(Path rootPath) {
        this.rootPath = rootPath;
        this.index = this.parseIndexFile(rootPath);
    }

    private Map<String, Set<Path>> parseIndexFile(Path rootPath) {
        HashMap hashMap;
        block9: {
            Path indexFile = rootPath.resolve("index.json");
            ObjectMapper objectMapper = new ObjectMapper();
            TypeFactory typeFactory = objectMapper.getTypeFactory();
            BufferedReader reader = Files.newBufferedReader(indexFile);
            try {
                List entries = (List)objectMapper.readValue((Reader)reader, (JavaType)typeFactory.constructCollectionType(List.class, ModuleEntry.class));
                Map<String, List<ModuleEntry>> moduleToEntries = entries.stream().collect(Collectors.groupingBy(ModuleEntry::getModule));
                HashMap index = new HashMap(moduleToEntries.size());
                for (Map.Entry<String, List<ModuleEntry>> entry : moduleToEntries.entrySet()) {
                    String key = entry.getKey();
                    Set dirs = entry.getValue().stream().flatMap(module -> Stream.concat(Stream.of(module.getModuleDirectory()), module.getRequires().stream().flatMap(e -> {
                        List moduleEntries = (List)moduleToEntries.get(e);
                        if (moduleEntries == null) {
                            throw new IllegalStateException("Module " + module.getModule() + " requires module " + e + " which is not found in index");
                        }
                        return moduleEntries.stream().map(ModuleEntry::getModuleDirectory);
                    }))).filter(Objects::nonNull).map(rootPath::resolve).collect(Collectors.toSet());
                    index.put(key, dirs);
                }
                hashMap = index;
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            reader.close();
        }
        return hashMap;
    }

    @Override
    public Set<Path> findConfigurationDirectories(String groupId, String artifactId) {
        String key = groupId + ":" + artifactId;
        if (!this.index.containsKey(key)) {
            return Collections.emptySet();
        }
        return this.index.get(key);
    }
}

