/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Claims;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.Lifetime;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import java.util.Collection;
import java.util.Iterator;

public class RequestSecurityTokenTemplate
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.RequestSecurityTokenTemplate,
SecurityAssertionValidator {
    private boolean populated = false;
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    String tokenType;
    String requestType;
    Lifetime lifeTime;
    String authenticationType;
    private String keyType;
    private int keySize;
    private String sigAlgo;
    private String encAlgo;
    private String canonAlgo;
    private boolean isProofEncRequired = false;
    private String computedKeyAlgo;
    private boolean isEncRequired = false;
    private String signWith;
    private String encryptWith;
    private String keyWrapAlgo;
    private String wstVer;
    private Claims claims = null;

    public RequestSecurityTokenTemplate() {
    }

    public RequestSecurityTokenTemplate(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
    }

    @Override
    public String getTokenType() {
        this.populate();
        return this.tokenType;
    }

    @Override
    public String getRequestType() {
        this.populate();
        return this.requestType;
    }

    @Override
    public Lifetime getLifetime() {
        this.populate();
        return this.lifeTime;
    }

    @Override
    public String getAuthenticationType() {
        this.populate();
        return this.authenticationType;
    }

    @Override
    public String getKeyType() {
        this.populate();
        return this.keyType;
    }

    @Override
    public int getKeySize() {
        this.populate();
        return this.keySize;
    }

    @Override
    public String getSignatureAlgorithm() {
        this.populate();
        return this.sigAlgo;
    }

    @Override
    public String getEncryptionAlgorithm() {
        this.populate();
        return this.encAlgo;
    }

    @Override
    public String getCanonicalizationAlgorithm() {
        this.populate();
        return this.canonAlgo;
    }

    @Override
    public boolean getProofEncryptionRequired() {
        this.populate();
        return this.isProofEncRequired;
    }

    @Override
    public String getComputedKeyAlgorithm() {
        this.populate();
        return this.computedKeyAlgo;
    }

    @Override
    public String getKeyWrapAlgorithm() {
        this.populate();
        return this.keyWrapAlgo;
    }

    @Override
    public boolean getEncryptionRequired() {
        this.populate();
        return this.isEncRequired;
    }

    @Override
    public String getSignWith() {
        this.populate();
        return this.signWith;
    }

    @Override
    public String getEncryptWith() {
        this.populate();
        return this.encryptWith;
    }

    @Override
    public Claims getClaims() {
        this.populate();
        return this.claims;
    }

    @Override
    public String getTrustVersion() {
        this.populate();
        return this.wstVer;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            if (this.hasParameters()) {
                Iterator it = this.getParametersIterator();
                while (it.hasNext()) {
                    PolicyAssertion assertion = (PolicyAssertion)it.next();
                    if (this.wstVer == null) {
                        this.wstVer = assertion.getName().getNamespaceURI();
                    }
                    if (PolicyUtil.isKeyType(assertion)) {
                        this.keyType = assertion.getValue();
                        continue;
                    }
                    if (PolicyUtil.isKeySize(assertion)) {
                        this.keySize = Integer.parseInt(assertion.getValue());
                        continue;
                    }
                    if (PolicyUtil.isEncryption(assertion)) {
                        this.isEncRequired = true;
                        continue;
                    }
                    if (PolicyUtil.isProofEncryption(assertion)) {
                        this.isProofEncRequired = true;
                        continue;
                    }
                    if (PolicyUtil.isLifeTime(assertion)) {
                        this.lifeTime = (Lifetime)assertion;
                        continue;
                    }
                    if (PolicyUtil.isSignWith(assertion)) {
                        this.signWith = assertion.getValue();
                        continue;
                    }
                    if (PolicyUtil.isEncryptWith(assertion)) {
                        this.encryptWith = assertion.getValue();
                        continue;
                    }
                    if (PolicyUtil.isTrustTokenType(assertion)) {
                        this.tokenType = assertion.getValue();
                        continue;
                    }
                    if (PolicyUtil.isRequestType(assertion)) {
                        this.requestType = assertion.getValue();
                        continue;
                    }
                    if (PolicyUtil.isAuthenticationType(assertion)) {
                        this.authenticationType = assertion.getValue();
                        continue;
                    }
                    if (PolicyUtil.isSignatureAlgorithm(assertion)) {
                        this.sigAlgo = assertion.getValue();
                        continue;
                    }
                    if (PolicyUtil.isEncryptionAlgorithm(assertion)) {
                        this.encAlgo = assertion.getValue();
                        continue;
                    }
                    if (PolicyUtil.isCanonicalizationAlgorithm(assertion)) {
                        this.canonAlgo = assertion.getValue();
                        continue;
                    }
                    if (PolicyUtil.isComputedKeyAlgorithm(assertion)) {
                        this.computedKeyAlgo = assertion.getValue();
                        continue;
                    }
                    if (PolicyUtil.isKeyWrapAlgorithm(assertion)) {
                        this.keyWrapAlgo = assertion.getValue();
                        continue;
                    }
                    if (PolicyUtil.isEncryption(assertion)) {
                        this.isEncRequired = true;
                        continue;
                    }
                    if (PolicyUtil.isClaimsElement(assertion)) {
                        this.claims = (Claims)assertion;
                        continue;
                    }
                    if (PolicyUtil.isEntropyElement(assertion) || assertion.isOptional()) continue;
                    Constants.log_invalid_assertion(assertion, isServer, "RequestSecurityTokenTemplate");
                    this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
                }
            }
            this.populated = true;
        }
        return this.fitness;
    }
}

