/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.oauth1.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.oauth1.signature.OAuth1Request;
import org.glassfish.jersey.server.ContainerRequest;

public class OAuthServerRequest
implements OAuth1Request {
    private final ContainerRequestContext context;
    private static Set<String> EMPTY_SET = Collections.emptySet();
    private static List<String> EMPTY_LIST = Collections.emptyList();
    private final Value<MultivaluedMap<String, String>> formParams = Values.lazy((Value)new Value<MultivaluedMap<String, String>>(){

        public MultivaluedMap<String, String> get() {
            MultivaluedMap params = null;
            MediaType mediaType = OAuthServerRequest.this.context.getMediaType();
            if (mediaType != null && MediaTypes.typeEqual((MediaType)mediaType, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE)) {
                ContainerRequest jerseyRequest = (ContainerRequest)OAuthServerRequest.this.context;
                jerseyRequest.bufferEntity();
                Form form = (Form)jerseyRequest.readEntity(Form.class);
                params = form.asMap();
            }
            return params;
        }
    });

    public OAuthServerRequest(ContainerRequestContext context) {
        this.context = context;
    }

    public String getRequestMethod() {
        return this.context.getMethod();
    }

    public URL getRequestURL() {
        try {
            return this.context.getUriInfo().getRequestUri().toURL();
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(OAuthServerRequest.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static Set<String> keys(MultivaluedMap<String, String> mvm) {
        if (mvm == null) {
            return EMPTY_SET;
        }
        return mvm.keySet();
    }

    private static List<String> values(MultivaluedMap<String, String> mvm, String key) {
        if (mvm == null) {
            return EMPTY_LIST;
        }
        List v = (List)mvm.get((Object)key);
        if (v == null) {
            return EMPTY_LIST;
        }
        return v;
    }

    public Set<String> getParameterNames() {
        HashSet<String> n = new HashSet<String>();
        n.addAll(OAuthServerRequest.keys((MultivaluedMap<String, String>)this.context.getUriInfo().getQueryParameters()));
        n.addAll(OAuthServerRequest.keys((MultivaluedMap<String, String>)((MultivaluedMap)this.formParams.get())));
        return n;
    }

    public List<String> getParameterValues(String name) {
        ArrayList<String> v = new ArrayList<String>();
        v.addAll(OAuthServerRequest.values((MultivaluedMap<String, String>)this.context.getUriInfo().getQueryParameters(), name));
        v.addAll(OAuthServerRequest.values((MultivaluedMap<String, String>)((MultivaluedMap)this.formParams.get()), name));
        return v;
    }

    public List<String> getHeaderValues(String name) {
        return (List)this.context.getHeaders().get((Object)name);
    }

    public void addHeaderValue(String name, String value) throws IllegalStateException {
        throw new IllegalStateException("Modifying OAuthServerRequest unsupported");
    }
}

