/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.inject.cdi.se.bean;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.inject.Singleton;
import org.glassfish.jersey.inject.cdi.se.bean.JerseyBean;
import org.glassfish.jersey.internal.inject.InstanceBinding;

class InstanceBean<T>
extends JerseyBean<T> {
    private final InstanceBinding<T> binding;
    private InjectionTarget<T> injectionTarget;

    InstanceBean(InstanceBinding<T> binding) {
        super(binding);
        this.binding = binding;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return Singleton.class;
    }

    public T create(CreationalContext<T> context) {
        Object service = this.binding.getService();
        this.injectionTarget.inject(service, context);
        return (T)service;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.binding.getService().getClass();
    }

    void setInjectionTarget(InjectionTarget<T> injectionTarget) {
        this.injectionTarget = injectionTarget;
    }
}

