/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import org.glassfish.jersey.internal.util.JdkVersion;
import org.glassfish.jersey.internal.util.collection.LazyUnsafeValue;
import org.glassfish.jersey.internal.util.collection.Values;

final class ReflectionUtil {
    private static LazyUnsafeValue<Method, Exception> privateLookup = Values.lazy(() -> MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class));

    private ReflectionUtil() {
    }

    static <T> T createInstance(Class<T> tClass) {
        return (T)AccessController.doPrivileged(() -> {
            try {
                return tClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                throw new RuntimeException("No default constructor in class " + tClass + " present. Class cannot be created!", t);
            }
        });
    }

    static <T> T createProxyInstance(Class<T> restClientClass) {
        return (T)AccessController.doPrivileged(() -> Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{restClientClass}, (proxy, m, args) -> {
            MethodHandles.Lookup lookup = JdkVersion.getJdkVersion().getMajor() > 1 ? ReflectionUtil.privateLookupJDK11(restClientClass) : ReflectionUtil.privateLookupJDK8(restClientClass);
            return lookup.in(restClientClass).unreflectSpecial(m, restClientClass).bindTo(proxy).invokeWithArguments(args);
        }));
    }

    private static MethodHandles.Lookup privateLookupJDK11(Class<?> restClientClass) throws Exception {
        return (MethodHandles.Lookup)((Method)privateLookup.get()).invoke(null, restClientClass, MethodHandles.lookup());
    }

    private static MethodHandles.Lookup privateLookupJDK8(Class<?> restClientClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
        constructor.setAccessible(true);
        return (MethodHandles.Lookup)constructor.newInstance(restClientClass);
    }
}

